/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.ToolBarItem;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.selectedcontent.SelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerPeerListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.peer.PEPeerManager;
import org.gudy.azureus2.core3.peer.PEPeerStats;
import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.peer.util.PeerUtils;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.UIPluginViewToolBarListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.graphics.PieUtils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListenerEx;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventListenerHolder;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeersGraphicView
implements UISWTViewCoreEventListener,
UIPluginViewToolBarListener,
UISWTViewCoreEventListenerEx {
    public static String MSGID_PREFIX = "PeersGraphicView";
    private UISWTView swtView;
    private static final int PEER_SIZE = 18;
    private static final int OWN_SIZE_DEFAULT = 75;
    private static final int OWN_SIZE_MIN = 30;
    private static final int OWN_SIZE_MAX = 75;
    private static int OWN_SIZE = 75;
    private static final int NB_ANGLES = 1000;
    private double perimeter;
    private double[] rs;
    private final double[] angles;
    private final double[] deltaXXs;
    private final double[] deltaXYs;
    private final double[] deltaYXs;
    private final double[] deltaYYs;
    private PeerComparator peerComparator;
    private Image my_flag;
    private Display display;
    private Composite panel;
    private Map<DownloadManager, ManagerData> dm_map = new IdentityHashMap<DownloadManager, ManagerData>();
    private boolean comp_focused;
    private Object focus_pending_ds;

    public PeersGraphicView() {
        this.angles = new double[1000];
        this.rs = new double[1000];
        this.deltaXXs = new double[1000];
        this.deltaXYs = new double[1000];
        this.deltaYXs = new double[1000];
        this.deltaYYs = new double[1000];
        for (int i = 0; i < 1000; ++i) {
            this.angles[i] = (double)(2 * i) * Math.PI / 1000.0 - Math.PI;
            this.deltaXXs[i] = Math.cos(this.angles[i]);
            this.deltaXYs[i] = Math.sin(this.angles[i]);
            this.deltaYXs[i] = Math.cos(this.angles[i] + 1.5707963267948966);
            this.deltaYYs[i] = Math.sin(this.angles[i] + 1.5707963267948966);
        }
        this.peerComparator = new PeerComparator();
    }

    @Override
    public boolean isCloneable() {
        return true;
    }

    @Override
    public UISWTViewCoreEventListener getClone() {
        return new PeersGraphicView();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setFocused(boolean foc) {
        if (foc) {
            this.comp_focused = true;
            this.dataSourceChanged(this.focus_pending_ds);
        } else {
            Map<DownloadManager, ManagerData> map = this.dm_map;
            synchronized (map) {
                this.focus_pending_ds = this.dm_map.values().toArray(new DownloadManager[this.dm_map.size()]);
            }
            this.dataSourceChanged(null);
            this.comp_focused = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataSourceChanged(Object newDataSource) {
        InetAddress ia;
        if (!this.comp_focused) {
            this.focus_pending_ds = newDataSource;
            return;
        }
        if (this.my_flag == null && (ia = NetworkAdmin.getSingleton().getDefaultPublicAddress()) != null) {
            this.my_flag = ImageRepository.getCountryFlag(ia, false);
        }
        List<DownloadManager> newManagers = ViewUtils.getDownloadManagersFromDataSource(newDataSource);
        Map<DownloadManager, ManagerData> map = this.dm_map;
        synchronized (map) {
            ArrayList<DownloadManager> oldManagers = new ArrayList<DownloadManager>(this.dm_map.keySet());
            boolean changed = false;
            for (DownloadManager old : oldManagers) {
                if (newManagers.contains(old)) continue;
                this.dm_map.remove(old).delete();
                changed = true;
            }
            for (DownloadManager nu : newManagers) {
                if (oldManagers.contains(nu)) continue;
                this.dm_map.put(nu, new ManagerData(nu));
                changed = true;
            }
            if (!changed) {
                return;
            }
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (!PeersGraphicView.this.dm_map.isEmpty()) {
                        Utils.disposeComposite(PeersGraphicView.this.panel, false);
                    } else {
                        ViewUtils.setViewRequiresOneDownload(PeersGraphicView.this.panel);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete() {
        Map<DownloadManager, ManagerData> map = this.dm_map;
        synchronized (map) {
            for (Map.Entry<DownloadManager, ManagerData> dm_entry : this.dm_map.entrySet()) {
                ManagerData data = dm_entry.getValue();
                data.delete();
            }
            this.dm_map.clear();
        }
    }

    private Composite getComposite() {
        return this.panel;
    }

    private String getData() {
        return "PeersGraphicView.title.full";
    }

    private void initialize(Composite composite) {
        this.display = composite.getDisplay();
        this.panel = new Canvas(composite, 262144);
        this.panel.addListener(32, new Listener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                int x = event2.x;
                int y = event2.y;
                String tt = "";
                Map map = PeersGraphicView.this.dm_map;
                synchronized (map) {
                    for (Map.Entry dm_entry : PeersGraphicView.this.dm_map.entrySet()) {
                        DownloadManager manager = (DownloadManager)dm_entry.getKey();
                        ManagerData data = (ManagerData)dm_entry.getValue();
                        if (x >= data.me_hit_x && x <= data.me_hit_x + OWN_SIZE && y >= data.me_hit_y && y <= data.me_hit_y + OWN_SIZE) {
                            if (PeersGraphicView.this.dm_map.size() > 1) {
                                tt = manager.getDisplayName() + "\r\n";
                            }
                            tt = tt + DisplayFormatters.formatDownloadStatus(manager) + ", " + DisplayFormatters.formatPercentFromThousands(manager.getStats().getCompleted());
                            break;
                        }
                        PEPeer target = null;
                        for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                            int[] loc = (int[])entry.getValue();
                            int loc_x = loc[0];
                            int loc_y = loc[1];
                            if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                            target = (PEPeer)entry.getKey();
                            break;
                        }
                        if (target == null) continue;
                        PEPeerStats stats2 = target.getStats();
                        String[] details = PeerUtils.getCountryDetails(target);
                        String dstr = details == null || details.length < 2 ? "" : " - " + details[0] + "/" + details[1];
                        tt = target.getIp() + dstr + ", " + DisplayFormatters.formatPercentFromThousands(target.getPercentDoneInThousandNotation()) + "\r\n" + "Up=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataSendRate() + stats2.getProtocolSendRate()) + ", " + "Down=" + DisplayFormatters.formatByteCountToKiBEtcPerSec(stats2.getDataReceiveRate() + stats2.getProtocolReceiveRate());
                        break;
                    }
                }
                PeersGraphicView.this.panel.setToolTipText(tt);
            }
        });
        this.panel.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent event2) {
                if (event2.button == 3) {
                    int x = event2.x;
                    int y = event2.y;
                    PEPeer target = null;
                    DownloadManager target_manager = null;
                    Map map = PeersGraphicView.this.dm_map;
                    synchronized (map) {
                        for (Map.Entry dm_entry : PeersGraphicView.this.dm_map.entrySet()) {
                            DownloadManager manager = (DownloadManager)dm_entry.getKey();
                            ManagerData data = (ManagerData)dm_entry.getValue();
                            for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                                int[] loc = (int[])entry.getValue();
                                int loc_x = loc[0];
                                int loc_y = loc[1];
                                if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                                target = (PEPeer)entry.getKey();
                                target_manager = manager;
                                break;
                            }
                            if (target == null) continue;
                            break;
                        }
                    }
                    if (target == null) {
                        return;
                    }
                    Menu menu = PeersGraphicView.this.panel.getMenu();
                    if (menu != null && !menu.isDisposed()) {
                        menu.dispose();
                    }
                    menu = new Menu((Control)PeersGraphicView.this.panel);
                    PeersView.fillMenu(menu, target, target_manager);
                    Point cursorLocation = Display.getCurrent().getCursorLocation();
                    menu.setLocation(cursorLocation.x, cursorLocation.y);
                    menu.setVisible(true);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseDoubleClick(MouseEvent event2) {
                int x = event2.x;
                int y = event2.y;
                Map map = PeersGraphicView.this.dm_map;
                synchronized (map) {
                    block5: for (Map.Entry dm_entry : PeersGraphicView.this.dm_map.entrySet()) {
                        DownloadManager manager = (DownloadManager)dm_entry.getKey();
                        ManagerData data = (ManagerData)dm_entry.getValue();
                        for (Map.Entry entry : data.peer_hit_map.entrySet()) {
                            int[] loc = (int[])entry.getValue();
                            int loc_x = loc[0];
                            int loc_y = loc[1];
                            if (x < loc_x || x > loc_x + 18 || y < loc_y || y > loc_y + 18) continue;
                            PEPeer target = (PEPeer)entry.getKey();
                            try {
                                String dm_id = "DMDetails_" + Base32.encode(manager.getTorrent().getHash());
                                MdiEntry mdi_entry = UIFunctionsManager.getUIFunctions().getMDI().getEntry(dm_id);
                                if (mdi_entry != null) {
                                    mdi_entry.setDatasource(new Object[]{manager, target});
                                }
                                for (Composite comp2 = PeersGraphicView.this.panel.getParent(); comp2 != null; comp2 = comp2.getParent()) {
                                    CTabItem[] items;
                                    if (!(comp2 instanceof CTabFolder)) continue;
                                    CTabFolder tf = (CTabFolder)comp2;
                                    for (CTabItem item : items = tf.getItems()) {
                                        UISWTViewCore view = (UISWTViewCore)item.getData("TabbedEntry");
                                        UISWTViewEventListener listener = view.getEventListener();
                                        if (listener instanceof UISWTViewEventListenerHolder) {
                                            listener = ((UISWTViewEventListenerHolder)listener).getDelegatedEventListener(view);
                                        }
                                        if (!(listener instanceof PeersView)) continue;
                                        tf.setSelection(item);
                                        Event ev = new Event();
                                        ev.item = item;
                                        tf.notifyListeners(13, ev);
                                        ((PeersView)listener).selectPeer(target);
                                        return;
                                    }
                                }
                                continue block5;
                            }
                            catch (Throwable e) {
                                continue block5;
                            }
                        }
                    }
                }
            }
        });
        this.panel.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                PeersGraphicView.this.doRefresh();
            }
        });
    }

    private void refresh() {
        this.doRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRefresh() {
        Map<DownloadManager, ManagerData> map = this.dm_map;
        synchronized (map) {
            int rem_y;
            int factor;
            double f;
            int h_cells;
            int v_cells;
            if (this.panel == null || this.panel.isDisposed()) {
                return;
            }
            if (this.dm_map.size() == 0) {
                GC gcPanel = new GC((Drawable)this.panel);
                gcPanel.fillRectangle(this.panel.getBounds());
                gcPanel.dispose();
                return;
            }
            int num_dms = this.dm_map.size();
            Point panelSize = this.panel.getSize();
            int ph = panelSize.y;
            int pw = panelSize.x;
            if (ph <= pw) {
                v_cells = 1;
                h_cells = pw / ph;
                f = Math.sqrt((double)num_dms / (double)(v_cells * h_cells));
                factor = (int)Math.ceil(f);
                h_cells *= factor;
                v_cells = factor;
            } else {
                v_cells = ph / pw;
                h_cells = 1;
                f = Math.sqrt((double)num_dms / (double)(v_cells * h_cells));
                factor = (int)Math.ceil(f);
                v_cells *= factor;
                h_cells = factor;
            }
            ph = h_cells == 1 ? ph / num_dms : ph / v_cells;
            pw = v_cells == 1 ? pw / num_dms : pw / h_cells;
            Point mySize = new Point(pw, ph);
            int num = 0;
            Point lastOffset = null;
            for (Map.Entry<DownloadManager, ManagerData> dm_entry : this.dm_map.entrySet()) {
                Object var21_28;
                PEPeer[] sortedPeers;
                DownloadManager manager = dm_entry.getKey();
                ManagerData data = dm_entry.getValue();
                try {
                    data.peers_mon.enter();
                    ArrayList<PEPeerTransport> connectedPeers = new ArrayList<PEPeerTransport>();
                    for (PEPeer peer : data.peers) {
                        PEPeerTransport peerTransport;
                        if (!(peer instanceof PEPeerTransport) || (peerTransport = (PEPeerTransport)peer).getConnectionState() != 4) continue;
                        connectedPeers.add(peerTransport);
                    }
                    sortedPeers = connectedPeers.toArray(new PEPeer[connectedPeers.size()]);
                    var21_28 = null;
                    data.peers_mon.exit();
                }
                catch (Throwable throwable) {
                    var21_28 = null;
                    data.peers_mon.exit();
                    throw throwable;
                }
                if (sortedPeers == null) {
                    return;
                }
                for (int i = 0; i < 3; ++i) {
                    try {
                        Arrays.sort(sortedPeers, this.peerComparator);
                        break;
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                }
                int h = num % h_cells;
                int v = num / h_cells;
                Point myOffset = new Point(h * pw, v * ph);
                this.render(manager, data, sortedPeers, mySize, myOffset);
                ++num;
                lastOffset = myOffset;
            }
            int rem_x = panelSize.x - (lastOffset.x + mySize.x);
            if (rem_x > 0) {
                GC gcPanel = new GC((Drawable)this.panel);
                gcPanel.setBackground(Colors.white);
                gcPanel.fillRectangle(lastOffset.x + mySize.x, lastOffset.y, rem_x, mySize.y);
                gcPanel.dispose();
            }
            if ((rem_y = panelSize.y - (lastOffset.y + mySize.y)) > 0) {
                GC gcPanel = new GC((Drawable)this.panel);
                gcPanel.setBackground(Colors.white);
                gcPanel.fillRectangle(0, lastOffset.y + mySize.y, panelSize.x, rem_y);
                gcPanel.dispose();
            }
        }
    }

    private void render(DownloadManager manager, ManagerData data, PEPeer[] sortedPeers, Point panelSize, Point panelOffset) {
        data.peer_hit_map.clear();
        int min_dim = Math.min(panelSize.x, panelSize.y);
        if (min_dim <= 100) {
            OWN_SIZE = 30;
        } else if (min_dim >= 400) {
            OWN_SIZE = 75;
        } else {
            int s_diff = 45;
            float rat = ((float)min_dim - 100.0f) / 300.0f;
            OWN_SIZE = 30 + (int)((float)s_diff * rat);
        }
        int x0 = panelSize.x / 2;
        int y0 = panelSize.y / 2;
        int a = x0 - 20;
        int b = y0 - 20;
        if (a < 10 || b < 10) {
            GC gcPanel = new GC((Drawable)this.panel);
            gcPanel.setBackground(Colors.white);
            gcPanel.fillRectangle(panelOffset.x, panelOffset.y, panelSize.x, panelSize.y);
            gcPanel.dispose();
            return;
        }
        if (data.oldSize == null || !data.oldSize.equals((Object)panelSize)) {
            data.oldSize = panelSize;
            this.perimeter = 0.0;
            for (int i = 0; i < 1000; ++i) {
                this.rs[i] = Math.sqrt(1.0 / (this.deltaYXs[i] * this.deltaYXs[i] / (double)(a * a) + this.deltaYYs[i] * this.deltaYYs[i] / (double)(b * b)));
                this.perimeter += this.rs[i];
            }
        }
        Image buffer = new Image((Device)this.display, panelSize.x, panelSize.y);
        GC gcBuffer = new GC((Drawable)buffer);
        gcBuffer.setBackground(Colors.white);
        gcBuffer.setForeground(Colors.blue);
        gcBuffer.fillRectangle(0, 0, panelSize.x, panelSize.y);
        try {
            gcBuffer.setTextAntialias(1);
            gcBuffer.setAntialias(1);
        }
        catch (Exception e) {
            // empty catch block
        }
        gcBuffer.setBackground(Colors.blues[2]);
        int nbPeers = sortedPeers.length;
        int iAngle = 0;
        double currentPerimeter = 0.0;
        for (int i = 0; i < nbPeers; ++i) {
            int y1;
            int x1;
            double r;
            PEPeer peer = sortedPeers[i];
            do {
                r = this.rs[iAngle];
                currentPerimeter += r;
                if (iAngle + 1 >= 1000) continue;
                ++iAngle;
            } while (currentPerimeter < (double)i * this.perimeter / (double)nbPeers);
            int[] triangle = new int[6];
            int percent_received = peer.getPercentDoneOfCurrentIncomingRequest();
            int percent_sent = peer.getPercentDoneOfCurrentOutgoingRequest();
            boolean drawLine = false;
            if (!peer.isChokingMe() || percent_received >= 0) {
                gcBuffer.setForeground(Colors.blues[1]);
                drawLine = true;
            }
            if (!peer.isChokedByMe() || percent_sent >= 0) {
                gcBuffer.setForeground(Colors.blues[3]);
                drawLine = true;
            }
            if (!peer.isChokingMe() && peer.isUnchokeOverride() && peer.isInteresting()) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            if (peer.isChokedByMe() && percent_sent >= 0) {
                gcBuffer.setForeground(Colors.green);
                drawLine = true;
            }
            if (drawLine) {
                x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
                y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
                gcBuffer.drawLine(x0, y0, x1, y1);
            }
            if (percent_received >= 0) {
                gcBuffer.setBackground(Colors.blues[7]);
                double r1 = r - r * (double)percent_received / 100.0;
                triangle[0] = (int)((double)x0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[1] = (int)((double)y0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                triangle[2] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[3] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                triangle[4] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[5] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + r1 * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(triangle);
            }
            if (percent_sent >= 0) {
                gcBuffer.setBackground(Colors.blues[2]);
                double r1 = r * (double)percent_sent / 100.0;
                triangle[0] = (int)((double)x0 + r1 * this.deltaYXs[iAngle] + 0.5);
                triangle[1] = (int)((double)y0 + r1 * this.deltaYYs[iAngle] + 0.5);
                triangle[2] = (int)((double)x0 + this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[3] = (int)((double)y0 + this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                triangle[4] = (int)((double)x0 - this.deltaXXs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYXs[iAngle] + 0.5);
                triangle[5] = (int)((double)y0 - this.deltaXYs[iAngle] * 4.0 + (r1 - 10.0) * this.deltaYYs[iAngle] + 0.5);
                gcBuffer.fillPolygon(triangle);
            }
            x1 = x0 + (int)(r * this.deltaYXs[iAngle]);
            y1 = y0 + (int)(r * this.deltaYYs[iAngle]);
            gcBuffer.setBackground(Colors.blues[7]);
            if (peer.isSnubbed()) {
                gcBuffer.setBackground(Colors.grey);
            }
            int peer_x = x1 - 9;
            int peer_y = y1 - 9;
            data.peer_hit_map.put(peer, new int[]{peer_x + panelOffset.x, peer_y + panelOffset.y});
            Image flag = ImageRepository.getCountryFlag(peer, false);
            if (flag != null) {
                PieUtils.drawPie(gcBuffer, flag, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10, true);
                continue;
            }
            PieUtils.drawPie(gcBuffer, peer_x, peer_y, 18, 18, peer.getPercentDoneInThousandNotation() / 10);
        }
        gcBuffer.setBackground(Colors.blues[7]);
        data.me_hit_x = x0 - PeersGraphicView.OWN_SIZE / 2;
        data.me_hit_y = y0 - PeersGraphicView.OWN_SIZE / 2;
        PieUtils.drawPie(gcBuffer, data.me_hit_x, data.me_hit_y, OWN_SIZE, OWN_SIZE, manager.getStats().getCompleted() / 10);
        if (this.my_flag != null) {
            PieUtils.drawPie(gcBuffer, this.my_flag, data.me_hit_x, data.me_hit_y, OWN_SIZE, OWN_SIZE, manager.getStats().getCompleted() / 10, false);
        }
        data.me_hit_x += panelOffset.x;
        data.me_hit_y += panelOffset.y;
        gcBuffer.dispose();
        GC gcPanel = new GC((Drawable)this.panel);
        gcPanel.drawImage(buffer, panelOffset.x, panelOffset.y);
        gcPanel.dispose();
        buffer.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = event2.getView();
                this.swtView.setTitle(MessageText.getString(this.getData()));
                this.swtView.setToolBarListener(this);
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                this.swtView.setTitle(MessageText.getString(this.getData()));
                break;
            }
            case 1: {
                this.dataSourceChanged(event2.getData());
                break;
            }
            case 3: {
                String id = "DMDetails_Swarm";
                this.setFocused(true);
                Map<DownloadManager, ManagerData> map = this.dm_map;
                synchronized (map) {
                    if (this.dm_map.isEmpty()) {
                        SelectedContentManager.changeCurrentlySelectedContent(id, null);
                    } else {
                        DownloadManager manager = this.dm_map.keySet().iterator().next();
                        id = manager.getTorrent() != null ? id + "." + manager.getInternalName() : id + ":" + manager.getSize();
                        SelectedContentManager.changeCurrentlySelectedContent(id, new SelectedContent[]{new SelectedContent(manager)});
                    }
                    break;
                }
            }
            case 4: {
                this.setFocused(false);
                SelectedContentManager.clearCurrentlySelectedContent();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    @Override
    public boolean toolBarItemActivated(ToolBarItem item, long activationType, Object datasource) {
        return false;
    }

    @Override
    public void refreshToolBarItems(Map<String, Long> list) {
        Map<String, Long> states = TorrentUtil.calculateToolbarStates(SelectedContentManager.getCurrentlySelectedContent(), null);
        list.putAll(states);
    }

    private class ManagerData
    implements DownloadManagerPeerListener {
        private AEMonitor peers_mon = new AEMonitor("PeersGraphicView:peers");
        private DownloadManager manager;
        private Point oldSize;
        private List<PEPeer> peers;
        private Map<PEPeer, int[]> peer_hit_map = new HashMap<PEPeer, int[]>();
        private int me_hit_x;
        private int me_hit_y;

        private ManagerData(DownloadManager _manager) {
            this.manager = _manager;
            this.peers = new ArrayList<PEPeer>();
            this.manager.addPeerListener(this);
        }

        private void delete() {
            this.manager.removePeerListener(this);
            this.peer_hit_map.clear();
        }

        public void peerManagerWillBeAdded(PEPeerManager peer_manager) {
        }

        public void peerManagerAdded(PEPeerManager manager) {
        }

        public void peerManagerRemoved(PEPeerManager manager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void peerAdded(PEPeer peer) {
            try {
                this.peers_mon.enter();
                this.peers.add(peer);
                Object var3_2 = null;
                this.peers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.peers_mon.exit();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void peerRemoved(PEPeer peer) {
            try {
                this.peers_mon.enter();
                this.peers.remove(peer);
                Object var3_2 = null;
                this.peers_mon.exit();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.peers_mon.exit();
                throw throwable;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PeerComparator
    implements Comparator<PEPeer> {
        private PeerComparator() {
        }

        @Override
        public int compare(PEPeer peer0, PEPeer peer1) {
            int percent1;
            int percent0 = peer0.getPercentDoneInThousandNotation();
            int result = percent0 - (percent1 = peer1.getPercentDoneInThousandNotation());
            if (result == 0) {
                long l = peer0.getTimeSinceConnectionEstablished() - peer1.getTimeSinceConnectionEstablished();
                if (l < 0L) {
                    result = -1;
                } else if (l > 0L) {
                    result = 1;
                }
            }
            return result;
        }
    }
}

