/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagException;
import com.aelitis.azureus.core.tag.TagFeatureFileLocation;
import com.aelitis.azureus.core.tag.TagFeatureLimits;
import com.aelitis.azureus.core.tag.TagFeatureProperties;
import com.aelitis.azureus.core.tag.TagFeatureRateLimit;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.util.GeneralUtils;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import com.aelitis.azureus.ui.swt.utils.FontUtils;
import java.io.File;
import java.util.HashSet;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.ColorParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericBooleanParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericFloatParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericIntParameter;
import org.gudy.azureus2.ui.swt.config.generic.GenericParameterAdapter;
import org.gudy.azureus2.ui.swt.config.generic.GenericStringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.bouncycastle.util.Arrays;

public class TagSettingsView
implements UISWTViewCoreEventListener,
TagTypeListener {
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private Tag[] tags;
    private Params params = null;
    private Button btnSaveConstraint;
    private Button btnResetConstraint;

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        this.dataSourceChanged(null);
        this.params = null;
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        TagType tagType;
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                tagType = tag.getTagType();
                tagType.removeTagTypeListener(this);
            }
        }
        if (ds instanceof Tag) {
            this.tags = new Tag[]{(Tag)ds};
        } else if (ds instanceof Object[]) {
            Object[] objects = (Object[])ds;
            if (objects[0] instanceof Tag) {
                this.tags = new Tag[objects.length];
                System.arraycopy(objects, 0, this.tags, 0, this.tags.length);
            } else {
                this.tags = null;
            }
        } else {
            this.tags = null;
        }
        if (this.tags != null) {
            for (Tag tag : this.tags) {
                tagType = tag.getTagType();
                tagType.removeTagTypeListener(this);
                tagType.addTagTypeListener(this, false);
            }
        }
        this.initialize(null);
    }

    private void initialize(final Composite parent) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                TagSettingsView.this.swt_initialize(parent);
            }
        });
    }

    private void swt_initialize(Composite parent) {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (parent == null || parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                Utils.setLayoutData((Control)this.sc, gd);
            } else if (parentLayout instanceof FormLayout) {
                Utils.setLayoutData((Control)this.sc, Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        if (this.tags == null) {
            this.params = null;
            this.cMainComposite.setLayout((Layout)new FillLayout());
            Label label = new Label(this.cMainComposite, 0);
            label.setText(MessageText.getString("tag.settings.select.tag"));
        } else {
            TagFeatureLimits tfl;
            TagFeatureProperties tfp;
            TagFeatureProperties.TagProperty propConstraint;
            TagFeatureFileLocation fl;
            final int numTags = this.tags.length;
            int isTagVisible = -1;
            int canBePublic = -1;
            int[] tagColor = this.tags[0].getColor();
            boolean tagsAreTagFeatureRateLimit = true;
            HashSet<String> listTagTypes = new HashSet<String>();
            for (Tag tag : this.tags) {
                int[] color;
                TagType tt = tag.getTagType();
                String s = tt.getTagTypeName(true);
                listTagTypes.add(s);
                if (tagsAreTagFeatureRateLimit && !(tag instanceof TagFeatureRateLimit)) {
                    tagsAreTagFeatureRateLimit = false;
                }
                isTagVisible = this.updateIntBoolean(tag.isVisible(), isTagVisible);
                canBePublic = this.updateIntBoolean(tag.canBePublic(), canBePublic);
                if (tagColor == null || Arrays.areEqual(tagColor, color = tag.getColor())) continue;
                tagColor = null;
            }
            String tagTypes = GeneralUtils.stringJoin(listTagTypes, ", ");
            this.params = new Params();
            GridLayout gridLayout = new GridLayout(1, false);
            gridLayout.verticalSpacing = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            this.cMainComposite.setLayout((Layout)gridLayout);
            Composite cSection1 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(4, false);
            gridLayout.marginHeight = 0;
            cSection1.setLayout((Layout)gridLayout);
            GridData gd = new GridData(4, 4, true, false);
            cSection1.setLayoutData((Object)gd);
            Composite cSection2 = new Composite(this.cMainComposite, 0);
            gridLayout = new GridLayout(4, false);
            cSection2.setLayout((Layout)gridLayout);
            gd = new GridData(4, 4, true, false);
            cSection2.setLayoutData((Object)gd);
            Label label = new Label(cSection1, 0);
            FontUtils.setFontHeight((Control)label, 12, 1);
            gd = new GridData();
            gd.horizontalSpan = 4;
            Utils.setLayoutData((Control)label, gd);
            label.setText(tagTypes);
            label = new Label(cSection1, 0);
            Messages.setLanguageText((Widget)label, "MinimizedWindow.name");
            gd = new GridData(1, 0x1000000, false, false);
            Utils.setLayoutData((Control)label, gd);
            if (numTags == 1 && !this.tags[0].getTagType().isTagTypeAuto()) {
                Text txtName = new Text(cSection1, 2048);
                this.params.cName = (Control)txtName;
                gd = new GridData(4, 0x1000000, true, false);
                Utils.setLayoutData((Control)txtName, gd);
                txtName.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        try {
                            String newName = ((Text)e.widget).getText();
                            if (!TagSettingsView.this.tags[0].getTagName(true).equals(newName)) {
                                TagSettingsView.this.tags[0].setTagName(newName);
                            }
                        }
                        catch (TagException e1) {
                            Debug.out(e1);
                        }
                    }
                });
            } else {
                label = new Label(cSection1, 64);
                gd = Utils.getWrappableLabelGridData(1, 512);
                Utils.setLayoutData((Control)label, gd);
                this.params.cName = (Control)label;
            }
            label = new Label(cSection1, 0);
            Messages.setLanguageText((Widget)label, "label.color");
            if (tagColor == null) {
                tagColor = new int[]{0, 0, 0};
            }
            this.params.tagColor = new ColorParameter(cSection1, null, tagColor[0], tagColor[1], tagColor[2]){

                public void newColorChosen(RGB newColor) {
                    for (Tag tag : TagSettingsView.this.tags) {
                        tag.setColor(new int[]{newColor.red, newColor.green, newColor.blue});
                    }
                }
            };
            this.params.viewInSideBar = new GenericBooleanParameter((GenericParameterAdapter)new BooleanParameterAdapter(){

                public Boolean getBooleanValue(String key) {
                    int isTagVisible = -1;
                    for (Tag tag : TagSettingsView.this.tags) {
                        isTagVisible = TagSettingsView.this.updateIntBoolean(tag.isVisible(), isTagVisible);
                    }
                    return isTagVisible == 2 ? null : Boolean.valueOf(isTagVisible == 1);
                }

                public void setBooleanValue(String key, boolean value) {
                    for (Tag tag : TagSettingsView.this.tags) {
                        tag.setVisible(value);
                    }
                }
            }, cSection2, null, "TagSettings.viewInSideBar");
            gd = new GridData();
            gd.horizontalSpan = 4;
            this.params.viewInSideBar.setLayoutData(gd);
            if (canBePublic == 1) {
                this.params.isPublic = new GenericBooleanParameter((GenericParameterAdapter)new BooleanParameterAdapter(){

                    public Boolean getBooleanValue(String key) {
                        int val = -1;
                        for (Tag tag : TagSettingsView.this.tags) {
                            val = TagSettingsView.this.updateIntBoolean(tag.isPublic(), val);
                        }
                        return val == 2 ? null : Boolean.valueOf(val == 1);
                    }

                    public void setBooleanValue(String key, boolean value) {
                        for (Tag tag : TagSettingsView.this.tags) {
                            tag.setPublic(value);
                        }
                    }
                }, cSection2, null, "TagAddWindow.public.checkbox");
                gd = new GridData();
                gd.horizontalSpan = 4;
                this.params.isPublic.setLayoutData(gd);
            }
            Group gTransfer = new Group(this.cMainComposite, 0);
            gTransfer.setText(MessageText.getString("label.transfer.settings"));
            gridLayout = new GridLayout(6, false);
            gTransfer.setLayout((Layout)gridLayout);
            gd = new GridData(4, 0, false, false, 4, 1);
            gTransfer.setLayoutData((Object)gd);
            if (tagsAreTagFeatureRateLimit) {
                String[] ST_ACTION_LABELS;
                final TagFeatureRateLimit[] rls = new TagFeatureRateLimit[this.tags.length];
                System.arraycopy(this.tags, 0, rls, 0, this.tags.length);
                boolean supportsTagDownloadLimit = true;
                boolean supportsTagUploadLimit = true;
                boolean hasTagUploadPriority = true;
                for (TagFeatureRateLimit rl : rls) {
                    supportsTagDownloadLimit &= rl.supportsTagDownloadLimit();
                    supportsTagUploadLimit &= rl.supportsTagUploadLimit();
                    hasTagUploadPriority &= rl.getTagUploadPriority() >= 0;
                }
                String k_unit = DisplayFormatters.getRateUnitBase10(1).trim();
                int cols_used = 0;
                if (supportsTagDownloadLimit) {
                    gd = new GridData();
                    label = new Label((Composite)gTransfer, 0);
                    Utils.setLayoutData((Control)label, gd);
                    label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxdownloadspeed.tooltip"));
                    gd = new GridData();
                    this.params.maxDownloadSpeed = new GenericIntParameter(new GenericParameterAdapter(){

                        public int getIntValue(String key) {
                            int limit = rls[0].getTagDownloadLimit();
                            if (numTags > 1) {
                                for (int i = 1; i < rls.length; ++i) {
                                    int nextLimit = rls[i].getTagDownloadLimit();
                                    if (nextLimit == limit) continue;
                                    return 0;
                                }
                            }
                            return limit < 0 ? limit : limit / DisplayFormatters.getKinB();
                        }

                        public int getIntValue(String key, int def) {
                            return this.getIntValue(key);
                        }

                        public void setIntValue(String key, int value) {
                            for (TagFeatureRateLimit rl : rls) {
                                if (value == -1) {
                                    rl.setTagDownloadLimit(-1);
                                    continue;
                                }
                                rl.setTagDownloadLimit(value * DisplayFormatters.getKinB());
                            }
                        }

                        public boolean resetIntDefault(String key) {
                            return false;
                        }
                    }, (Composite)gTransfer, null, -1, Integer.MAX_VALUE);
                    this.params.maxDownloadSpeed.setLayoutData(gd);
                    this.params.maxDownloadSpeed.setZeroHidden(numTags > 1);
                    cols_used += 2;
                }
                if (supportsTagUploadLimit) {
                    gd = new GridData();
                    label = new Label((Composite)gTransfer, 0);
                    Utils.setLayoutData((Control)label, gd);
                    label.setText(k_unit + " " + MessageText.getString("GeneralView.label.maxuploadspeed.tooltip"));
                    gd = new GridData();
                    this.params.maxUploadSpeed = new GenericIntParameter(new GenericParameterAdapter(){

                        public int getIntValue(String key) {
                            int limit = rls[0].getTagUploadLimit();
                            if (numTags > 1) {
                                for (int i = 1; i < rls.length; ++i) {
                                    int nextLimit = rls[i].getTagUploadLimit();
                                    if (nextLimit == limit) continue;
                                    return 0;
                                }
                            }
                            return limit < 0 ? limit : limit / DisplayFormatters.getKinB();
                        }

                        public int getIntValue(String key, int def) {
                            return this.getIntValue(key);
                        }

                        public void setIntValue(String key, int value) {
                            for (TagFeatureRateLimit rl : rls) {
                                if (value == -1) {
                                    rl.setTagUploadLimit(value);
                                    continue;
                                }
                                rl.setTagUploadLimit(value * DisplayFormatters.getKinB());
                            }
                        }

                        public boolean resetIntDefault(String key) {
                            return false;
                        }
                    }, (Composite)gTransfer, null, -1, Integer.MAX_VALUE);
                    this.params.maxUploadSpeed.setLayoutData(gd);
                    this.params.maxUploadSpeed.setZeroHidden(numTags > 1);
                    cols_used += 2;
                }
                if (hasTagUploadPriority) {
                    this.params.uploadPriority = new GenericBooleanParameter((GenericParameterAdapter)new BooleanParameterAdapter(){

                        public Boolean getBooleanValue(String key) {
                            int value = -1;
                            for (TagFeatureRateLimit rl : rls) {
                                value = TagSettingsView.this.updateIntBoolean(rl.getTagUploadPriority() > 0, value);
                            }
                            return value == 2 ? null : Boolean.valueOf(value == 1);
                        }

                        public void setBooleanValue(String key, boolean value) {
                            for (TagFeatureRateLimit rl : rls) {
                                rl.setTagUploadPriority(value ? 1 : 0);
                            }
                        }
                    }, (Composite)gTransfer, null, "cat.upload.priority");
                    gd = new GridData();
                    gd.horizontalSpan = 6 - cols_used;
                    this.params.uploadPriority.setLayoutData(gd);
                }
                if (numTags == 1 && rls[0].getTagMinShareRatio() >= 0) {
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "TableColumn.header.min_sr");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.min_sr = new GenericFloatParameter(new GenericParameterAdapter(){

                        public float getFloatValue(String key) {
                            return (float)rls[0].getTagMinShareRatio() / 1000.0f;
                        }

                        public void setFloatValue(String key, float value) {
                            rls[0].setTagMinShareRatio((int)(value * 1000.0f));
                        }
                    }, (Composite)gTransfer, null, 0.0f, Float.MAX_VALUE, true, 3);
                    gd = new GridData();
                    gd.widthHint = 75;
                    this.params.min_sr.setLayoutData(gd);
                }
                if (numTags == 1 && rls[0].getTagMaxShareRatio() >= 0) {
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "TableColumn.header.max_sr");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.max_sr = new GenericFloatParameter(new GenericParameterAdapter(){

                        public float getFloatValue(String key) {
                            return (float)rls[0].getTagMaxShareRatio() / 1000.0f;
                        }

                        public void setFloatValue(String key, float value) {
                            rls[0].setTagMaxShareRatio((int)(value * 1000.0f));
                            TagSettingsView.this.updateTagSRParams(TagSettingsView.this.params);
                        }
                    }, (Composite)gTransfer, null, 0.0f, Float.MAX_VALUE, true, 3);
                    gd = new GridData();
                    gd.widthHint = 75;
                    this.params.max_sr.setLayoutData(gd);
                    String[] ST_ACTION_VALUES = new String[]{"0", "1", "2"};
                    ST_ACTION_LABELS = new String[]{MessageText.getString("ConfigView.section.queue"), MessageText.getString("v3.MainWindow.button.pause"), MessageText.getString("v3.MainWindow.button.stop")};
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "label.when.exceeded");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.max_sr_action = new GenericStringListParameter(new GenericParameterAdapter(){

                        public String getStringListValue(String key, String def) {
                            return this.getStringListValue(key);
                        }

                        public String getStringListValue(String key) {
                            return "" + rls[0].getTagMaxShareRatioAction();
                        }

                        public void setStringListValue(String key, String value) {
                            rls[0].setTagMaxShareRatioAction(Integer.parseInt(value));
                        }
                    }, (Composite)gTransfer, "max_sr_action", "0", ST_ACTION_LABELS, ST_ACTION_VALUES);
                }
                if (numTags == 1 && rls[0].getTagAggregateShareRatio() >= 0) {
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "TableColumn.header.max_aggregate_sr");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.max_aggregate_sr = new GenericFloatParameter(new GenericParameterAdapter(){

                        public float getFloatValue(String key) {
                            return (float)rls[0].getTagMaxAggregateShareRatio() / 1000.0f;
                        }

                        public void setFloatValue(String key, float value) {
                            rls[0].setTagMaxAggregateShareRatio((int)(value * 1000.0f));
                            TagSettingsView.this.updateTagSRParams(TagSettingsView.this.params);
                        }
                    }, (Composite)gTransfer, null, 0.0f, Float.MAX_VALUE, true, 3);
                    gd = new GridData();
                    gd.widthHint = 75;
                    this.params.max_aggregate_sr.setLayoutData(gd);
                    String[] ST_ACTION_VALUES = new String[]{"1", "2"};
                    ST_ACTION_LABELS = new String[]{MessageText.getString("v3.MainWindow.button.pause"), MessageText.getString("v3.MainWindow.button.stop")};
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "label.when.exceeded");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.max_aggregate_sr_action = new GenericStringListParameter(new GenericParameterAdapter(){

                        public String getStringListValue(String key, String def) {
                            return this.getStringListValue(key);
                        }

                        public String getStringListValue(String key) {
                            return "" + rls[0].getTagMaxAggregateShareRatioAction();
                        }

                        public void setStringListValue(String key, String value) {
                            rls[0].setTagMaxAggregateShareRatioAction(Integer.parseInt(value));
                        }
                    }, (Composite)gTransfer, "max_aggregate_sr_action", "1", ST_ACTION_LABELS, ST_ACTION_VALUES);
                    label = new Label((Composite)gTransfer, 0);
                    Messages.setLanguageText((Widget)label, "label.aggregate.has.priority");
                    gd = new GridData(1, 0x1000000, false, false);
                    Utils.setLayoutData((Control)label, gd);
                    this.params.max_aggregate_sr_priority = new GenericBooleanParameter((GenericParameterAdapter)new BooleanParameterAdapter(){

                        public Boolean getBooleanValue(String key) {
                            return rls[0].getTagMaxAggregateShareRatioHasPriority();
                        }

                        public void setBooleanValue(String key, boolean value) {
                            rls[0].setTagMaxAggregateShareRatioHasPriority(value);
                        }
                    }, (Composite)gTransfer, "max_aggregate_sr_priority", true);
                    this.updateTagSRParams(this.params);
                }
            }
            if (numTags == 1 && this.tags[0] instanceof TagFeatureFileLocation && ((fl = (TagFeatureFileLocation)((Object)this.tags[0])).supportsTagCopyOnComplete() || fl.supportsTagInitialSaveFolder() || fl.supportsTagMoveOnComplete())) {
                Group gFiles = new Group(this.cMainComposite, 0);
                gFiles.setText(MessageText.getString("label.file.settings"));
                gridLayout = new GridLayout(4, false);
                gFiles.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, true, false, 4, 1);
                Utils.setLayoutData((Control)gFiles, gd);
                if (fl.supportsTagInitialSaveFolder()) {
                    this.params.initalSaveFolder = new folderOption((Composite)gFiles, "label.init.save.loc"){

                        public void setFolder(File folder) {
                            fl.setTagInitialSaveFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagInitialSaveFolder();
                        }
                    };
                }
                if (fl.supportsTagMoveOnComplete()) {
                    this.params.moveOnCompleteFolder = new folderOption((Composite)gFiles, "label.move.on.comp"){

                        public void setFolder(File folder) {
                            fl.setTagMoveOnCompleteFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagMoveOnCompleteFolder();
                        }
                    };
                }
                if (fl.supportsTagCopyOnComplete()) {
                    this.params.copyOnCompleteFolder = new folderOption((Composite)gFiles, "label.copy.on.comp"){

                        public void setFolder(File folder) {
                            fl.setTagCopyOnCompleteFolder(folder);
                        }

                        public File getFolder() {
                            return fl.getTagCopyOnCompleteFolder();
                        }
                    };
                }
            }
            if (numTags == 1 && this.tags[0].getTagType().hasTagTypeFeature(32L) && this.tags[0] instanceof TagFeatureProperties && (propConstraint = (tfp = (TagFeatureProperties)((Object)this.tags[0])).getProperty("constraint")) != null) {
                Group gConstraint = new Group(this.cMainComposite, 0);
                Messages.setLanguageText((Widget)gConstraint, "tag.property.constraint");
                gridLayout = new GridLayout(3, false);
                gConstraint.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, true, false, 4, 1);
                Utils.setLayoutData((Control)gConstraint, gd);
                this.params.constraints = new Text((Composite)gConstraint, 2114);
                gd = new GridData(4, 0, true, false, 3, 1);
                gd.heightHint = 40;
                Utils.setLayoutData((Control)this.params.constraints, gd);
                this.params.constraints.addKeyListener(new KeyListener(){

                    public void keyReleased(KeyEvent e) {
                    }

                    public void keyPressed(KeyEvent e) {
                        ((TagSettingsView)TagSettingsView.this).params.constraints.setData("skipset", (Object)1);
                        if (TagSettingsView.this.btnSaveConstraint != null && !TagSettingsView.this.btnSaveConstraint.isDisposed()) {
                            TagSettingsView.this.btnSaveConstraint.setEnabled(true);
                            TagSettingsView.this.btnResetConstraint.setEnabled(true);
                        }
                    }
                });
                this.btnSaveConstraint = new Button((Composite)gConstraint, 8);
                this.btnSaveConstraint.setEnabled(false);
                this.btnSaveConstraint.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        String constraint = ((TagSettingsView)TagSettingsView.this).params.constraints.getText().trim();
                        if (constraint.length() == 0) {
                            propConstraint.setStringList(null);
                        } else {
                            propConstraint.setStringList(new String[]{constraint});
                        }
                        if (TagSettingsView.this.btnSaveConstraint != null && !TagSettingsView.this.btnSaveConstraint.isDisposed()) {
                            TagSettingsView.this.btnSaveConstraint.setEnabled(false);
                            TagSettingsView.this.btnResetConstraint.setEnabled(false);
                        }
                    }
                });
                Messages.setLanguageText((Widget)this.btnSaveConstraint, "Button.save");
                this.btnResetConstraint = new Button((Composite)gConstraint, 8);
                this.btnResetConstraint.setEnabled(false);
                this.btnResetConstraint.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        ((TagSettingsView)TagSettingsView.this).params.constraints.setData("skipset", null);
                        TagSettingsView.this.swt_updateFields();
                        if (TagSettingsView.this.btnSaveConstraint != null && !TagSettingsView.this.btnSaveConstraint.isDisposed()) {
                            TagSettingsView.this.btnSaveConstraint.setEnabled(false);
                            TagSettingsView.this.btnResetConstraint.setEnabled(false);
                        }
                    }
                });
                Messages.setLanguageText((Widget)this.btnResetConstraint, "Button.reset");
                Link lblAboutConstraint = new Link((Composite)gConstraint, 64);
                Utils.setLayoutData((Control)lblAboutConstraint, Utils.getWrappableLabelGridData(1, 512));
                lblAboutConstraint.setText(MessageText.getString("tag.constraints.info"));
                lblAboutConstraint.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        if (event2.text != null && (event2.text.startsWith("http://") || event2.text.startsWith("https://"))) {
                            Utils.launch(event2.text);
                        }
                    }
                });
            }
            if (numTags == 1 && this.tags[0].getTagType().hasTagTypeFeature(128L) && (tfl = (TagFeatureLimits)((Object)this.tags[0])).getMaximumTaggables() >= 0) {
                Group gLimits = new Group(this.cMainComposite, 0);
                gLimits.setText(MessageText.getString("label.limit.settings"));
                gridLayout = new GridLayout(6, false);
                gLimits.setLayout((Layout)gridLayout);
                gd = new GridData(4, 0, false, false, 4, 1);
                gLimits.setLayoutData((Object)gd);
                label = new Label((Composite)gLimits, 0);
                Messages.setLanguageText((Widget)label, "TableColumn.header.max_taggables");
                gd = new GridData(1, 0x1000000, false, false);
                Utils.setLayoutData((Control)label, gd);
                this.params.tfl_max_taggables = new GenericIntParameter(new GenericParameterAdapter(){

                    public int getIntValue(String key) {
                        return tfl.getMaximumTaggables();
                    }

                    public int getIntValue(String key, int def) {
                        return this.getIntValue(key);
                    }

                    public void setIntValue(String key, int value) {
                        tfl.setMaximumTaggables(value);
                    }
                }, (Composite)gLimits, null, 0, Integer.MAX_VALUE);
                gd = new GridData();
                gd.widthHint = 50;
                this.params.tfl_max_taggables.setLayoutData(gd);
                label = new Label((Composite)gLimits, 0);
                Messages.setLanguageText((Widget)label, "label.removal.policy");
                new GenericStringListParameter(new GenericParameterAdapter(){

                    public String getStringListValue(String key) {
                        return String.valueOf(tfl.getRemovalStrategy());
                    }

                    public String getStringListValue(String key, String def) {
                        return this.getStringListValue(key);
                    }

                    public void setStringListValue(String key, String value) {
                        tfl.setRemovalStrategy(value == null ? 0 : Integer.parseInt(value));
                    }
                }, (Composite)gLimits, null, new String[]{"", MessageText.getString("MyTorrentsView.menu.archive"), MessageText.getString("Button.deleteContent.fromLibrary"), MessageText.getString("Button.deleteContent.fromComputer")}, new String[]{"0", "1", "2", "3"});
            }
            this.swt_updateFields();
        }
        this.cMainComposite.layout();
        this.sc.setMinSize(this.cMainComposite.computeSize(-1, -1));
    }

    private void updateTagSRParams(Params params) {
        boolean has_individual = params.max_sr.getValue() > 0.0f;
        boolean has_aggregate = params.max_aggregate_sr.getValue() > 0.0f;
        params.max_aggregate_sr_priority.getControl().setEnabled(has_individual && has_aggregate);
    }

    private int updateIntBoolean(boolean b, int intB) {
        if (intB == -1) {
            intB = b ? 1 : 0;
        } else if (intB == 1 != b) {
            intB = 2;
        }
        return intB;
    }

    private String getFullTitle() {
        return MessageText.getString("TagSettingsView.title");
    }

    private void swt_updateFields() {
        if (this.tags == null || this.params == null) {
            this.initialize(null);
            return;
        }
        int[] tagColor = this.tags[0].getColor();
        HashSet<String> listTagNames = new HashSet<String>();
        for (Tag tag : this.tags) {
            int[] color;
            TagType tt = tag.getTagType();
            String s = tag.getTagName(true);
            listTagNames.add(s);
            if (tagColor == null || Arrays.areEqual(tagColor, color = tag.getColor())) continue;
            tagColor = null;
        }
        String name = GeneralUtils.stringJoin(listTagNames, ", ");
        if (this.params.cName != null && !this.params.cName.isDisposed()) {
            if (this.params.cName instanceof Text) {
                Text txt = (Text)this.params.cName;
                if (!txt.getText().equals(name)) {
                    txt.setText(name);
                }
            } else if (this.params.cName instanceof Label) {
                Label lbl = (Label)this.params.cName;
                lbl.setText(name);
            }
        }
        if (this.params.tagColor != null && tagColor != null) {
            this.params.tagColor.setColor(tagColor[0], tagColor[1], tagColor[2]);
        }
        if (this.params.viewInSideBar != null) {
            this.params.viewInSideBar.refresh();
        }
        if (this.params.isPublic != null) {
            this.params.isPublic.refresh();
        }
        if (this.params.maxDownloadSpeed != null) {
            this.params.maxDownloadSpeed.resetToDefault();
        }
        if (this.params.maxUploadSpeed != null) {
            this.params.maxUploadSpeed.resetToDefault();
        }
        if (this.params.uploadPriority != null) {
            this.params.uploadPriority.refresh();
        }
        if (this.params.min_sr != null) {
            this.params.min_sr.refresh();
        }
        if (this.params.max_sr != null) {
            this.params.max_sr.refresh();
        }
        if (this.params.initalSaveFolder != null) {
            this.params.initalSaveFolder.update();
        }
        if (this.params.moveOnCompleteFolder != null) {
            this.params.moveOnCompleteFolder.update();
        }
        if (this.params.copyOnCompleteFolder != null) {
            this.params.copyOnCompleteFolder.update();
        }
        if (this.params.constraints != null && this.params.constraints.getData("skipset") == null) {
            String[] stringList;
            TagFeatureProperties tfp;
            TagFeatureProperties.TagProperty propConstraint;
            String text = "";
            Tag tag = this.tags[0];
            if (tag.getTagType().hasTagTypeFeature(32L) && tag instanceof TagFeatureProperties && (propConstraint = (tfp = (TagFeatureProperties)((Object)tag)).getProperty("constraint")) != null && (stringList = propConstraint.getStringList()).length == 1 && stringList.length > 0) {
                text = stringList[0];
            }
            this.params.constraints.setText(text);
        }
        if (this.params.tfl_max_taggables != null) {
            this.params.tfl_max_taggables.refresh();
        }
    }

    public void tagTypeChanged(TagType tag_type) {
    }

    public void tagAdded(Tag tag) {
    }

    public void tagChanged(final Tag changedTag) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (TagSettingsView.this.tags == null) {
                    return;
                }
                for (Tag tag : TagSettingsView.this.tags) {
                    if (!changedTag.equals(tag)) continue;
                    TagSettingsView.this.swt_updateFields();
                    break;
                }
            }
        });
    }

    public void tagRemoved(Tag tag) {
    }

    private static abstract class BooleanParameterAdapter
    extends GenericParameterAdapter {
        private BooleanParameterAdapter() {
        }

        public abstract Boolean getBooleanValue(String var1);

        public Boolean getBooleanValue(String key, Boolean def) {
            return this.getBooleanValue(key);
        }

        public abstract void setBooleanValue(String var1, boolean var2);
    }

    public static class Params {
        private Control cName;
        private ColorParameter tagColor;
        private GenericIntParameter maxDownloadSpeed;
        private GenericIntParameter maxUploadSpeed;
        private GenericBooleanParameter viewInSideBar;
        private GenericBooleanParameter isPublic;
        public GenericBooleanParameter uploadPriority;
        public GenericFloatParameter min_sr;
        public GenericFloatParameter max_sr;
        public GenericStringListParameter max_sr_action;
        public GenericFloatParameter max_aggregate_sr;
        public GenericStringListParameter max_aggregate_sr_action;
        public GenericBooleanParameter max_aggregate_sr_priority;
        public folderOption initalSaveFolder;
        public folderOption moveOnCompleteFolder;
        public folderOption copyOnCompleteFolder;
        public Text constraints;
        public GenericIntParameter tfl_max_taggables;
    }

    private static abstract class folderOption {
        private Button btnClear;
        private Label lblValue;

        public folderOption(final Composite parent, String labelTextID) {
            ImageLoader imageLoader = ImageLoader.getInstance();
            Image imgOpenFolder = imageLoader.getImage("openFolderButton");
            GridData gd = new GridData();
            Label label = new Label(parent, 0);
            Utils.setLayoutData((Control)label, gd);
            Messages.setLanguageText((Widget)label, labelTextID);
            Button browse = new Button(parent, 8);
            browse.setImage(imgOpenFolder);
            imgOpenFolder.setBackground(browse.getBackground());
            browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
            browse.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                    File tagInitialSaveFolder = folderOption.this.getFolder();
                    String filterPath = tagInitialSaveFolder != null ? tagInitialSaveFolder.toString() : COConfigurationManager.getStringParameter("Default save path");
                    dialog.setFilterPath(filterPath);
                    dialog.setMessage(MessageText.getString("label.init.save.loc"));
                    dialog.setText(MessageText.getString("label.init.save.loc"));
                    final String path = dialog.open();
                    if (path != null) {
                        Utils.getOffOfSWTThread(new AERunnable(){

                            public void runSupport() {
                                folderOption.this.setFolder(new File(path));
                            }
                        });
                    }
                }
            });
            this.lblValue = new Label(parent, 64);
            gd = Utils.getWrappableLabelGridData(1, 768);
            gd.verticalAlignment = 0x1000000;
            Utils.setLayoutData((Control)this.lblValue, gd);
            this.btnClear = new Button(parent, 8);
            Messages.setLanguageText((Widget)this.btnClear, "Button.clear");
            this.btnClear.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    folderOption.this.setFolder(null);
                }
            });
        }

        public void update() {
            File folder = this.getFolder();
            if (folder == null) {
                Messages.setLanguageText((Widget)this.lblValue, "label.none.assigned");
            } else {
                this.lblValue.setText(folder.toString());
            }
            this.btnClear.setVisible(folder != null);
        }

        public abstract File getFolder();

        public abstract void setFolder(File var1);
    }
}

