/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.tag.TagTypeListener;
import com.aelitis.azureus.core.tag.Taggable;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.swt.utils.ColorCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCoreEventListener;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class TaggingView
implements UISWTViewCoreEventListener,
TagTypeListener {
    public static final String MSGID_PREFIX = "TaggingView";
    private UISWTView swtView;
    private Composite cMainComposite;
    private ScrolledComposite sc;
    private List<Taggable> taggables;
    private List<Button> buttons;
    private Composite parent;

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.parent = (Composite)event2.getData();
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.cMainComposite);
                this.swtView.setTitle(this.getFullTitle());
                break;
            }
            case 1: {
                Object ds = event2.getData();
                this.dataSourceChanged(ds);
                break;
            }
            case 3: {
                this.initialize();
                if (this.taggables != null) break;
                this.dataSourceChanged(this.swtView.getDataSource());
                break;
            }
            case 4: {
                this.delete();
                break;
            }
            case 5: {
                this.refresh();
            }
        }
        return true;
    }

    private void delete() {
        Utils.disposeComposite((Composite)this.sc);
        this.dataSourceChanged(null);
    }

    private void refresh() {
    }

    private void dataSourceChanged(Object ds) {
        boolean isNull;
        boolean wasNull;
        boolean bl = wasNull = this.taggables == null;
        if (ds instanceof Taggable) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.add((Taggable)ds);
        } else if (ds instanceof Taggable[]) {
            this.taggables = new ArrayList<Taggable>();
            this.taggables.addAll(Arrays.asList((Taggable[])ds));
        } else if (ds instanceof Object[]) {
            Object[] objects;
            this.taggables = new ArrayList<Taggable>();
            for (Object o : objects = (Object[])ds) {
                DownloadManager taggable;
                DownloadManager temp;
                if (o instanceof Taggable) {
                    Taggable taggable2 = (Taggable)o;
                    if (this.taggables.contains(taggable2)) continue;
                    this.taggables.add(taggable2);
                    continue;
                }
                if (!(o instanceof DiskManagerFileInfo) || !((temp = ((DiskManagerFileInfo)o).getDownloadManager()) instanceof Taggable) || this.taggables.contains(taggable = temp)) continue;
                this.taggables.add(taggable);
            }
            if (this.taggables.size() == 0) {
                this.taggables = null;
            }
        } else {
            this.taggables = null;
        }
        boolean bl2 = isNull = this.taggables == null;
        if (isNull != wasNull) {
            TagManager tm = TagManagerFactory.getTagManager();
            TagType tagType = tm.getTagType(3);
            if (isNull) {
                tagType.removeTagTypeListener(this);
            } else {
                tagType.addTagTypeListener(this, false);
            }
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TaggingView.this.swt_updateFields();
            }
        });
    }

    private void initialize() {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            if (this.parent == null || this.parent.isDisposed()) {
                return;
            }
            this.sc = new ScrolledComposite(this.parent, 512);
            this.sc.setExpandHorizontal(true);
            this.sc.setExpandVertical(true);
            this.sc.getVerticalBar().setIncrement(16);
            Layout parentLayout = this.parent.getLayout();
            if (parentLayout instanceof GridLayout) {
                GridData gd = new GridData(4, 4, true, true);
                this.sc.setLayoutData((Object)gd);
            } else if (parentLayout instanceof FormLayout) {
                this.sc.setLayoutData((Object)Utils.getFilledFormData());
            }
            this.cMainComposite = new Composite((Composite)this.sc, 0);
            this.sc.setContent((Control)this.cMainComposite);
        } else {
            Utils.disposeComposite(this.cMainComposite, false);
        }
        this.cMainComposite.setLayout((Layout)new GridLayout(1, false));
        TagManager tm = TagManagerFactory.getTagManager();
        int[] tagTypesWanted = new int[]{3};
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.widget;
                Tag tag = (Tag)button.getData("Tag");
                if (button.getGrayed()) {
                    button.setGrayed(false);
                    button.setSelection(!button.getSelection());
                    button.getParent().redraw();
                }
                boolean doTag = button.getSelection();
                for (Taggable taggable : TaggingView.this.taggables) {
                    if (doTag) {
                        tag.addTaggable(taggable);
                        continue;
                    }
                    tag.removeTaggable(taggable);
                }
                button.getParent().redraw();
                button.getParent().update();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        Listener menuDetectListener = new Listener(){

            public void handleEvent(Event event2) {
                final Button button = (Button)event2.widget;
                Menu menu = new Menu((Control)button);
                button.setMenu(menu);
                MenuBuildUtils.addMaintenanceListenerForMenu(menu, new MenuBuildUtils.MenuBuilder(){

                    public void buildMenu(Menu menu, MenuEvent menuEvent) {
                        Tag tag = (Tag)button.getData("Tag");
                        TagUIUtils.createSideBarMenuItems(menu, tag);
                    }
                });
            }
        };
        PaintListener paintListener = new PaintListener(){

            public void paintControl(PaintEvent e) {
                Button button;
                Composite c = null;
                if (e.widget instanceof Composite) {
                    c = (Composite)e.widget;
                    button = (Button)c.getChildren()[0];
                } else {
                    button = (Button)e.widget;
                }
                Tag tag = (Tag)button.getData("Tag");
                if (tag == null) {
                    return;
                }
                if (c != null) {
                    boolean checked = button.getSelection();
                    Point size = c.getSize();
                    Point sizeButton = button.getSize();
                    e.gc.setAntialias(1);
                    e.gc.setForeground(ColorCache.getColor((Device)e.display, tag.getColor()));
                    int lineWidth = button.getSelection() ? 2 : 1;
                    e.gc.setLineWidth(lineWidth);
                    int curve = 20;
                    int width = sizeButton.x + lineWidth + 1;
                    width += Constants.isOSX ? 5 : curve / 2;
                    if (checked) {
                        e.gc.setAlpha(32);
                        e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
                        e.gc.fillRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
                        e.gc.setAlpha(255);
                    }
                    if (!checked) {
                        e.gc.setAlpha(128);
                    }
                    e.gc.drawRoundRectangle(-curve, lineWidth - 1, width + curve, size.y - lineWidth, curve, curve);
                    e.gc.drawLine(lineWidth - 1, lineWidth, lineWidth - 1, size.y - lineWidth);
                } else if (!Constants.isOSX && button.getSelection()) {
                    Point size = button.getSize();
                    e.gc.setBackground(ColorCache.getColor((Device)e.display, tag.getColor()));
                    e.gc.setAlpha(20);
                    e.gc.fillRectangle(0, 0, size.x, size.y);
                }
            }
        };
        this.buttons = new ArrayList<Button>();
        for (int tagType : tagTypesWanted) {
            TagType tt = tm.getTagType(tagType);
            List<Tag> tags = tt.getTags();
            tags = TagUIUtils.sortTags(tags);
            Composite g = null;
            String group = null;
            for (Tag tag : tags) {
                String newGroup = tag.getGroup();
                if (g == null || group != null && !group.equals(newGroup) || group == null && newGroup != null) {
                    group = newGroup;
                    Object object = g = group == null ? new Composite(this.cMainComposite, 0x20000000) : new Group(this.cMainComposite, 0x20000000);
                    if (group != null) {
                        ((Group)g).setText(group);
                    }
                    g.setLayoutData((Object)new GridData(4, 4, true, true));
                    RowLayout rowLayout = new RowLayout();
                    rowLayout.pack = false;
                    rowLayout.spacing = 5;
                    Utils.setLayout(g, rowLayout);
                }
                Composite p = new Composite(g, 0x20000000);
                GridLayout layout = new GridLayout(1, false);
                layout.marginHeight = 3;
                if (Constants.isWindows) {
                    layout.marginWidth = 6;
                    layout.marginLeft = 2;
                    layout.marginTop = 1;
                } else {
                    layout.marginWidth = 0;
                    layout.marginLeft = 3;
                    layout.marginRight = 11;
                }
                p.setLayout((Layout)layout);
                p.addPaintListener(paintListener);
                Button button = new Button(p, 32);
                this.buttons.add(button);
                if (tag.isTagAuto()) {
                    button.setEnabled(false);
                } else {
                    button.addSelectionListener(selectionListener);
                }
                button.setData("Tag", (Object)tag);
                button.addListener(35, menuDetectListener);
                button.addPaintListener(paintListener);
            }
        }
        Button buttonAdd = new Button(this.cMainComposite, 8);
        buttonAdd.setLayoutData((Object)new GridData(0x1000000, 4, false, false));
        Messages.setLanguageText((Widget)buttonAdd, "label.add.tag");
        buttonAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    public void returnedTags(Tag[] tags) {
                        if (TaggingView.this.taggables == null) {
                            return;
                        }
                        for (Tag tag : tags) {
                            for (Taggable taggable : TaggingView.this.taggables) {
                                tag.addTaggable(taggable);
                            }
                        }
                    }
                });
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = TaggingView.this.sc.getClientArea();
                Point size = TaggingView.this.cMainComposite.computeSize(r.width, -1);
                TaggingView.this.sc.setMinSize(size);
            }
        });
        this.swt_updateFields();
        Rectangle r = this.sc.getClientArea();
        Point size = this.cMainComposite.computeSize(r.width, -1);
        this.sc.setMinSize(size);
    }

    private String getFullTitle() {
        return MessageText.getString("label.tags");
    }

    private void swt_updateFields() {
        if (this.cMainComposite == null || this.cMainComposite.isDisposed()) {
            return;
        }
        ArrayList<Button> layoutChanges = new ArrayList<Button>();
        for (Button button : this.buttons) {
            boolean hasTag = false;
            boolean hasNoTag = false;
            Tag tag = (Tag)button.getData("Tag");
            if (tag == null) continue;
            String name = tag.getTagName(true);
            if (!button.getText().equals(name)) {
                button.setText(name);
                layoutChanges.add(button);
            }
            if (this.taggables == null) {
                button.setSelection(false);
                button.setEnabled(false);
                button.getParent().redraw();
                continue;
            }
            if (!tag.isTagAuto()) {
                button.setEnabled(true);
            }
            for (Taggable taggable : this.taggables) {
                boolean curHasTag = tag.hasTaggable(taggable);
                if (!hasTag && curHasTag) {
                    hasTag = true;
                    if (!hasNoTag) continue;
                    break;
                }
                if (hasNoTag || curHasTag) continue;
                hasNoTag = true;
                if (!hasTag) continue;
                break;
            }
            if (hasTag && hasNoTag) {
                button.setGrayed(true);
                button.setSelection(true);
            } else {
                button.setGrayed(false);
                button.setSelection(hasTag);
            }
            button.getParent().redraw();
        }
        if (layoutChanges.size() > 0) {
            this.cMainComposite.layout(layoutChanges.toArray(new Control[0]));
            this.parent.layout();
        }
    }

    public void tagTypeChanged(TagType tag_type) {
    }

    public void tagAdded(Tag tag) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TaggingView.this.initialize();
            }
        });
    }

    public void tagChanged(Tag changedTag) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TaggingView.this.swt_updateFields();
            }
        });
    }

    public void tagRemoved(Tag tag) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TaggingView.this.initialize();
            }
        });
    }
}

