/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionDNS
implements UISWTConfigSection {
    private static final String CFG_PREFIX = "ConfigView.section.dns.";
    private static final int REQUIRED_MODE = 2;

    public int maxUserMode() {
        return 2;
    }

    public String configSectionGetParentSection() {
        return "server";
    }

    public String configSectionGetName() {
        return "DNS";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)cSection, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        cSection.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            Utils.setLayoutData((Control)label, gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Label label = new Label(cSection, 64);
        Messages.setLanguageText((Widget)label, "ConfigView.section.dns.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        Utils.setLayoutData((Control)label, gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new LinkLabel(cSection, gridData, "ConfigView.label.please.visit.here", MessageText.getString("ConfigView.section.dns.url"));
        Label comment_label = new Label(cSection, 0);
        Messages.setLanguageText((Widget)comment_label, "ConfigView.section.dns.alts");
        gridData = new GridData(768);
        StringParameter alt_servers = new StringParameter(cSection, "DNS Alt Servers");
        alt_servers.setLayoutData(gridData);
        BooleanParameter allow_socks = new BooleanParameter(cSection, "DNS Alt Servers SOCKS Enable", "ConfigView.section.dns.allow_socks");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        allow_socks.setLayoutData(gridData);
        return cSection;
    }
}

