/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.core.networkmanager.admin.NetworkAdmin;
import com.aelitis.azureus.core.stats.AzureusCoreStats;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.logging.impl.FileLogging;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IAdditionalActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionLogging
implements UISWTConfigSection {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static final String CFG_PREFIX = "ConfigView.section.logging.";
    private static final int[] logFileSizes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 25, 30, 40, 50, 75, 100, 200, 300, 500};

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "logging";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        ImageLoader imageLoader = ImageLoader.getInstance();
        imageLoader.releaseImage("openFolderButton");
    }

    public int maxUserMode() {
        return 2;
    }

    public Composite configSectionCreate(final Composite parent) {
        ImageLoader imageLoader = ImageLoader.getInstance();
        Image imgOpenFolder = imageLoader.getImage("openFolderButton");
        Composite gLogging = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)gLogging, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        gLogging.setLayout((Layout)layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        BooleanParameter enable_logger = new BooleanParameter(gLogging, "Logger.Enabled", "ConfigView.section.logging.loggerenable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_logger.setLayoutData(gridData);
        final BooleanParameter enableLogging = new BooleanParameter(gLogging, "Logging Enable", "ConfigView.section.logging.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enableLogging.setLayoutData(gridData);
        Composite cArea = new Composite(gLogging, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 3;
        cArea.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        cArea.setLayoutData((Object)gridData);
        Label lStatsPath = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lStatsPath, "ConfigView.section.logging.logdir");
        gridData = new GridData();
        gridData.widthHint = 150;
        final StringParameter pathParameter = new StringParameter(cArea, "Logging Dir");
        pathParameter.setLayoutData(gridData);
        Button browse = new Button(cArea, 8);
        browse.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse.getBackground());
        browse.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(parent.getShell(), 65536);
                dialog.setFilterPath(pathParameter.getValue());
                dialog.setText(MessageText.getString("ConfigView.section.logging.choosedefaultsavepath"));
                String path = dialog.open();
                if (path != null) {
                    pathParameter.setValue(path);
                }
            }
        });
        Label lMaxLog = new Label(cArea, 0);
        Messages.setLanguageText((Widget)lMaxLog, "ConfigView.section.logging.maxsize");
        String[] lmLabels = new String[logFileSizes.length];
        int[] lmValues = new int[logFileSizes.length];
        for (int i = 0; i < logFileSizes.length; ++i) {
            int num = logFileSizes[i];
            lmLabels[i] = " " + num + " MB";
            lmValues[i] = num;
        }
        IntListParameter paramMaxSize = new IntListParameter(cArea, "Logging Max Size", lmLabels, lmValues);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        paramMaxSize.setLayoutData(gridData);
        if (userMode > 1) {
            Label timeStampLbl = new Label(cArea, 0);
            Messages.setLanguageText((Widget)timeStampLbl, "ConfigView.section.logging.timestamp");
            Utils.setLayoutData((Control)timeStampLbl, new GridData());
            StringParameter timeStamp = new StringParameter(cArea, "Logging Timestamp");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.widthHint = 150;
            timeStamp.setLayoutData(gridData);
        }
        String sFilterPrefix = "ConfigView.section.logging.filter";
        Group gLogIDs = new Group(gLogging, 0);
        Messages.setLanguageText((Widget)gLogIDs, "ConfigView.section.logging.filter");
        layout = new GridLayout();
        layout.numColumns = 2;
        gLogIDs.setLayout((Layout)layout);
        gridData = new GridData(1, 1, true, true);
        gridData.horizontalSpan = 2;
        Utils.setLayoutData((Control)gLogIDs, gridData);
        final List listLogTypes = new List((Composite)gLogIDs, 2564);
        gridData = new GridData(0, 1, false, false);
        listLogTypes.setLayoutData((Object)gridData);
        final int[] logTypes = new int[]{0, 1, 3};
        for (int i = 0; i < logTypes.length; ++i) {
            listLogTypes.add(MessageText.getString("ConfigView.section.logging.log" + i + "type"));
        }
        listLogTypes.select(0);
        LogIDs[] logIDs = FileLogging.configurableLOGIDs;
        final Table tableLogIDs = new Table((Composite)gLogIDs, 67620);
        gridData = new GridData(1808);
        tableLogIDs.setLayoutData((Object)gridData);
        tableLogIDs.setLinesVisible(false);
        tableLogIDs.setHeaderVisible(false);
        TableColumn column = new TableColumn(tableLogIDs, 0);
        for (int i = 0; i < logIDs.length; ++i) {
            TableItem item = new TableItem(tableLogIDs, 0);
            item.setText(0, MessageText.getString("ConfigView.section.logging.filter." + logIDs[i], logIDs[i].toString()));
            item.setData((Object)logIDs[i]);
            boolean checked = COConfigurationManager.getBooleanParameter("bLog." + logTypes[0] + "." + logIDs[i], true);
            item.setChecked(checked);
        }
        column.pack();
        listLogTypes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                TableItem[] items = tableLogIDs.getItems();
                for (int i = 0; i < items.length; ++i) {
                    boolean checked = COConfigurationManager.getBooleanParameter("bLog." + logTypes[index] + "." + items[i].getData(), true);
                    items[i].setChecked(checked);
                }
            }
        });
        tableLogIDs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                int index = listLogTypes.getSelectionIndex();
                if (index < 0 || index >= logTypes.length) {
                    return;
                }
                TableItem item = (TableItem)e.item;
                COConfigurationManager.setParameter("bLog." + logTypes[index] + "." + item.getData(), item.getChecked());
            }
        });
        Control[] controls_main = new Control[]{cArea, gLogIDs};
        ChangeSelectionActionPerformer perf2 = new ChangeSelectionActionPerformer(controls_main);
        enableLogging.setAdditionalActionPerformer(perf2);
        enable_logger.setAdditionalActionPerformer(new IAdditionalActionPerformer(){
            ChangeSelectionActionPerformer p1;
            {
                this.p1 = new ChangeSelectionActionPerformer(new Control[]{enableLogging.getControl()});
            }

            public void performAction() {
                this.p1.performAction();
            }

            public void setSelected(boolean selected) {
                this.p1.setSelected(selected);
                if (!selected && enableLogging.isSelected().booleanValue()) {
                    enableLogging.setSelected(false);
                }
            }

            public void setIntValue(int value) {
            }

            public void setStringValue(String value) {
            }
        });
        if (userMode > 1) {
            Group cAO = new Group(gLogging, 0);
            cAO.setText(MessageText.getString("dht.advanced.group"));
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 5;
            cAO.setLayout((Layout)layout);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            cAO.setLayoutData((Object)gridData);
            Label aoName = new Label((Composite)cAO, 0);
            Messages.setLanguageText((Widget)aoName, "TableColumn.header.name");
            aoName.setLayoutData((Object)new GridData());
            final StringParameter name = new StringParameter((Composite)cAO, "Advanced Option Name");
            gridData = new GridData();
            gridData.widthHint = 150;
            name.setLayoutData(gridData);
            Label aoValue = new Label((Composite)cAO, 0);
            Messages.setLanguageText((Widget)aoValue, "ConfigView.label.seeding.ignore.header.value");
            aoName.setLayoutData((Object)new GridData());
            final StringParameter value = new StringParameter((Composite)cAO, "Advanced Option Value");
            gridData = new GridData();
            gridData.widthHint = 150;
            value.setLayoutData(gridData);
            Button set_option = new Button((Composite)cAO, 8);
            Messages.setLanguageText((Widget)set_option, "Button.set");
            set_option.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    String key = name.getValue().trim();
                    if (key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                        key = key.substring(1, key.length() - 1);
                    }
                    if (key.length() > 0) {
                        key = key.startsWith("!") ? key.substring(1) : "adv.setting." + key;
                        String val = value.getValue().trim();
                        boolean is_string = false;
                        if (val.startsWith("'") && val.endsWith("'") || val.startsWith("\"") && val.endsWith("\"")) {
                            val = val.substring(1, val.length() - 1);
                            is_string = true;
                        }
                        if (val.length() == 0) {
                            COConfigurationManager.removeParameter(key);
                        } else if (is_string) {
                            COConfigurationManager.setParameter(key, val);
                        } else {
                            String lc_val = val.toLowerCase(Locale.US);
                            if (lc_val.equals("false") || lc_val.equals("true")) {
                                COConfigurationManager.setParameter(key, lc_val.startsWith("t"));
                            } else {
                                try {
                                    long l = Long.parseLong(val);
                                    COConfigurationManager.setParameter(key, l);
                                }
                                catch (Throwable e) {
                                    COConfigurationManager.setParameter(key, val);
                                }
                            }
                        }
                        COConfigurationManager.save();
                    }
                }
            });
        }
        Label generate_net_info = new Label(gLogging, 0);
        Messages.setLanguageText((Widget)generate_net_info, "ConfigView.section.logging.netinfo");
        Button generate_net_button = new Button(gLogging, 8);
        Messages.setLanguageText((Widget)generate_net_button, "ConfigView.section.logging.generatediagnostics");
        generate_net_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                new AEThread2("GenerateNetDiag", true){

                    public void run() {
                        StringWriter sw = new StringWriter();
                        PrintWriter pw = new PrintWriter(sw);
                        IndentWriter iw = new IndentWriter(pw);
                        NetworkAdmin admin = NetworkAdmin.getSingleton();
                        admin.generateDiagnostics(iw);
                        pw.close();
                        final String info = sw.toString();
                        Logger.log(new LogEvent(LOGID, "Network Info:\n" + info));
                        Utils.execSWTThread(new Runnable(){

                            public void run() {
                                ClipboardCopy.copyToClipBoard(info);
                            }
                        });
                    }
                }.start();
            }
        });
        Label generate_stats_info = new Label(gLogging, 0);
        Messages.setLanguageText((Widget)generate_stats_info, "ConfigView.section.logging.statsinfo");
        Button generate_stats_button = new Button(gLogging, 8);
        Messages.setLanguageText((Widget)generate_stats_button, "ConfigView.section.logging.generatediagnostics");
        generate_stats_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                HashSet<String> types = new HashSet<String>();
                types.add(".*");
                Map reply = AzureusCoreStats.getStats(types);
                Iterator it = reply.entrySet().iterator();
                StringBuffer buffer = new StringBuffer(16000);
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    buffer.append(entry.getKey() + " -> " + entry.getValue() + "\r\n");
                }
                String str = buffer.toString();
                ClipboardCopy.copyToClipBoard(str);
                Logger.log(new LogEvent(LOGID, "Stats Info:\n" + str));
            }
        });
        Label generate_info = new Label(gLogging, 0);
        Messages.setLanguageText((Widget)generate_info, "ConfigView.section.logging.generatediagnostics.info");
        Button generate_button = new Button(gLogging, 8);
        Messages.setLanguageText((Widget)generate_button, "ConfigView.section.logging.generatediagnostics");
        generate_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                AEDiagnostics.generateEvidence(pw);
                pw.close();
                String evidence = sw.toString();
                ClipboardCopy.copyToClipBoard(evidence);
                Logger.log(new LogEvent(LOGID, "Evidence Generation:\n" + evidence));
            }
        });
        return gLogging;
    }
}

