/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import com.aelitis.azureus.ui.UserPrompterResultListener;
import com.aelitis.azureus.ui.common.RememberedDecisionsManager;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.ClipboardCopy;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;

public class ConfigSectionMode
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "mode";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(final Composite parent) {
        final String[] links = new String[]{"http://wiki.vuze.com/w/Mode#Beginner", "http://wiki.vuze.com/w/Mode#Intermediate", "http://wiki.vuze.com/w/Mode#Advanced"};
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite cMode = new Composite(parent, 64);
        GridData gridData = new GridData(272);
        cMode.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        cMode.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        final Group gRadio = new Group(cMode, 64);
        Messages.setLanguageText((Widget)gRadio, "ConfigView.section.mode.title");
        gRadio.setLayoutData((Object)gridData);
        Utils.setLayout((Composite)gRadio, new RowLayout(256));
        Button button0 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button0, "ConfigView.section.mode.beginner");
        button0.setData("iMode", (Object)"0");
        button0.setData("sMode", (Object)"beginner.text");
        Button button1 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button1, "ConfigView.section.mode.intermediate");
        button1.setData("iMode", (Object)"1");
        button1.setData("sMode", (Object)"intermediate.text");
        Button button2 = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)button2, "ConfigView.section.mode.advanced");
        button2.setData("iMode", (Object)"2");
        button2.setData("sMode", (Object)"advanced.text");
        final Button[] selected_button = new Button[]{null};
        if (userMode == 0) {
            selected_button[0] = button0;
            button0.setSelection(true);
        } else if (userMode == 1) {
            selected_button[0] = button1;
            button1.setSelection(true);
        } else {
            selected_button[0] = button2;
            button2.setSelection(true);
        }
        gridData = new GridData(768);
        final Label label = new Label(cMode, 64);
        gridData.horizontalSpan = 4;
        gridData.horizontalIndent = 10;
        Utils.setLayoutData((Control)label, gridData);
        final Label linkLabel = new Label(cMode, 0);
        linkLabel.setText(MessageText.getString("ConfigView.label.please.visit.here"));
        linkLabel.setData((Object)links[userMode]);
        linkLabel.setCursor(linkLabel.getDisplay().getSystemCursor(21));
        linkLabel.setForeground(Colors.blue);
        gridData = new GridData(768);
        Utils.setLayoutData((Control)linkLabel, gridData);
        linkLabel.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }

            public void mouseUp(MouseEvent arg0) {
                Utils.launch((String)((Label)arg0.widget).getData());
            }
        });
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)linkLabel, gridData);
        ClipboardCopy.addCopyToClipMenu((Control)linkLabel);
        final Runnable setModeText = new Runnable(){

            public void run() {
                String key = "ConfigView.section.mode." + selected_button[0].getData("sMode");
                if (MessageText.keyExists(key + "1")) {
                    key = key + "1";
                }
                label.setText("-> " + MessageText.getString(key));
            }
        };
        setModeText.run();
        Listener radioGroup = new Listener(){

            public void handleEvent(Event event2) {
                Control[] children = gRadio.getChildren();
                for (int j = 0; j < children.length; ++j) {
                    Button button;
                    Control child = children[j];
                    if (!(child instanceof Button) || ((button = (Button)child).getStyle() & 0x10) == 0) continue;
                    button.setSelection(false);
                }
                Button button = (Button)event2.widget;
                button.setSelection(true);
                int mode = Integer.parseInt((String)button.getData("iMode"));
                selected_button[0] = button;
                setModeText.run();
                linkLabel.setData((Object)links[mode]);
                COConfigurationManager.setParameter("User Mode", Integer.parseInt((String)button.getData("iMode")));
            }
        };
        button0.addListener(13, radioGroup);
        button1.addListener(13, radioGroup);
        button2.addListener(13, radioGroup);
        Label padding = new Label(cMode, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        Utils.setLayoutData((Control)padding, gridData);
        Label blank = new Label(cMode, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)blank, gridData);
        Composite gReset = new Composite(cMode, 64);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        Utils.setLayoutData((Control)gReset, gridData);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 0;
        gReset.setLayout((Layout)layout);
        Label reset_label = new Label(gReset, 0);
        Messages.setLanguageText((Widget)reset_label, "ConfigView.section.mode.resetdefaults");
        Button reset_button = new Button(gReset, 8);
        Messages.setLanguageText((Widget)reset_button, "Button.reset");
        reset_button.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                MessageBoxShell mb = new MessageBoxShell(296, MessageText.getString("resetconfig.warn.title"), MessageText.getString("resetconfig.warn"));
                mb.setDefaultButtonUsingStyle(256);
                mb.setParent(parent.getShell());
                mb.open(new UserPrompterResultListener(){

                    public void prompterClosed(int returnVal) {
                        if (returnVal != 32) {
                            return;
                        }
                        RememberedDecisionsManager.ensureLoaded();
                        COConfigurationManager.resetToDefaults();
                    }
                });
            }
        });
        padding = new Label(gReset, 0);
        gridData = new GridData();
        Utils.setLayoutData((Control)padding, gridData);
        return cMode;
    }
}

