/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.config.ParameterChangeAdapter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionSharing
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "sharing";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public int maxUserMode() {
        return 0;
    }

    public Composite configSectionCreate(Composite parent) {
        Composite gSharing = new Composite(parent, 64);
        GridData gridData = new GridData(272);
        Utils.setLayoutData((Control)gSharing, gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        gSharing.setLayout((Layout)layout);
        gridData = new GridData();
        Label protocol_lab = new Label(gSharing, 0);
        Messages.setLanguageText((Widget)protocol_lab, "ConfigView.section.sharing.protocol");
        Utils.setLayoutData((Control)protocol_lab, gridData);
        String[] protocols = new String[]{"HTTP", "HTTPS", "UDP", "DHT"};
        String[] descs = new String[]{"HTTP", "HTTPS (SSL)", "UDP", "Decentralised"};
        new StringListParameter(gSharing, "Sharing Protocol", "DHT", descs, protocols);
        GridData grid_data = new GridData();
        grid_data.horizontalSpan = 2;
        final BooleanParameter private_torrent = new BooleanParameter(gSharing, "Sharing Torrent Private", "ConfigView.section.sharing.privatetorrent");
        private_torrent.setLayoutData(grid_data);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        final BooleanParameter permit_dht = new BooleanParameter(gSharing, "Sharing Permit DHT", "ConfigView.section.sharing.permitdht");
        permit_dht.setLayoutData(gridData);
        private_torrent.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(permit_dht.getControls(), true));
        private_torrent.addChangeListener(new ParameterChangeAdapter(){

            public void parameterChanged(Parameter p, boolean caused_internally) {
                if (private_torrent.isSelected().booleanValue()) {
                    permit_dht.setSelected(false);
                }
            }
        });
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        new BooleanParameter(gSharing, "Sharing Add Hashes", "wizard.createtorrent.extrahashes").setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        BooleanParameter rescan_enable = new BooleanParameter(gSharing, "Sharing Rescan Enable", "ConfigView.section.sharing.rescanenable");
        rescan_enable.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalIndent = 25;
        Label period_label = new Label(gSharing, 0);
        Messages.setLanguageText((Widget)period_label, "ConfigView.section.sharing.rescanperiod");
        Utils.setLayoutData((Control)period_label, gridData);
        gridData = new GridData();
        IntParameter rescan_period = new IntParameter(gSharing, "Sharing Rescan Period");
        rescan_period.setMinimumValue(1);
        rescan_period.setLayoutData(gridData);
        rescan_enable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(rescan_period.getControls()));
        rescan_enable.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{period_label}));
        Label comment_label = new Label(gSharing, 0);
        Messages.setLanguageText((Widget)comment_label, "ConfigView.section.sharing.torrentcomment");
        new Label(gSharing, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gridData.horizontalSpan = 2;
        StringParameter torrent_comment = new StringParameter(gSharing, "Sharing Torrent Comment", "");
        torrent_comment.setLayoutData(gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        BooleanParameter persistent = new BooleanParameter(gSharing, "Sharing Is Persistent", "ConfigView.section.sharing.persistentshares");
        persistent.setLayoutData(gridData);
        return gSharing;
    }
}

