/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.peer;

import com.aelitis.azureus.core.peermanager.piecepicker.util.BitFlags;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableDataSourceChangedListener;
import com.aelitis.azureus.ui.common.table.TableLifeCycleListener;
import com.aelitis.azureus.ui.common.table.TableRefreshListener;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewFactory;
import org.gudy.azureus2.ui.swt.views.table.impl.TableViewTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeerFilesView
extends TableViewTab<PeersFilesViewRow>
implements TableDataSourceChangedListener,
TableLifeCycleListener,
TableRefreshListener {
    public static final String TABLEID_PEER_FILES = "PeerFiles";
    boolean refreshing = false;
    private static final TableColumnCore[] basicItems = new TableColumnCore[]{new NameItem(), new PercentItem()};
    private TableViewSWT<PeersFilesViewRow> tv;
    private PEPeer current_peer;

    public PeerFilesView() {
        super("PeerFilesView");
    }

    @Override
    public TableViewSWT<PeersFilesViewRow> initYourTableView() {
        this.tv = TableViewFactory.createTableViewSWT(PeersFilesViewRow.class, TABLEID_PEER_FILES, this.getPropertiesPrefix(), basicItems, "firstpiece", 0x10010002);
        this.tv.addTableDataSourceChangedListener(this, true);
        this.tv.addRefreshListener(this, true);
        this.tv.addLifeCycleListener(this);
        return this.tv;
    }

    @Override
    public void tableDataSourceChanged(Object newDataSource) {
        Object[] temp;
        if (newDataSource instanceof PEPeer) {
            this.current_peer = (PEPeer)newDataSource;
        }
        this.current_peer = newDataSource instanceof Object[] ? ((temp = (Object[])newDataSource).length > 0 && temp[0] instanceof PEPeer ? (PEPeer)temp[0] : null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tableRefresh() {
        PeerFilesView peerFilesView;
        PeerFilesView peerFilesView2 = this;
        synchronized (peerFilesView2) {
            if (this.refreshing) {
                return;
            }
            this.refreshing = true;
        }
        try {
            PEPeer peer = this.current_peer;
            if (peer == null) {
                this.tv.removeAllTableRows();
            } else if (this.tv.getRowCount() == 0) {
                DiskManagerFileInfo[] files = peer.getManager().getDiskManager().getFiles();
                PeersFilesViewRow[] rows = new PeersFilesViewRow[files.length];
                for (int i = 0; i < files.length; ++i) {
                    rows[i] = new PeersFilesViewRow(files[i], peer);
                }
                this.tv.addDataSources((PeersFilesViewRow[])rows);
                this.tv.processDataSourceQueueSync();
            } else {
                TableRowCore[] rows;
                for (TableRowCore row : rows = this.tv.getRows()) {
                    ((PeersFilesViewRow)row.getDataSource()).setPeer(peer);
                }
            }
            Object var8_11 = null;
            peerFilesView = this;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            PeerFilesView peerFilesView3 = this;
            synchronized (peerFilesView3) {
                this.refreshing = false;
            }
            throw throwable;
        }
        synchronized (peerFilesView) {
            this.refreshing = false;
        }
    }

    @Override
    public void tableViewInitialized() {
    }

    @Override
    public void tableViewTabInitComplete() {
        super.tableViewTabInitComplete();
    }

    @Override
    public void tableViewDestroyed() {
    }

    static {
        TableColumnManager tcManager = TableColumnManager.getInstance();
        tcManager.setDefaultColumnNames(TABLEID_PEER_FILES, basicItems);
    }

    private static class NameItem
    extends CoreTableColumnSWT
    implements TableCellRefreshListener {
        private NameItem() {
            super("name", 1, -2, 300, PeerFilesView.TABLEID_PEER_FILES);
            this.setType(1);
        }

        public void refresh(TableCell cell) {
            String name;
            PeersFilesViewRow row = (PeersFilesViewRow)cell.getDataSource();
            String string = name = row == null ? "" : row.getFile().getFile(true).getName();
            if (name == null) {
                name = "";
            }
            cell.setText(name);
        }
    }

    protected static class PeersFilesViewRow {
        private DiskManagerFileInfo file;
        private PEPeer peer;

        private PeersFilesViewRow(DiskManagerFileInfo _file, PEPeer _peer) {
            this.file = _file;
            this.peer = _peer;
        }

        private DiskManagerFileInfo getFile() {
            return this.file;
        }

        private void setPeer(PEPeer _peer) {
            this.peer = _peer;
        }

        private PEPeer getPeer() {
            return this.peer;
        }
    }

    private static class PercentItem
    extends CoreTableColumnSWT
    implements TableCellRefreshListener {
        private PercentItem() {
            super("%", 2, -2, 60, PeerFilesView.TABLEID_PEER_FILES);
            this.setRefreshInterval(-2);
            this.setMinWidthAuto(true);
        }

        public void refresh(TableCell cell) {
            PeersFilesViewRow row = (PeersFilesViewRow)cell.getDataSource();
            if (row == null) {
                return;
            }
            DiskManagerFileInfo file = row.getFile();
            PEPeer peer = row.getPeer();
            BitFlags pieces = peer.getAvailable();
            if (pieces == null) {
                cell.setText("");
                return;
            }
            boolean[] flags = pieces.flags;
            int first_piece = file.getFirstPieceNumber();
            int last_piece = file.getLastPieceNumber();
            int done = 0;
            for (int i = first_piece; i <= last_piece; ++i) {
                if (!flags[i]) continue;
                ++done;
            }
            int percent = done * 1000 / (last_piece - first_piece + 1);
            if (!cell.setSortValue(percent) && cell.isValid()) {
                return;
            }
            cell.setText(percent < 0 ? "" : DisplayFormatters.formatPercentFromThousands(percent));
        }
    }
}

