/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.core.dht.DHTStorageAdapter;
import com.aelitis.azureus.core.dht.control.DHTControlActivity;
import com.aelitis.azureus.core.dht.control.DHTControlListener;
import com.aelitis.azureus.core.dht.control.DHTControlStats;
import com.aelitis.azureus.core.dht.db.DHTDBStats;
import com.aelitis.azureus.core.dht.nat.DHTNATPuncher;
import com.aelitis.azureus.core.dht.router.DHTRouterStats;
import com.aelitis.azureus.core.dht.transport.DHTTransport;
import com.aelitis.azureus.core.dht.transport.DHTTransportFullStats;
import com.aelitis.azureus.core.dht.transport.DHTTransportStats;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.PingGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.SpeedGraphic;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEvent;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;

public class DHTView
implements UISWTViewEventListener {
    public static final int DHT_TYPE_MAIN = 0;
    public static final int DHT_TYPE_CVS = 1;
    public static final int DHT_TYPE_MAIN_V6 = 3;
    public static final String MSGID_PREFIX = "DHTView";
    public static Color[] rttColours = new Color[]{Colors.grey, Colors.fadedGreen, Colors.fadedRed};
    private boolean auto_dht;
    DHT dht;
    Composite panel;
    String yes_str;
    String no_str;
    Label lblUpTime;
    Label lblNumberOfUsers;
    Label lblNodes;
    Label lblLeaves;
    Label lblContacts;
    Label lblReplacements;
    Label lblLive;
    Label lblUnknown;
    Label lblDying;
    Label lblSkew;
    Label lblRendezvous;
    Label lblReachable;
    Label lblKeys;
    Label lblValues;
    Label lblSize;
    Label lblLocal;
    Label lblDirect;
    Label lblIndirect;
    Label lblDivFreq;
    Label lblDivSize;
    Label lblReceivedPackets;
    Label lblReceivedBytes;
    Label lblSentPackets;
    Label lblSentBytes;
    Label[] lblPings = new Label[4];
    Label[] lblFindNodes = new Label[4];
    Label[] lblFindValues = new Label[4];
    Label[] lblStores = new Label[4];
    Label[] lblData = new Label[4];
    Canvas in;
    Canvas out;
    Canvas rtt;
    SpeedGraphic inGraph;
    SpeedGraphic outGraph;
    PingGraphic rttGraph;
    boolean activityChanged;
    DHTControlListener controlListener;
    Table activityTable;
    DHTControlActivity[] activities;
    private int dht_type;
    protected AzureusCore core;
    private int refreshIter = 0;
    private UISWTView swtView;

    public DHTView() {
        this(true);
    }

    public DHTView(boolean _auto_dht) {
        this.auto_dht = _auto_dht;
        this.inGraph = SpeedGraphic.getInstance();
        this.outGraph = SpeedGraphic.getInstance();
        this.rttGraph = PingGraphic.getInstance();
        this.rttGraph.setColors(rttColours);
        this.rttGraph.setExternalAverage(true);
    }

    private void init(AzureusCore core) {
        try {
            PluginInterface dht_pi = core.getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            for (int i = 0; i < dhts.length; ++i) {
                if (dhts[i].getTransport().getNetwork() != this.dht_type) continue;
                this.dht = dhts[i];
                break;
            }
            if (this.dht == null) {
                return;
            }
            this.controlListener = new DHTControlListener(){

                public void activityChanged(DHTControlActivity activity, int type) {
                    DHTView.this.activityChanged = true;
                }
            };
            this.dht.getControl().addListener(this.controlListener);
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void setDHT(DHT _dht) {
        if (this.dht == null) {
            this.dht = _dht;
            this.controlListener = new DHTControlListener(){

                public void activityChanged(DHTControlActivity activity, int type) {
                    DHTView.this.activityChanged = true;
                }
            };
            this.dht.getControl().addListener(this.controlListener);
        } else if (this.dht != _dht) {
            Debug.out("Not Supported ");
        }
    }

    public void initialize(Composite composite) {
        if (this.auto_dht) {
            AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

                public void azureusCoreRunning(AzureusCore core) {
                    DHTView.this.core = core;
                    DHTView.this.init(core);
                }
            });
        }
        this.panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        this.panel.setLayout((Layout)layout);
        this.yes_str = MessageText.getString("Button.yes").replaceAll("&", "");
        this.no_str = MessageText.getString("Button.no").replaceAll("&", "");
        this.initialiseGeneralGroup();
        this.initialiseDBGroup();
        this.initialiseTransportDetailsGroup();
        this.initialiseOperationDetailsGroup();
        this.initialiseActivityGroup();
    }

    private void initialiseGeneralGroup() {
        Group gGeneral = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gGeneral, "DHTView.general.title");
        GridData data = new GridData();
        data.verticalAlignment = 1;
        data.widthHint = 350;
        Utils.setLayoutData((Control)gGeneral, data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        gGeneral.setLayout((Layout)layout);
        Label label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.uptime");
        this.lblUpTime = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblUpTime, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.users");
        this.lblNumberOfUsers = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblNumberOfUsers, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.reachable");
        this.lblReachable = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblReachable, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.nodes");
        this.lblNodes = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblNodes, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.leaves");
        this.lblLeaves = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblLeaves, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.rendezvous");
        this.lblRendezvous = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblRendezvous, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.contacts");
        this.lblContacts = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblContacts, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.replacements");
        this.lblReplacements = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblReplacements, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.live");
        this.lblLive = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblLive, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.skew");
        this.lblSkew = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblSkew, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.unknown");
        this.lblUnknown = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblUnknown, new GridData(4, 128, true, false));
        label = new Label((Composite)gGeneral, 0);
        Messages.setLanguageText((Widget)label, "DHTView.general.dying");
        this.lblDying = new Label((Composite)gGeneral, 0);
        Utils.setLayoutData((Control)this.lblDying, new GridData(4, 128, true, false));
    }

    private void initialiseDBGroup() {
        Group gDB = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gDB, "DHTView.db.title");
        GridData data = new GridData(768);
        data.verticalAlignment = 4;
        Utils.setLayoutData((Control)gDB, data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 6;
        layout.makeColumnsEqualWidth = true;
        gDB.setLayout((Layout)layout);
        Label label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.keys");
        this.lblKeys = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblKeys, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.values");
        this.lblValues = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblValues, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "TableColumn.header.size");
        this.lblSize = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblSize, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.local");
        this.lblLocal = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblLocal, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.direct");
        this.lblDirect = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblDirect, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.indirect");
        this.lblIndirect = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblIndirect, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.divfreq");
        this.lblDivFreq = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblDivFreq, new GridData(4, 128, true, false));
        label = new Label((Composite)gDB, 0);
        Messages.setLanguageText((Widget)label, "DHTView.db.divsize");
        this.lblDivSize = new Label((Composite)gDB, 0);
        Utils.setLayoutData((Control)this.lblDivSize, new GridData(4, 128, true, false));
    }

    private void initialiseTransportDetailsGroup() {
        Group gTransport = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gTransport, "DHTView.transport.title");
        GridData data = new GridData(1040);
        data.widthHint = 350;
        data.verticalSpan = 2;
        Utils.setLayoutData((Control)gTransport, data);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        gTransport.setLayout((Layout)layout);
        Label label = new Label((Composite)gTransport, 0);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.packets");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.bytes");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.received");
        this.lblReceivedPackets = new Label((Composite)gTransport, 0);
        Utils.setLayoutData((Control)this.lblReceivedPackets, new GridData(4, 128, true, false));
        this.lblReceivedBytes = new Label((Composite)gTransport, 0);
        Utils.setLayoutData((Control)this.lblReceivedBytes, new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.sent");
        this.lblSentPackets = new Label((Composite)gTransport, 0);
        Utils.setLayoutData((Control)this.lblSentPackets, new GridData(4, 128, true, false));
        this.lblSentBytes = new Label((Composite)gTransport, 0);
        Utils.setLayoutData((Control)this.lblSentBytes, new GridData(4, 128, true, false));
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.in");
        data = new GridData();
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)label, data);
        this.in = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)this.in, data);
        this.inGraph.initialize(this.in);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.out");
        data = new GridData();
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)label, data);
        this.out = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)this.out, data);
        this.outGraph.initialize(this.out);
        label = new Label((Composite)gTransport, 0);
        Messages.setLanguageText((Widget)label, "DHTView.transport.rtt");
        data = new GridData();
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)label, data);
        this.rtt = new Canvas((Composite)gTransport, 262144);
        data = new GridData(1808);
        data.horizontalSpan = 3;
        Utils.setLayoutData((Control)this.rtt, data);
        this.rttGraph.initialize(this.rtt);
        data = new GridData(768);
        data.horizontalSpan = 3;
        Legend.createLegendComposite((Composite)gTransport, rttColours, new String[]{"DHTView.rtt.legend.average", "DHTView.rtt.legend.best", "DHTView.rtt.legend.worst"}, data);
    }

    private void initialiseOperationDetailsGroup() {
        int i;
        Group gOperations = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gOperations, "DHTView.operations.title");
        Utils.setLayoutData((Control)gOperations, new GridData(4, 1, true, false));
        GridLayout layout = new GridLayout();
        layout.numColumns = 5;
        layout.makeColumnsEqualWidth = true;
        gOperations.setLayout((Layout)layout);
        Label label = new Label((Composite)gOperations, 0);
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.sent");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.ok");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.failed");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.received");
        Utils.setLayoutData((Control)label, new GridData(4, 128, true, false));
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.ping");
        for (i = 0; i < 4; ++i) {
            this.lblPings[i] = new Label((Composite)gOperations, 0);
            Utils.setLayoutData((Control)this.lblPings[i], new GridData(4, 128, true, false));
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.findNode");
        for (i = 0; i < 4; ++i) {
            this.lblFindNodes[i] = new Label((Composite)gOperations, 0);
            Utils.setLayoutData((Control)this.lblFindNodes[i], new GridData(4, 128, true, false));
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.findValue");
        for (i = 0; i < 4; ++i) {
            this.lblFindValues[i] = new Label((Composite)gOperations, 0);
            Utils.setLayoutData((Control)this.lblFindValues[i], new GridData(4, 128, true, false));
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.store");
        for (i = 0; i < 4; ++i) {
            this.lblStores[i] = new Label((Composite)gOperations, 0);
            Utils.setLayoutData((Control)this.lblStores[i], new GridData(4, 128, true, false));
        }
        label = new Label((Composite)gOperations, 0);
        Messages.setLanguageText((Widget)label, "DHTView.operations.data");
        for (i = 0; i < 4; ++i) {
            this.lblData[i] = new Label((Composite)gOperations, 0);
            Utils.setLayoutData((Control)this.lblData[i], new GridData(4, 128, true, false));
        }
    }

    private void initialiseActivityGroup() {
        Group gActivity = new Group(this.panel, 0);
        Messages.setLanguageText((Widget)gActivity, "DHTView.activity.title");
        Utils.setLayoutData((Control)gActivity, new GridData(4, 4, true, true));
        gActivity.setLayout((Layout)new GridLayout());
        this.activityTable = new Table((Composite)gActivity, 268503044);
        Utils.setLayoutData((Control)this.activityTable, new GridData(1808));
        final TableColumn colStatus = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colStatus, "DHTView.activity.status");
        colStatus.setWidth(Utils.adjustPXForDPI(80));
        final TableColumn colType = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colType, "DHTView.activity.type");
        colType.setWidth(Utils.adjustPXForDPI(80));
        final TableColumn colName = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colName, "DHTView.activity.target");
        colName.setWidth(Utils.adjustPXForDPI(80));
        final TableColumn colDetails = new TableColumn(this.activityTable, 16384);
        Messages.setLanguageText((Widget)colDetails, "DHTView.activity.details");
        colDetails.setWidth(Utils.adjustPXForDPI(300));
        colDetails.setResizable(false);
        this.activityTable.setHeaderVisible(true);
        Listener computeLastRowWidthListener = new Listener(){
            boolean inUse = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleEvent(Event event2) {
                if (this.inUse) {
                    return;
                }
                this.inUse = true;
                try {
                    block9: {
                        block8: {
                            if (DHTView.this.activityTable == null) break block8;
                            if (!DHTView.this.activityTable.isDisposed()) break block9;
                        }
                        Object var5_2 = null;
                        this.inUse = false;
                        return;
                    }
                    int totalWidth = DHTView.this.activityTable.getClientArea().width;
                    int remainingWidth = totalWidth - colStatus.getWidth() - colType.getWidth() - colName.getWidth();
                    if (remainingWidth > 0) {
                        colDetails.setWidth(remainingWidth);
                    }
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    this.inUse = false;
                    throw throwable;
                }
                Object var5_3 = null;
                this.inUse = false;
            }
        };
        this.activityTable.addListener(11, computeLastRowWidthListener);
        colStatus.addListener(11, computeLastRowWidthListener);
        colType.addListener(11, computeLastRowWidthListener);
        colName.addListener(11, computeLastRowWidthListener);
        this.activityTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                TableItem item = (TableItem)event2.item;
                int index = DHTView.this.activityTable.indexOf(item);
                item.setText(0, MessageText.getString("DHTView.activity.status." + DHTView.this.activities[index].isQueued()));
                item.setText(1, MessageText.getString("DHTView.activity.type." + DHTView.this.activities[index].getType()));
                item.setText(2, ByteFormatter.nicePrint(DHTView.this.activities[index].getTarget()));
                item.setText(3, DHTView.this.activities[index].getDescription());
            }
        });
    }

    public void delete() {
        Utils.disposeComposite(this.panel);
        if (this.dht != null) {
            this.dht.getControl().removeListener(this.controlListener);
        }
        this.outGraph.dispose();
        this.inGraph.dispose();
        this.rttGraph.dispose();
    }

    private String getTitleID() {
        if (this.dht_type == 0) {
            return "DHTView.title.full";
        }
        if (this.dht_type == 1) {
            return "DHTView.title.fullcvs";
        }
        return "DHTView.title.full_v6";
    }

    private Composite getComposite() {
        return this.panel;
    }

    private void refresh() {
        this.inGraph.refresh(false);
        this.outGraph.refresh(false);
        this.rttGraph.refresh();
        if (this.dht == null) {
            if (this.core != null) {
                this.init(this.core);
            }
            return;
        }
        this.refreshGeneral();
        this.refreshDB();
        this.refreshTransportDetails();
        this.refreshOperationDetails();
        this.refreshActivity();
    }

    private void refreshGeneral() {
        DHTControlStats controlStats = this.dht.getControl().getStats();
        DHTRouterStats routerStats = this.dht.getRouter().getStats();
        DHTTransport transport = this.dht.getTransport();
        DHTTransportStats transportStats = transport.getStats();
        this.lblUpTime.setText(TimeFormatter.format(controlStats.getRouterUptime() / 1000L));
        this.lblNumberOfUsers.setText("" + controlStats.getEstimatedDHTSize());
        int percent = transportStats.getRouteablePercentage();
        this.lblReachable.setText((transport.isReachable() ? this.yes_str : this.no_str) + (percent == -1 ? "" : " " + percent + "%"));
        DHTNATPuncher puncher = this.dht.getNATPuncher();
        String puncher_str = puncher == null ? "" : (puncher.operational() ? this.yes_str : this.no_str);
        this.lblRendezvous.setText(transport.isReachable() ? "" : puncher_str);
        long[] stats2 = routerStats.getStats();
        this.lblNodes.setText("" + stats2[0]);
        this.lblLeaves.setText("" + stats2[1]);
        this.lblContacts.setText("" + stats2[2]);
        this.lblReplacements.setText("" + stats2[3]);
        this.lblLive.setText("" + stats2[4]);
        this.lblUnknown.setText("" + stats2[5]);
        this.lblDying.setText("" + stats2[6]);
        long skew_average = transportStats.getSkewAverage();
        this.lblSkew.setText(skew_average == 0L ? "" : (skew_average < 0L ? "-" : "") + TimeFormatter.format100ths(Math.abs(skew_average)));
    }

    private void refreshDB() {
        if (this.refreshIter == 0) {
            String rem_size;
            String rem_freq;
            DHTDBStats dbStats = this.dht.getDataBase().getStats();
            this.lblKeys.setText("" + dbStats.getKeyCount() + " (" + dbStats.getLocalKeyCount() + ")");
            int[] stats2 = dbStats.getValueDetails();
            this.lblValues.setText("" + stats2[0]);
            this.lblSize.setText(DisplayFormatters.formatByteCountToKiBEtc(dbStats.getSize()));
            this.lblDirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[2]));
            this.lblIndirect.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[3]));
            this.lblLocal.setText(DisplayFormatters.formatByteCountToKiBEtc(stats2[1]));
            DHTStorageAdapter sa = this.dht.getStorageAdapter();
            if (sa == null) {
                rem_freq = "-";
                rem_size = "-";
            } else {
                rem_freq = "" + sa.getRemoteFreqDivCount();
                rem_size = "" + sa.getRemoteSizeDivCount();
            }
            this.lblDivFreq.setText("" + stats2[4] + " (" + rem_freq + ")");
            this.lblDivSize.setText("" + stats2[5] + " (" + rem_size + ")");
        } else {
            ++this.refreshIter;
            if (this.refreshIter == 100) {
                this.refreshIter = 0;
            }
        }
    }

    private void refreshTransportDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        this.lblReceivedBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesReceived()));
        this.lblSentBytes.setText(DisplayFormatters.formatByteCountToKiBEtc(transportStats.getBytesSent()));
        this.lblReceivedPackets.setText("" + transportStats.getPacketsReceived());
        this.lblSentPackets.setText("" + transportStats.getPacketsSent());
    }

    private void refreshOperationDetails() {
        DHTTransportStats transportStats = this.dht.getTransport().getStats();
        long[] pings = transportStats.getPings();
        for (int i = 0; i < 4; ++i) {
            this.lblPings[i].setText("" + pings[i]);
        }
        long[] findNodes = transportStats.getFindNodes();
        for (int i = 0; i < 4; ++i) {
            this.lblFindNodes[i].setText("" + findNodes[i]);
        }
        long[] findValues = transportStats.getFindValues();
        for (int i = 0; i < 4; ++i) {
            this.lblFindValues[i].setText("" + findValues[i]);
        }
        long[] stores = transportStats.getStores();
        long[] qstores = transportStats.getQueryStores();
        for (int i = 0; i < 4; ++i) {
            this.lblStores[i].setText("" + stores[i] + " (" + qstores[i] + ")");
        }
        long[] data = transportStats.getData();
        for (int i = 0; i < 4; ++i) {
            this.lblData[i].setText("" + data[i]);
        }
    }

    private void refreshActivity() {
        if (this.activityChanged) {
            this.activityChanged = false;
            this.activities = this.dht.getControl().getActivities();
            this.activityTable.setItemCount(this.activities.length);
            this.activityTable.clearAll();
            this.activityTable.redraw();
        }
    }

    public void periodicUpdate() {
        if (this.dht == null) {
            return;
        }
        DHTTransportFullStats fullStats = this.dht.getTransport().getLocalContact().getStats();
        if (fullStats != null) {
            this.inGraph.addIntValue((int)fullStats.getAverageBytesReceived());
            this.outGraph.addIntValue((int)fullStats.getAverageBytesSent());
        }
        DHTTransportStats stats2 = this.dht.getTransport().getStats();
        int[] rtts = (int[])stats2.getRTTHistory().clone();
        Arrays.sort(rtts);
        int rtt_total = 0;
        int rtt_num = 0;
        int start = 0;
        for (int rtt : rtts) {
            if (rtt > 0) {
                rtt_total += rtt;
                ++rtt_num;
                continue;
            }
            ++start;
        }
        int average = 0;
        int best = 0;
        int worst = 0;
        if (rtt_num > 0) {
            average = rtt_total / rtt_num;
        }
        int chunk = rtt_num / 3;
        int max_best = start + chunk;
        int min_worst = rtts.length - 1 - chunk;
        int worst_total = 0;
        int worst_num = 0;
        int best_total = 0;
        int best_num = 0;
        for (int i = start; i < rtts.length; ++i) {
            if (i < max_best) {
                best_total += rtts[i];
                ++best_num;
                continue;
            }
            if (i <= min_worst) continue;
            worst_total += rtts[i];
            ++worst_num;
        }
        if (best_num > 0) {
            best = best_total / best_num;
        }
        if (worst_num > 0) {
            worst = worst_total / worst_num;
        }
        this.rttGraph.addIntsValue(new int[]{average, best, worst});
    }

    public boolean eventOccurred(UISWTViewEvent event2) {
        switch (event2.getType()) {
            case 0: {
                this.swtView = (UISWTView)event2.getData();
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 7: {
                this.delete();
                break;
            }
            case 2: {
                this.initialize((Composite)event2.getData());
                break;
            }
            case 6: {
                Messages.updateLanguageForControl((Widget)this.getComposite());
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 1: {
                if (!(event2.getData() instanceof Number)) break;
                this.dht_type = ((Number)event2.getData()).intValue();
                if (this.swtView == null) break;
                this.swtView.setTitle(MessageText.getString(this.getTitleID()));
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                this.refresh();
                break;
            }
            case 256: {
                this.periodicUpdate();
            }
        }
        return true;
    }
}

