/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.common.table.TableCellCore;
import com.aelitis.azureus.ui.common.table.TableColumnCore;
import com.aelitis.azureus.ui.common.table.TableGroupRowRunner;
import com.aelitis.azureus.ui.common.table.TableRowCore;
import com.aelitis.azureus.ui.common.table.TableStructureEventDispatcher;
import com.aelitis.azureus.ui.common.table.TableStructureModificationListener;
import com.aelitis.azureus.ui.common.table.impl.TableColumnManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuBuilder;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableRowMouseListener;
import org.gudy.azureus2.pluginsimpl.local.ui.menus.MenuItemImpl;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.views.columnsetup.TableColumnSetupWindow;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWT;
import org.gudy.azureus2.ui.swt.views.table.TableRowSWTPaintListener;
import org.gudy.azureus2.ui.swt.views.table.TableSelectedRowsListener;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTFilter;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWTMenuFillListener;
import org.gudy.azureus2.ui.swt.views.table.utils.TableContextMenuManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWT_Common
implements MouseListener,
MouseMoveListener,
SelectionListener,
KeyListener {
    TableViewSWT<?> tv;
    private long lCancelSelectionTriggeredOn = -1L;
    private long lastSelectionTriggeredOn = -1L;
    private static final int ASYOUTYPE_MODE_FIND = 0;
    private static final int ASYOUTYPE_MODE_FILTER = 1;
    private static final int ASYOUTYPE_MODE = 1;
    private static final int ASYOUTYPE_UPDATEDELAY = 300;
    private static final Color COLOR_FILTER_REGEX = Colors.fadedYellow;
    private static Font FONT_NO_REGEX;
    private static Font FONT_REGEX;
    private static Font FONT_REGEX_ERROR;
    private List<TableViewSWTMenuFillListener> listenersMenuFill = new ArrayList<TableViewSWTMenuFillListener>(1);
    private List<KeyListener> listenersKey = new ArrayList<KeyListener>(1);
    private ArrayList<TableRowMouseListener> rowMouseListeners;
    private static AEMonitor mon_RowMouseListener;
    private static AEMonitor mon_RowPaintListener;
    public int xAdj = 0;
    public int yAdj = 0;
    private ArrayList<TableRowSWTPaintListener> rowPaintListeners;
    long lastMouseDblClkEventTime = 0L;
    long lastMouseUpEventTime = 0L;
    Point lastMouseUpPos = new Point(0, 0);
    boolean mouseDown = false;
    TableRowSWT mouseDownOnRow = null;
    TableRowCore lastClickRow;
    TableCellCore lastCell = null;
    int lastCursorID = 0;

    public TableViewSWT_Common(TableViewSWT<?> tv) {
        this.tv = tv;
    }

    public void mouseDoubleClick(MouseEvent e) {
        TableCellMouseEvent event2;
        long time = (long)e.time & 0xFFFFFFFFL;
        long diff = time - this.lastMouseDblClkEventTime;
        if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L) {
            return;
        }
        this.lastMouseDblClkEventTime = time;
        TableColumnCore tc = this.tv.getTableColumnByOffset(e.x);
        TableCellCore cell = this.tv.getTableCell(e.x, e.y);
        if (cell != null && tc != null && (event2 = this.createMouseEvent(cell, e, 2, false)) != null) {
            tc.invokeCellMouseListeners(event2);
            cell.invokeMouseListeners(event2);
            if (event2.skipCoreFunctionality) {
                this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
            }
        }
    }

    public void mouseUp(MouseEvent e) {
        TableCellMouseEvent event2;
        if (!this.mouseDown) {
            return;
        }
        this.mouseDown = false;
        TableColumnCore tc = this.tv.getTableColumnByOffset(e.x);
        TableCellCore cell = this.tv.getTableCell(e.x, e.y);
        this.mouseUp(this.mouseDownOnRow, cell, e.button, e.stateMask);
        if (e.button == 1) {
            long time = (long)e.time & 0xFFFFFFFFL;
            long diff = time - this.lastMouseUpEventTime;
            if (diff <= (long)e.display.getDoubleClickTime() && diff >= 0L && this.lastMouseUpPos.x == e.x && this.lastMouseUpPos.y == e.y) {
                this.runDefaultAction(e.stateMask);
                return;
            }
            this.lastMouseUpEventTime = time;
            this.lastMouseUpPos = new Point(e.x, e.y);
        }
        if (cell != null && tc != null && (event2 = this.createMouseEvent(cell, e, 1, false)) != null) {
            tc.invokeCellMouseListeners(event2);
            cell.invokeMouseListeners(event2);
            if (event2.skipCoreFunctionality) {
                this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
            }
        }
    }

    public void mouseDown(MouseEvent e) {
        TableRowMouseEvent event2;
        this.mouseDown = true;
        TableRowSWT row = this.mouseDownOnRow = this.tv.getTableRow(e.x, e.y, false);
        TableCellCore cell = this.tv.getTableCell(e.x, e.y);
        TableColumnCore tc = cell == null ? null : cell.getTableColumnCore();
        this.mouseDown(row, cell, e.button, e.stateMask);
        if (row == null) {
            this.tv.setSelectedRows(new TableRowCore[0]);
        }
        this.tv.editCell(null, -1);
        if (cell != null && tc != null) {
            TableCellMouseEvent event3 = this.createMouseEvent(cell, e, 0, false);
            if (event3 != null) {
                tc.invokeCellMouseListeners(event3);
                cell.invokeMouseListeners(event3);
                this.tv.invokeRowMouseListener(event3);
                if (event3.skipCoreFunctionality) {
                    this.lCancelSelectionTriggeredOn = System.currentTimeMillis();
                }
            }
            if (tc.hasInplaceEditorListener() && e.button == 1 && this.lastClickRow == cell.getTableRowCore()) {
                this.tv.editCell(this.tv.getTableColumnByOffset(e.x), cell.getTableRowCore().getIndex());
            }
            if (e.button == 1) {
                this.lastClickRow = cell.getTableRowCore();
            }
        } else if (row != null && (event2 = this.createMouseEvent(row, e, 0, false)) != null) {
            this.tv.invokeRowMouseListener(event2);
        }
    }

    public void mouseDown(TableRowSWT row, TableCellCore cell, int button, int stateMask) {
    }

    public void mouseUp(TableRowCore row, TableCellCore cell, int button, int stateMask) {
    }

    private TableCellMouseEvent createMouseEvent(TableCellCore cell, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.cell = cell;
        if (cell != null) {
            event2.row = cell.getTableRow();
        }
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (cell instanceof TableCellSWT) {
            Rectangle r = ((TableCellSWT)cell).getBounds();
            if (r == null) {
                return event2;
            }
            event2.x = e.x - r.x - this.xAdj;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y - this.yAdj;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    private TableRowMouseEvent createMouseEvent(TableRowSWT row, MouseEvent e, int type, boolean allowOOB) {
        TableCellMouseEvent event2 = new TableCellMouseEvent();
        event2.row = row;
        event2.eventType = type;
        event2.button = e.button;
        event2.keyboardState = e.stateMask;
        event2.skipCoreFunctionality = false;
        if (row != null) {
            Rectangle r = row.getBounds();
            event2.x = e.x - r.x - this.xAdj;
            if (!allowOOB && event2.x < 0) {
                return null;
            }
            event2.y = e.y - r.y - this.yAdj;
            if (!allowOOB && event2.y < 0) {
                return null;
            }
        }
        return event2;
    }

    public void mouseMove(MouseEvent e) {
        this.lCancelSelectionTriggeredOn = -1L;
        if (this.tv.isDragging()) {
            return;
        }
        try {
            TableCellMouseEvent event2;
            TableCellCore cell = this.tv.getTableCell(e.x, e.y);
            if (cell != this.lastCell) {
                TableColumnCore tc;
                TableCellMouseEvent event3;
                if (this.lastCell != null && !this.lastCell.isDisposed() && (event3 = this.createMouseEvent(this.lastCell, e, 5, true)) != null) {
                    ((TableCellSWT)this.lastCell).setMouseOver(false);
                    tc = (TableColumnCore)this.lastCell.getTableColumn();
                    if (tc != null) {
                        tc.invokeCellMouseListeners(event3);
                    }
                    this.lastCell.invokeMouseListeners(event3);
                }
                if (cell != null && !cell.isDisposed() && (event3 = this.createMouseEvent(cell, e, 4, false)) != null) {
                    ((TableCellSWT)cell).setMouseOver(true);
                    tc = (TableColumnCore)cell.getTableColumn();
                    if (tc != null) {
                        tc.invokeCellMouseListeners(event3);
                    }
                    cell.invokeMouseListeners(event3);
                }
            }
            int iCursorID = 0;
            if (cell == null) {
                this.lastCell = null;
            } else if (cell == this.lastCell) {
                iCursorID = this.lastCursorID;
            } else {
                iCursorID = cell.getCursorID();
                this.lastCell = cell;
            }
            if (iCursorID < 0) {
                iCursorID = 0;
            }
            if (iCursorID != this.lastCursorID) {
                this.lastCursorID = iCursorID;
                if (iCursorID >= 0) {
                    this.tv.getComposite().setCursor(this.tv.getComposite().getDisplay().getSystemCursor(iCursorID));
                } else {
                    this.tv.getComposite().setCursor(null);
                }
            }
            if (cell != null && (event2 = this.createMouseEvent(cell, e, 3, false)) != null) {
                TableColumnCore tc = (TableColumnCore)cell.getTableColumn();
                if (tc.hasCellMouseMoveListener()) {
                    ((TableColumnCore)cell.getTableColumn()).invokeCellMouseListeners(event2);
                }
                cell.invokeMouseListeners(event2);
                iCursorID = cell.getCursorID();
                if (iCursorID != this.lastCursorID) {
                    this.lastCursorID = iCursorID;
                    if (iCursorID >= 0) {
                        this.tv.getComposite().setCursor(this.tv.getComposite().getDisplay().getSystemCursor(iCursorID));
                    } else {
                        this.tv.getComposite().setCursor(null);
                    }
                }
            }
        }
        catch (Exception ex) {
            Debug.out(ex);
        }
    }

    public void widgetSelected(SelectionEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        if (this.lCancelSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lCancelSelectionTriggeredOn < 200L) {
            e.doit = false;
        } else {
            this.runDefaultAction(e.stateMask);
        }
    }

    public void keyPressed(KeyEvent event2) {
        KeyListener[] listeners;
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (event2.widget != null && filter2 != null && event2.widget == filter2.widget && (event2.character == '\u007f' || event2.character == '\b')) {
            this.handleSearchKeyPress(event2);
            return;
        }
        for (KeyListener l : listeners = this.tv.getKeyListeners()) {
            l.keyPressed(event2);
            if (event2.doit) continue;
            this.lCancelSelectionTriggeredOn = SystemTime.getCurrentTime();
            return;
        }
        if (event2.keyCode == 0x100000E) {
            if ((event2.stateMask & 0x20000) != 0) {
                this.tv.runForSelectedRows(new TableGroupRowRunner(){

                    public void run(TableRowCore row) {
                        row.invalidate();
                        row.refresh(true);
                    }
                });
            } else if ((event2.stateMask & 0x40000) != 0) {
                this.tv.runForAllRows(new TableGroupRowRunner(){

                    public void run(TableRowCore row) {
                        row.invalidate();
                        row.refresh(true);
                    }
                });
            } else {
                this.tv.sortColumn(true);
            }
            event2.doit = false;
            return;
        }
        int key = event2.character;
        if (key <= 26 && key > 0) {
            key += 96;
        }
        if (event2.stateMask == SWT.MOD1) {
            switch (key) {
                case 97: {
                    if (filter2 == null || event2.widget != filter2.widget) {
                        if (this.tv.isSingleSelection()) break;
                        this.tv.selectAll();
                        event2.doit = false;
                        break;
                    }
                    filter2.widget.selectAll();
                    event2.doit = false;
                    break;
                }
                case 43: {
                    if (!Constants.isUnix) break;
                    this.tv.expandColumns();
                    event2.doit = false;
                    break;
                }
                case 102: {
                    this.tv.openFilterDialog();
                    event2.doit = false;
                    break;
                }
                case 120: {
                    if (filter2 == null || event2.widget != filter2.widget) break;
                    filter2.regex = !filter2.regex;
                    filter2.widget.setBackground((Color)(filter2.regex ? COLOR_FILTER_REGEX : null));
                    this.validateFilterRegex();
                    this.tv.refilter();
                    return;
                }
                case 103: {
                    System.out.println("force sort");
                    this.tv.resetLastSortedOn();
                    this.tv.sortColumn(true);
                }
            }
        }
        if (event2.stateMask == 0 && filter2 != null && filter2.widget == event2.widget) {
            if (event2.keyCode == 0x1000002) {
                this.tv.setFocus();
                event2.doit = false;
            } else if (event2.character == '\r') {
                this.tv.refilter();
            }
        }
        if (!event2.doit) {
            return;
        }
        this.handleSearchKeyPress(event2);
    }

    private void handleSearchKeyPress(KeyEvent e) {
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (filter2 == null || e.widget == filter2.widget) {
            return;
        }
        String newText = null;
        if (e.keyCode == 8) {
            if (e.stateMask == 262144) {
                newText = "";
            } else if (filter2.nextText.length() > 0) {
                newText = filter2.nextText.substring(0, filter2.nextText.length() - 1);
            }
        } else if ((e.stateMask & 0xFFFDFFFF) == 0 && e.character > ' ' && e.character != '\u007f') {
            newText = filter2.nextText + String.valueOf(e.character);
        }
        if (newText == null) {
            return;
        }
        if (filter2 != null && filter2.widget != null && !filter2.widget.isDisposed()) {
            filter2.widget.setFocus();
        }
        this.tv.setFilterText(newText);
        e.doit = false;
    }

    private void validateFilterRegex() {
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (filter2.regex) {
            if (FONT_NO_REGEX == null) {
                int i;
                FONT_NO_REGEX = filter2.widget.getFont();
                FontData[] fd = FONT_NO_REGEX.getFontData();
                for (i = 0; i < fd.length; ++i) {
                    fd[i].setStyle(1);
                }
                FONT_REGEX = new Font((Device)filter2.widget.getDisplay(), fd);
                for (i = 0; i < fd.length; ++i) {
                    fd[i].setStyle(2);
                }
                FONT_REGEX_ERROR = new Font((Device)filter2.widget.getDisplay(), fd);
            }
            try {
                Pattern.compile(filter2.nextText, 2);
                filter2.widget.setBackground(COLOR_FILTER_REGEX);
                filter2.widget.setFont(FONT_REGEX);
                Messages.setLanguageTooltip((Widget)filter2.widget, "MyTorrentsView.filter.tooltip");
            }
            catch (Exception e) {
                filter2.widget.setBackground(Colors.colorErrorBG);
                filter2.widget.setToolTipText(e.getMessage());
                filter2.widget.setFont(FONT_REGEX_ERROR);
            }
        } else {
            filter2.widget.setBackground(null);
            Messages.setLanguageTooltip((Widget)filter2.widget, "MyTorrentsView.filter.tooltip");
            if (FONT_NO_REGEX != null) {
                filter2.widget.setFont(FONT_NO_REGEX);
            }
        }
    }

    public void setFilterText(String s) {
        TableViewSWTFilter filter2 = this.tv.getSWTFilter();
        if (filter2 == null) {
            return;
        }
        filter2.nextText = s;
        if (filter2 != null && filter2.widget != null && !filter2.widget.isDisposed()) {
            if (!filter2.nextText.equals(filter2.widget.getText())) {
                filter2.widget.setText(filter2.nextText);
                filter2.widget.setSelection(filter2.nextText.length());
            }
            this.validateFilterRegex();
        }
        if (filter2.eventUpdate != null) {
            filter2.eventUpdate.cancel();
        }
        filter2.eventUpdate = SimpleTimer.addEvent("SearchUpdate", SystemTime.getOffsetTime(300L), new TimerEventPerformer(){

            public void perform(TimerEvent event2) {
                TableViewSWTFilter filter2 = TableViewSWT_Common.this.tv.getSWTFilter();
                if (filter2 == null) {
                    return;
                }
                if (filter2.eventUpdate == null || filter2.eventUpdate.isCancelled()) {
                    filter2.eventUpdate = null;
                    return;
                }
                filter2.eventUpdate = null;
                if (filter2.nextText != null && !filter2.nextText.equals(filter2.text)) {
                    filter2.text = filter2.nextText;
                    filter2.checker.filterSet(filter2.text);
                    TableViewSWT_Common.this.tv.refilter();
                }
            }
        });
    }

    public void runDefaultAction(int stateMask) {
        if (this.lastSelectionTriggeredOn > 0L && System.currentTimeMillis() - this.lastSelectionTriggeredOn < 200L) {
            return;
        }
        if (System.currentTimeMillis() - this.lCancelSelectionTriggeredOn > 200L) {
            this.lastSelectionTriggeredOn = System.currentTimeMillis();
            TableRowCore[] selectedRows = this.tv.getSelectedRows();
            this.tv.triggerDefaultSelectedListeners(selectedRows, stateMask);
        }
    }

    public void keyReleased(KeyEvent event2) {
        KeyListener[] listeners;
        for (KeyListener l : listeners = this.tv.getKeyListeners()) {
            l.keyReleased(event2);
            if (event2.doit) continue;
            return;
        }
    }

    public void addKeyListener(KeyListener listener) {
        if (this.listenersKey.contains(listener)) {
            return;
        }
        this.listenersKey.add(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.listenersKey.remove(listener);
    }

    public KeyListener[] getKeyListeners() {
        return this.listenersKey.toArray(new KeyListener[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                this.rowMouseListeners = new ArrayList(1);
            }
            this.rowMouseListeners.add(listener);
            Object var3_2 = null;
            mon_RowMouseListener.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_RowMouseListener.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowMouseListener(TableRowMouseListener listener) {
        try {
            mon_RowMouseListener.enter();
            if (this.rowMouseListeners == null) {
                Object var3_2 = null;
                mon_RowMouseListener.exit();
                return;
            }
            this.rowMouseListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mon_RowMouseListener.exit();
            throw throwable;
        }
        Object var3_3 = null;
        mon_RowMouseListener.exit();
    }

    public void invokeRowMouseListener(TableRowMouseEvent event2) {
        if (this.rowMouseListeners == null) {
            return;
        }
        ArrayList<TableRowMouseListener> listeners = new ArrayList<TableRowMouseListener>(this.rowMouseListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowMouseListener l = listeners.get(i);
                l.rowMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                this.rowPaintListeners = new ArrayList(1);
            }
            this.rowPaintListeners.add(listener);
            Object var3_2 = null;
            mon_RowPaintListener.exit();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            mon_RowPaintListener.exit();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowPaintListener(TableRowSWTPaintListener listener) {
        try {
            mon_RowPaintListener.enter();
            if (this.rowPaintListeners == null) {
                Object var3_2 = null;
                mon_RowPaintListener.exit();
                return;
            }
            this.rowPaintListeners.remove(listener);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            mon_RowPaintListener.exit();
            throw throwable;
        }
        Object var3_3 = null;
        mon_RowPaintListener.exit();
    }

    public void invokePaintListeners(GC gc, TableRowCore row, TableColumnCore column, Rectangle cellArea) {
        if (this.rowPaintListeners == null) {
            return;
        }
        ArrayList<TableRowSWTPaintListener> listeners = new ArrayList<TableRowSWTPaintListener>(this.rowPaintListeners);
        for (int i = 0; i < listeners.size(); ++i) {
            try {
                TableRowSWTPaintListener l = listeners.get(i);
                l.rowPaint(gc, row, column, cellArea);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void fillMenu(Menu menu, final TableColumnCore column) {
        boolean isDownloadContext;
        TableRowCore[] selectedRows;
        String columnName = column == null ? null : column.getName();
        Object[] listeners = this.listenersMenuFill.toArray();
        for (int i = 0; i < listeners.length; ++i) {
            TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
            l.fillMenu(columnName, menu);
        }
        boolean hasLevel1 = false;
        boolean hasLevel2 = false;
        for (TableRowCore row : selectedRows = this.tv.getSelectedRows()) {
            if (row.getParentRowCore() != null) {
                hasLevel2 = true;
                continue;
            }
            hasLevel1 = true;
        }
        String tableID = this.tv.getTableID();
        String sMenuID = hasLevel1 ? tableID : "Files";
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = null;
        if (Download.class.isAssignableFrom(this.tv.getDataSourceType()) && !hasLevel2) {
            menu_items = MenuItemManager.getInstance().getAllAsArray("download_context");
            isDownloadContext = true;
        } else {
            menu_items = MenuItemManager.getInstance().getAllAsArray((String)null);
            isDownloadContext = false;
        }
        if (columnName == null) {
            MenuItem itemChangeTable = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
            Utils.setMenuItemImage(itemChangeTable, "columns");
            itemChangeTable.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWT_Common.this.showColumnEditor();
                }
            });
        } else {
            MenuItem item = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.thisColumn.toClipboard");
            item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableRowCore[] rows;
                    String sToClipboard = "";
                    if (column == null) {
                        return;
                    }
                    String columnName = column.getName();
                    if (columnName == null) {
                        return;
                    }
                    for (TableRowCore row : rows = TableViewSWT_Common.this.tv.getSelectedRows()) {
                        TableCellCore cell;
                        if (row != rows[0]) {
                            sToClipboard = sToClipboard + "\n";
                        }
                        if ((cell = row.getTableCellCore(columnName)) == null) continue;
                        sToClipboard = sToClipboard + cell.getClipboardText();
                    }
                    if (sToClipboard.length() == 0) {
                        return;
                    }
                    new Clipboard(Display.getDefault()).setContents(new Object[]{sToClipboard}, new Transfer[]{TextTransfer.getInstance()});
                }
            });
        }
        boolean enable_items = selectedRows.length > 0;
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = TableContextMenuManager.getInstance().getAllAsArray(sMenuID);
        if (items.length > 0 || menu_items.length > 0) {
            new MenuItem(menu, 2);
            if (menu_items != null) {
                Object[] target;
                if (isDownloadContext) {
                    Object[] dataSources = this.tv.getSelectedDataSources(false);
                    target = new Download[dataSources.length];
                    System.arraycopy(dataSources, 0, target, 0, target.length);
                } else {
                    target = selectedRows;
                }
                MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(target));
            }
            if (items.length > 0) {
                MenuBuildUtils.addPluginMenuItems(items, menu, true, enable_items, new MenuBuildUtils.PluginMenuController(){

                    public Listener makeSelectionListener(final org.gudy.azureus2.plugins.ui.menus.MenuItem plugin_menu_item) {
                        return new TableSelectedRowsListener(TableViewSWT_Common.this.tv, false){

                            public boolean run(TableRowCore[] rows) {
                                if (rows.length != 0) {
                                    ((MenuItemImpl)plugin_menu_item).invokeListenersMulti(rows);
                                }
                                return true;
                            }
                        };
                    }

                    public void notifyFillListeners(org.gudy.azureus2.plugins.ui.menus.MenuItem menu_item) {
                        ((MenuItemImpl)menu_item).invokeMenuWillBeShownListeners(TableViewSWT_Common.this.tv.getSelectedRows());
                    }

                    public void buildSubmenu(org.gudy.azureus2.plugins.ui.menus.MenuItem parent) {
                        MenuBuilder submenuBuilder = ((MenuItemImpl)parent).getSubmenuBuilder();
                        if (submenuBuilder != null) {
                            try {
                                parent.removeAllChildItems();
                                submenuBuilder.buildSubmenu(parent, TableViewSWT_Common.this.tv.getSelectedRows());
                            }
                            catch (Throwable t) {
                                Debug.out(t);
                            }
                        }
                    }
                });
            }
        }
        if (hasLevel1) {
            org.gudy.azureus2.plugins.ui.menus.MenuItem[] columnItems;
            if (column != null && (columnItems = column.getContextMenuItems(2)).length > 0) {
                new MenuItem(menu, 2);
                MenuBuildUtils.addPluginMenuItems(columnItems, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.tv.getSelectedDataSources(true)));
            }
            if (this.tv.getSWTFilter() != null) {
                MenuItem itemFilter = new MenuItem(menu, 8);
                Messages.setLanguageText((Widget)itemFilter, "MyTorrentsView.menu.filter");
                itemFilter.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        TableViewSWT_Common.this.tv.openFilterDialog();
                    }
                });
            }
        }
    }

    public void showColumnEditor() {
        TableRowCore focusedRow = this.tv.getFocusedRow();
        if (focusedRow == null || focusedRow.isRowDisposed()) {
            focusedRow = this.tv.getRow(0);
        }
        String tableID = this.tv.getTableID();
        new TableColumnSetupWindow(this.tv.getDataSourceType(), tableID, focusedRow, TableStructureEventDispatcher.getInstance(tableID)).open();
    }

    public void fillColumnMenu(final Menu menu, final TableColumnCore column, boolean isBlankArea) {
        String tableID = this.tv.getTableID();
        int hiddenColumnCount = 0;
        if (!isBlankArea) {
            TableColumnManager tcm = TableColumnManager.getInstance();
            TableColumnCore[] allTableColumns = tcm.getAllTableColumnCoreAsArray(this.tv.getDataSourceType(), tableID);
            Arrays.sort(allTableColumns, TableColumnManager.getTableColumnOrderComparator());
            for (final TableColumnCore tc : allTableColumns) {
                TableColumnInfo columnInfo;
                boolean visible = tc.isVisible();
                if (!visible && (columnInfo = tcm.getColumnInfo(this.tv.getDataSourceType(), tableID, tc.getName())).getProficiency() != 0) {
                    ++hiddenColumnCount;
                    continue;
                }
                MenuItem menuItem = new MenuItem(menu, 32);
                Messages.setLanguageText((Widget)menuItem, tc.getTitleLanguageKey());
                if (visible) {
                    menuItem.setSelection(true);
                }
                menuItem.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        tc.setVisible(!tc.isVisible());
                        TableColumnManager tcm = TableColumnManager.getInstance();
                        String tableID = TableViewSWT_Common.this.tv.getTableID();
                        tcm.saveTableColumns(TableViewSWT_Common.this.tv.getDataSourceType(), tableID);
                        if (TableViewSWT_Common.this.tv instanceof TableStructureModificationListener) {
                            ((TableStructureModificationListener)((Object)TableViewSWT_Common.this.tv)).tableStructureChanged(true, null);
                        }
                    }
                });
            }
        }
        if (hiddenColumnCount > 0) {
            MenuItem itemMoreHidden = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)itemMoreHidden, "MyTorrentsView.menu.moreColHidden", new String[]{String.valueOf(hiddenColumnCount)});
            itemMoreHidden.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TableViewSWT_Common.this.showColumnEditor();
                }
            });
        }
        if (menu.getItemCount() > 0) {
            new MenuItem(menu, 2);
        }
        if (column != null) {
            MenuItem renameColumn = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)renameColumn, "MyTorrentsView.menu.renameColumn");
            renameColumn.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("ColumnRenameWindow.title", "ColumnRenameWindow.message");
                    String existing_name = column.getNameOverride();
                    if (existing_name == null) {
                        existing_name = "";
                    }
                    entryWindow.setPreenteredText(existing_name, false);
                    entryWindow.selectPreenteredText(true);
                    entryWindow.prompt();
                    if (entryWindow.hasSubmittedInput()) {
                        String name = entryWindow.getSubmittedInput().trim();
                        if (name.length() == 0) {
                            name = null;
                        }
                        column.setNameOverride(name);
                        TableColumnManager tcm = TableColumnManager.getInstance();
                        String tableID = TableViewSWT_Common.this.tv.getTableID();
                        tcm.saveTableColumns(TableViewSWT_Common.this.tv.getDataSourceType(), tableID);
                        TableStructureEventDispatcher.getInstance(tableID).tableStructureChanged(true, null);
                    }
                }
            });
        }
        MenuItem itemResetColumns = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemResetColumns, "table.columns.reset");
        itemResetColumns.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                String tableID = TableViewSWT_Common.this.tv.getTableID();
                TableColumnManager tcm = TableColumnManager.getInstance();
                tcm.resetColumns(TableViewSWT_Common.this.tv.getDataSourceType(), tableID);
            }
        });
        MenuItem itemChangeTable = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)itemChangeTable, "MyTorrentsView.menu.editTableColumns");
        Utils.setMenuItemImage(itemChangeTable, "columns");
        itemChangeTable.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableViewSWT_Common.this.showColumnEditor();
            }
        });
        menu.setData("column", (Object)column);
        if (column == null) {
            return;
        }
        String sColumnName = column.getName();
        if (sColumnName != null) {
            Object[] listeners = this.listenersMenuFill.toArray();
            for (int i = 0; i < listeners.length; ++i) {
                TableViewSWTMenuFillListener l = (TableViewSWTMenuFillListener)listeners[i];
                l.addThisColumnSubMenu(sColumnName, menu);
            }
        }
        final MenuItem at_item = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)at_item, "MyTorrentsView.menu.thisColumn.autoTooltip");
        at_item.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TableColumnCore tcc = (TableColumnCore)menu.getData("column");
                tcc.setAutoTooltip(at_item.getSelection());
                tcc.invalidateCells();
            }
        });
        at_item.setSelection(column.doesAutoTooltip());
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] items = column.getContextMenuItems(1);
        if (items.length > 0) {
            new MenuItem(menu, 2);
            MenuBuildUtils.addPluginMenuItems(items, menu, true, true, new MenuBuildUtils.MenuItemPluginMenuControllerImpl(this.tv.getSelectedDataSources(true)));
        }
    }

    public void addMenuFillListener(TableViewSWTMenuFillListener l) {
        this.listenersMenuFill.add(l);
    }

    static {
        mon_RowMouseListener = new AEMonitor("rml");
        mon_RowPaintListener = new AEMonitor("rpl");
    }
}

