/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.table.TableView;
import com.aelitis.azureus.ui.mdi.MdiEntry;
import com.aelitis.azureus.ui.mdi.MdiEntryCreationListener2;
import com.aelitis.azureus.ui.mdi.MultipleDocumentInterface;
import com.aelitis.azureus.ui.selectedcontent.ISelectedContent;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentListener;
import com.aelitis.azureus.ui.selectedcontent.SelectedContentManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.mdi.MdiEntrySWT;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiInterface;
import com.aelitis.azureus.ui.swt.mdi.TabbedMdiMaximizeListener;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.ConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.menus.MenuManager;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.plugins.UISWTInstance;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewCore;
import org.gudy.azureus2.ui.swt.views.table.TableViewSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableViewSWT_TabsCommon
implements SelectedContentListener {
    UISWTView parentView;
    TableViewSWT<?> tv;
    public Composite tableComposite;
    private TableView<?> tvOverride;
    private Sash sash;
    private TabbedMdiInterface tabbedMDI;
    private Composite cTabsHolder;
    private FormData fdHeightChanger;
    private MenuItem menuItemShowTabs;
    private ISelectedContent[] selectedContent;

    public TableViewSWT_TabsCommon(UISWTView parentView, TableViewSWT<?> tv) {
        this.parentView = parentView;
        this.tv = tv;
    }

    public void triggerTabViewsDataSourceChanged(TableView<?> tv) {
        if (this.tabbedMDI == null || this.tabbedMDI.isDisposed()) {
            return;
        }
        MdiEntry[] entries = this.tabbedMDI.getEntries();
        if (entries == null || entries.length == 0) {
            return;
        }
        Object[] ds = tv.getSelectedDataSources(true);
        for (MdiEntry entry : entries) {
            if (!(entry instanceof MdiEntrySWT)) continue;
            this.triggerTabViewDataSourceChanged((MdiEntrySWT)entry, tv, ds);
        }
    }

    public void setTvOverride(TableView<?> tvOverride) {
        this.tvOverride = tvOverride;
        this.selectedContent = SelectedContentManager.getCurrentlySelectedContent();
    }

    public void triggerTabViewDataSourceChanged(MdiEntrySWT view, TableView<?> tv, Object[] dataSourcesCore) {
        if (this.tvOverride != null) {
            tv = this.tvOverride;
        }
        if (view == null) {
            return;
        }
        if (dataSourcesCore == null) {
            dataSourcesCore = tv.getSelectedDataSources(true);
        }
        if (this.tabbedMDI != null) {
            this.tabbedMDI.setMaximizeVisible(dataSourcesCore != null && dataSourcesCore.length == 1);
        }
        view.triggerEvent(1, dataSourcesCore.length == 0 ? tv.getParentDataSource() : dataSourcesCore);
    }

    public void delete() {
        SelectedContentManager.removeCurrentlySelectedContentListener(this);
        if (this.menuItemShowTabs != null) {
            this.menuItemShowTabs.remove();
        }
    }

    public void generate(IndentWriter writer) {
        writer.println("# of SubViews: " + (this.tabbedMDI == null ? "null" : Integer.valueOf(this.tabbedMDI.getEntriesCount())));
    }

    public void localeChanged() {
        if (this.tabbedMDI == null) {
            return;
        }
        MdiEntry[] entries = this.tabbedMDI.getEntries();
        if (entries == null || entries.length == 0) {
            return;
        }
        for (MdiEntry entry : entries) {
            if (!(entry instanceof MdiEntrySWT)) continue;
            ((MdiEntrySWT)entry).triggerEvent(6, null);
        }
    }

    public MdiEntrySWT getActiveSubView() {
        if (!this.tv.isTabViewsEnabled() || this.tabbedMDI == null || this.tabbedMDI.isDisposed() || this.tabbedMDI.getMinimized()) {
            return null;
        }
        return this.tabbedMDI.getCurrentEntrySWT();
    }

    private MdiEntry addTabView(UISWTInstance.UISWTViewEventListenerWrapper listener, String afterID) {
        MdiEntrySWT view = null;
        MdiEntrySWT entry = (MdiEntrySWT)this.tabbedMDI.createEntryFromEventListener(this.tv.getTableID(), listener, listener.getViewID(), true, null, afterID);
        if (!(entry instanceof UISWTViewCore)) {
            return entry;
        }
        view = entry;
        try {
            if (this.parentView != null) {
                view.setParentView(this.parentView);
            }
            this.triggerTabViewDataSourceChanged(entry, this.tv, null);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return entry;
    }

    private void removeTabView(String id) {
        boolean exists = this.tabbedMDI.entryExists(id);
        if (!exists) {
            return;
        }
        MdiEntry entry = this.tabbedMDI.getEntry(id);
        this.tabbedMDI.removeItem(entry);
    }

    public Composite createSashForm(Composite composite) {
        double pct;
        Composite cFixLayout;
        UISWTInstance pluginUI;
        if (!this.tv.isTabViewsEnabled()) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        SelectedContentManager.addCurrentlySelectedContentListener(this);
        ConfigurationManager configMan = ConfigurationManager.getInstance();
        int iNumViews = 0;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (pluginUI = uiFunctions.getUISWTInstance()) != null) {
            iNumViews += pluginUI.getViewListeners(this.tv.getTableID()).length;
        }
        if (iNumViews == 0) {
            this.tableComposite = this.tv.createMainPanel(composite);
            return this.tableComposite;
        }
        final String props_prefix = this.tv.getTableID() + "." + this.tv.getPropertiesPrefix();
        final Composite form = new Composite(composite, 0);
        FormLayout flayout = new FormLayout();
        flayout.marginHeight = 0;
        flayout.marginWidth = 0;
        form.setLayout((Layout)flayout);
        GridData gridData = new GridData(1808);
        form.setLayoutData((Object)gridData);
        this.cTabsHolder = new Composite(form, 0);
        this.tabbedMDI = uiFunctions.createTabbedMDI(this.cTabsHolder, props_prefix);
        this.tabbedMDI.setMaximizeVisible(true);
        this.tabbedMDI.setMinimizeVisible(true);
        this.tabbedMDI.setTabbedMdiMaximizeListener(new TabbedMdiMaximizeListener(){

            public void maximizePressed() {
                UIFunctions uiFunctions;
                TableView<Object> tvToUse = TableViewSWT_TabsCommon.this.tvOverride == null ? TableViewSWT_TabsCommon.this.tv : TableViewSWT_TabsCommon.this.tvOverride;
                Object[] ds = tvToUse.getSelectedDataSources(true);
                if (ds.length == 1 && ds[0] instanceof DownloadManager && (uiFunctions = UIFunctionsManager.getUIFunctions()) != null) {
                    uiFunctions.getMDI().showEntryByID("DMDetails", ds);
                }
            }
        });
        int SASH_WIDTH = 5;
        this.sash = Utils.createSash(form, 5);
        for (cFixLayout = this.tableComposite = this.tv.createMainPanel(form); cFixLayout != null && cFixLayout.getParent() != form; cFixLayout = cFixLayout.getParent()) {
        }
        if (cFixLayout == null) {
            cFixLayout = this.tableComposite;
        }
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cFixLayout.setLayout((Layout)layout);
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        int iSplitAt = configMan.getIntParameter(props_prefix + ".SplitAt", 3000);
        if (iSplitAt < 100) {
            iSplitAt *= 100;
        }
        if ((pct = (double)iSplitAt / 10000.0) < 0.03) {
            pct = 0.03;
        } else if (pct > 0.97) {
            pct = 0.97;
        }
        this.sash.setData("PCT", (Object)new Double(pct));
        this.cTabsHolder.setLayout((Layout)new FormLayout());
        this.fdHeightChanger = formData;
        this.cTabsHolder.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment((Control)this.cTabsHolder);
        formData.height = 5;
        this.sash.setLayoutData((Object)formData);
        formData = new FormData();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment((Control)this.sash);
        cFixLayout.setLayoutData((Object)formData);
        this.sash.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean FASTDRAG = true;
                if (e.detail == 1) {
                    return;
                }
                Rectangle area = form.getClientArea();
                int height = area.height - e.y - e.height;
                if (!Constants.isWindows) {
                    height -= 5;
                }
                if (area.height - height < 100) {
                    height = area.height - 100;
                }
                if (height < 0) {
                    height = 0;
                }
                ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = height;
                Double l = new Double((double)height / (double)area.height);
                TableViewSWT_TabsCommon.this.sash.setData("PCT", (Object)l);
                if (e.detail != 1) {
                    ConfigurationManager configMan = ConfigurationManager.getInstance();
                    configMan.setParameter(props_prefix + ".SplitAt", (int)(l * 10000.0));
                }
                form.layout();
                TableViewSWT_TabsCommon.this.cTabsHolder.redraw();
            }
        });
        this.buildFolder(form, props_prefix);
        return form;
    }

    private void buildFolder(final Composite form, String props_prefix) {
        MdiEntry[] entries;
        UISWTInstance.UISWTViewEventListenerWrapper[] pluginViews;
        UISWTInstance pluginUI;
        UIFunctionsSWT uiFunctions;
        PluginInterface pi = PluginInitializer.getDefaultInterface();
        UIManager uim = pi.getUIManager();
        MenuManager menuManager = uim.getMenuManager();
        this.menuItemShowTabs = menuManager.addMenuItem(props_prefix + "._end_", "ConfigView.section.style.ShowTabsInTorrentView");
        this.menuItemShowTabs.setStyle(2);
        this.menuItemShowTabs.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter("Library.ShowTabsInTorrentView"));
            }
        });
        this.menuItemShowTabs.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter("Library.ShowTabsInTorrentView", (Boolean)menu.getData());
            }
        });
        this.cTabsHolder.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                if (TableViewSWT_TabsCommon.this.tabbedMDI.getMinimized()) {
                    ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = TableViewSWT_TabsCommon.this.tabbedMDI.getFolderHeight();
                    TableViewSWT_TabsCommon.this.cTabsHolder.getParent().layout();
                    return;
                }
                Double l = (Double)TableViewSWT_TabsCommon.this.sash.getData("PCT");
                if (l != null) {
                    ((TableViewSWT_TabsCommon)TableViewSWT_TabsCommon.this).fdHeightChanger.height = (int)((double)form.getBounds().height * l);
                    TableViewSWT_TabsCommon.this.cTabsHolder.getParent().layout();
                }
            }
        });
        String[] restricted_to = this.tv.getTabViewsRestrictedTo();
        HashSet<String> rt_set = new HashSet<String>();
        if (restricted_to != null) {
            rt_set.addAll(Arrays.asList(restricted_to));
        }
        if ((uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && (pluginUI = uiFunctions.getUISWTInstance()) != null && (pluginViews = pluginUI.getViewListeners(this.tv.getTableID())) != null) {
            for (final UISWTInstance.UISWTViewEventListenerWrapper l : pluginViews) {
                if (l == null) continue;
                try {
                    String view_id = l.getViewID();
                    if (restricted_to != null && !rt_set.contains(view_id)) continue;
                    this.tabbedMDI.registerEntry(view_id, new MdiEntryCreationListener2(){

                        @Override
                        public MdiEntry createMDiEntry(MultipleDocumentInterface mdi, String id, Object datasource, Map<?, ?> params) {
                            return TableViewSWT_TabsCommon.this.addTabView(l, null);
                        }
                    });
                    this.tabbedMDI.loadEntryByID(view_id, false);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (!this.tabbedMDI.getMinimized() && (entries = this.tabbedMDI.getEntries()).length > 0) {
            this.tabbedMDI.showEntry(entries[0]);
        }
    }

    public void swt_refresh() {
        MdiEntry entry;
        if (this.tv.isTabViewsEnabled() && this.tabbedMDI != null && !this.tabbedMDI.isDisposed() && !this.tabbedMDI.getMinimized() && (entry = this.tabbedMDI.getCurrentEntry()) != null) {
            entry.updateUI();
        }
    }

    @Override
    public void currentlySelectedContentChanged(ISelectedContent[] currentContent, String viewID) {
        TableView<?> tvToUse;
        TableView<?> tableView = tvToUse = this.tvOverride == null ? this.tv : this.tvOverride;
        if (viewID != null && viewID.equals(tvToUse.getTableID())) {
            this.selectedContent = currentContent;
        }
        if (currentContent.length == 0 && this.tv.isVisible() && this.selectedContent != null && this.selectedContent.length != 0) {
            SelectedContentManager.changeCurrentlySelectedContent(tvToUse.getTableID(), this.selectedContent, tvToUse);
        }
    }

    public void obfusticatedImage(Image image) {
        if (this.tabbedMDI instanceof ObfusticateImage) {
            ObfusticateImage o = (ObfusticateImage)((Object)this.tabbedMDI);
            image = o.obfusticatedImage(image);
        }
    }
}

