/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public abstract class ColumnDateSizer
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellToolTipListener {
    private static int PADDING = 10;
    int curFormat = 0;
    int[] maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
    Date[] maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
    private boolean showTime = true;
    private boolean multiline = true;
    private String tableFormatOverride = "";
    private static Font fontBold;
    private ViewUtils.CustomDateFormat cdf;

    public ColumnDateSizer(Class forDataSourceType, String columnID, int width, String tableID) {
        super(forDataSourceType, columnID, 2, width, tableID);
        final TableContextMenuItem menuShowTime = this.addContextMenuItem("TableColumn.menu.date_added.time", 1);
        menuShowTime.setStyle(2);
        menuShowTime.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(ColumnDateSizer.this.showTime);
            }
        });
        menuShowTime.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                ColumnDateSizer.this.showTime = !ColumnDateSizer.this.showTime;
                ColumnDateSizer.this.setUserData("showTime", new Long(ColumnDateSizer.this.showTime ? 1L : 0L));
                ColumnDateSizer.this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
                ColumnDateSizer.this.curFormat = -1;
                ColumnDateSizer.this.recalcWidth(new Date(), null);
                if (ColumnDateSizer.this.curFormat < 0) {
                    ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("Table.column.dateformat", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                ColumnDateSizer.this.tableFormatOverride = COConfigurationManager.getStringParameter("Table.column.dateformat", "");
                if (ColumnDateSizer.this.tableFormatOverride == null) {
                    ColumnDateSizer.this.tableFormatOverride = "";
                }
                ColumnDateSizer.this.curFormat = -1;
                if (ColumnDateSizer.this.tableFormatOverride.length() == 0) {
                    ColumnDateSizer.this.recalcWidth(new Date(), null);
                    if (ColumnDateSizer.this.curFormat < 0) {
                        ColumnDateSizer.this.curFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
                    }
                    menuShowTime.setVisible(true);
                } else {
                    ColumnDateSizer.this.invalidateCells();
                    menuShowTime.setVisible(false);
                }
            }
        });
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    public void postConfigLoad() {
        int userMode;
        Number nShowTime;
        boolean oldShowTime = this.showTime;
        Object oShowTime = this.getUserData("showTime");
        this.showTime = oShowTime instanceof Number ? (nShowTime = (Number)oShowTime).byteValue() == 1 : (userMode = COConfigurationManager.getIntParameter("User Mode")) > 1;
        this.cdf.update();
        if (oldShowTime != this.showTime) {
            this.recalcWidth(new Date(), null);
        }
        super.postConfigLoad();
    }

    public final void refresh(TableCell cell) {
        this.refresh(cell, 0L);
    }

    public void refresh(TableCell cell, long timestamp) {
        this.refresh(cell, timestamp, null);
    }

    public void refresh(final TableCell cell, final long timestamp, final String prefix) {
        Date date;
        if (!cell.setSortValue(timestamp) && cell.isValid()) {
            return;
        }
        if (timestamp <= 0L) {
            cell.setText("");
            return;
        }
        SimpleDateFormat format = this.cdf.getDateFormat();
        if (format != null) {
            date = new Date(timestamp);
            try {
                String date_str = format.format(date);
                if (prefix != null) {
                    date_str = prefix + date_str;
                }
                cell.setText(date_str);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.tableFormatOverride.length() > 0) {
            date = new Date(timestamp);
            try {
                SimpleDateFormat temp = new SimpleDateFormat(this.tableFormatOverride);
                String date_str = temp.format(date);
                if (prefix != null) {
                    date_str = prefix + date_str;
                }
                cell.setText(date_str);
                return;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Date date = new Date(timestamp);
                if (ColumnDateSizer.this.curFormat >= 0) {
                    if (ColumnDateSizer.this.multiline && cell.getHeight() < 20) {
                        ColumnDateSizer.this.multiline = false;
                    }
                    String suffix = ColumnDateSizer.this.showTime && !ColumnDateSizer.this.multiline ? " hh:mm a" : "";
                    int newWidth = ColumnDateSizer.this.calcWidth(date, TimeFormatter.DATEFORMATS_DESC[ColumnDateSizer.this.curFormat] + suffix, prefix);
                    if (newWidth > cell.getWidth() - PADDING) {
                        if (newWidth > ColumnDateSizer.this.maxWidthUsed[ColumnDateSizer.this.curFormat]) {
                            ColumnDateSizer.this.maxWidthUsed[ColumnDateSizer.this.curFormat] = newWidth;
                            ColumnDateSizer.this.maxWidthDate[ColumnDateSizer.this.curFormat] = date;
                        }
                        ColumnDateSizer.this.recalcWidth(date, prefix);
                    }
                    String s = TimeFormatter.DATEFORMATS_DESC[ColumnDateSizer.this.curFormat] + suffix;
                    SimpleDateFormat temp = new SimpleDateFormat(s + (ColumnDateSizer.this.showTime && ColumnDateSizer.this.multiline ? "\nh:mm a" : ""));
                    String date_str = temp.format(date);
                    if (prefix != null) {
                        date_str = prefix + date_str;
                    }
                    cell.setText(date_str);
                }
            }
        });
    }

    public void setWidthPX(int width) {
        int oldWidth = this.getWidth();
        super.setWidthPX(width);
        if (oldWidth == width) {
            return;
        }
        if (this.maxWidthDate != null && this.curFormat >= 0) {
            if (this.maxWidthDate[this.curFormat] == null) {
                this.maxWidthDate[this.curFormat] = new Date();
            }
            this.recalcWidth(this.maxWidthDate[this.curFormat], null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recalcWidth(Date date, String prefix) {
        int i;
        String suffix = this.showTime && !this.multiline ? " hh:mm a" : "";
        int width = this.getWidth();
        if (this.maxWidthDate == null) {
            this.maxWidthUsed = new int[TimeFormatter.DATEFORMATS_DESC.length];
            this.maxWidthDate = new Date[TimeFormatter.DATEFORMATS_DESC.length];
        }
        int idxFormat = TimeFormatter.DATEFORMATS_DESC.length - 1;
        GC gc = new GC((Drawable)Display.getDefault());
        if (fontBold == null) {
            FontData[] fontData = gc.getFont().getFontData();
            for (i = 0; i < fontData.length; ++i) {
                FontData fd = fontData[i];
                fd.setStyle(1);
            }
            fontBold = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontBold);
        try {
            try {
                Point minSize = new Point(99999, 0);
                for (i = 0; i < TimeFormatter.DATEFORMATS_DESC.length; ++i) {
                    if (this.maxWidthUsed[i] > width - PADDING) continue;
                    SimpleDateFormat temp = new SimpleDateFormat(TimeFormatter.DATEFORMATS_DESC[i] + suffix);
                    Point newSize = gc.stringExtent(temp.format(date));
                    if (newSize.x < width - PADDING) {
                        idxFormat = i;
                        if (this.maxWidthUsed[i] >= newSize.x) break;
                        this.maxWidthUsed[i] = newSize.x;
                        this.maxWidthDate[i] = date;
                        break;
                    }
                    if (newSize.x >= minSize.x) continue;
                    minSize = newSize;
                    idxFormat = i;
                }
                Object var12_12 = null;
            }
            catch (Throwable t) {
                Object var12_13 = null;
                gc.dispose();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        if (this.curFormat != idxFormat) {
            this.curFormat = idxFormat;
            this.invalidateCells();
        }
    }

    private int calcWidth(Date date, String format, String prefix) {
        GC gc = new GC((Drawable)Display.getDefault());
        if (fontBold == null) {
            FontData[] fontData = gc.getFont().getFontData();
            for (int i = 0; i < fontData.length; ++i) {
                FontData fd = fontData[i];
                fd.setStyle(1);
            }
            fontBold = new Font(gc.getDevice(), fontData);
        }
        gc.setFont(fontBold);
        SimpleDateFormat temp = new SimpleDateFormat(format);
        String date_str = temp.format(date);
        if (prefix != null) {
            date_str = prefix + date_str;
        }
        Point newSize = gc.stringExtent(date_str);
        gc.dispose();
        return newSize.x;
    }

    public boolean getShowTime() {
        return this.showTime;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public void setMultiline(boolean multiline) {
        this.multiline = multiline;
    }

    public void cellHover(TableCell cell) {
        long eta;
        long timestamp;
        Comparable ds = cell.getSortValue();
        if (ds instanceof Number && (timestamp = ((Number)((Object)ds)).longValue()) > 0L && (eta = (SystemTime.getCurrentTime() - timestamp) / 1000L) > 0L) {
            cell.setToolTip(DisplayFormatters.formatETA(eta, false));
        }
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

