/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FileETAItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private ViewUtils.CustomDateFormat cdf;

    public FileETAItem() {
        super("file_eta", 2, -1, 60, "Files");
        this.setRefreshInterval(-2);
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"progress"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        long eta = -1L;
        if (fileInfo2 != null) {
            eta = fileInfo2.getETA();
        }
        if (!cell.setSortValue(eta) && cell.isValid()) {
            return;
        }
        cell.setText(ViewUtils.formatETA(eta, MyTorrentsView.eta_absolute, this.cdf.getDateFormat()));
    }

    public void postConfigLoad() {
        super.postConfigLoad();
        this.cdf.update();
    }
}

