/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import java.io.File;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class RelocatedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public RelocatedItem() {
        super("relocated", 3, -1, 70, "Files");
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        boolean relocated;
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        if (fileInfo2 == null) {
            relocated = false;
        } else {
            File source = fileInfo2.getFile(false);
            File target = fileInfo2.getDownloadManager().getDownloadState().getFileLink(fileInfo2.getIndex(), source);
            relocated = target == null ? false : (target == source ? false : !target.equals(source));
        }
        if (!cell.setSortValue(relocated ? 1L : 0L) && cell.isValid()) {
            return;
        }
        String text = relocated ? "*" : "";
        cell.setText(text);
    }
}

