/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class CommentIconItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
TableCellAddedListener,
TableCellToolTipListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    static final UISWTGraphic graphicComment = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("comment"));
    static final UISWTGraphic noGraphicComment = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("no_comment"));
    public static final String COLUMN_ID = "commenticon";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public CommentIconItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, -2, 20, sTableID);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-2, 20);
        this.setMinWidth(20);
        this.setIconReference("comment", true);
    }

    public void cellAdded(TableCell cell) {
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        TorrentUtil.promptUserForComment(new DownloadManager[]{dm});
        this.refresh(event2.cell);
    }

    public void refresh(TableCell cell) {
        if (cell.isDisposed()) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String comment = null;
        if (dm != null && (comment = dm.getDownloadState().getUserComment()) != null && comment.length() == 0) {
            comment = null;
        }
        Graphic oldGraphic = cell.getGraphic();
        if (comment == null && oldGraphic != noGraphicComment) {
            cell.setGraphic(noGraphicComment);
            cell.setSortValue(null);
        } else if (comment != null && oldGraphic != graphicComment) {
            cell.setGraphic(graphicComment);
            cell.setSortValue((Comparable)((Object)comment));
        }
    }

    public void cellHover(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String comment = null;
        if (dm != null && (comment = dm.getDownloadState().getUserComment()) != null && comment.length() == 0) {
            comment = null;
        }
        cell.setToolTip(comment);
    }

    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

