/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.util.PlatformTorrentUtils;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;

public class DescriptionItem
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellMouseListener,
TableCellAddedListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "description";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public DescriptionItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 150, sTableID);
        this.setRefreshInterval(-2);
    }

    public void cellAdded(TableCell cell) {
        if (cell instanceof TableCellSWT) {
            ((TableCellSWT)cell).setCursorID(21);
        }
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        if (event2.eventType != 1) {
            return;
        }
        if (event2.button != 1) {
            return;
        }
        event2.skipCoreFunctionality = true;
        TorrentUtil.promptUserForDescription(new DownloadManager[]{dm});
        this.refresh(event2.cell);
    }

    public void refresh(TableCell cell) {
        if (cell.isDisposed()) {
            return;
        }
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        String desc = "";
        if (dm != null) {
            try {
                desc = PlatformTorrentUtils.getContentDescription(dm.getTorrent());
                if (desc == null) {
                    desc = "";
                }
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        cell.setText(desc);
    }
}

