/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class FilesLinkedItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class<Download> DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "fileslinked";

    public FilesLinkedItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 50, sTableID);
        this.setMinWidthAuto(true);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        int link_count = 0;
        if (dm != null) {
            link_count = dm.getDownloadState().getFileLinks().size();
        }
        if (!cell.setSortValue(link_count) && cell.isValid()) {
            return;
        }
        cell.setText(link_count == 0 ? "" : String.valueOf(link_count));
    }
}

