/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class IPFilterItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static IpFilter ipfilter = null;
    public static final Class DATASOURCE_TYPE = Download.class;
    private static UISWTGraphic tick_icon;
    private static UISWTGraphic cross_icon;
    public static final String COLUMN_ID = "ipfilter";

    public IPFilterItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 100, sTableID);
        this.setRefreshInterval(-2);
        this.initializeAsGraphic(-1, 100);
        this.setMinWidth(20);
    }

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
        info.setProficiency((byte)1);
    }

    public void refresh(TableCell cell) {
        UISWTGraphic icon = null;
        int sort = 0;
        if (ipfilter == null) {
            ipfilter = IpFilterManagerFactory.getSingleton().getIPFilter();
        }
        if (ipfilter.isEnabled()) {
            DownloadManager dm;
            if (tick_icon == null) {
                tick_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("tick_mark"));
                cross_icon = new UISWTGraphicImpl(ImageLoader.getInstance().getImage("cross_mark"));
            }
            if ((dm = (DownloadManager)cell.getDataSource()) != null) {
                boolean excluded = dm.getDownloadState().getFlag(256L);
                if (excluded) {
                    icon = cross_icon;
                    sort = 1;
                } else {
                    icon = tick_icon;
                    sort = 2;
                }
            }
        }
        cell.setSortValue(sort);
        if (cell.getGraphic() != icon) {
            cell.setGraphic(icon);
        }
    }
}

