/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.plugins.tracker.dht.DHTTrackerPlugin;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Locale;
import org.eclipse.swt.graphics.Image;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.table.TableCellSWT;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class PeersItem
extends CoreTableColumnSWT
implements TableCellAddedListener,
ParameterListener {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "peers";
    private static final String CFG_SHOW_ICON = "PeersColumn.showNetworkIcon";
    private static String textStarted;
    private static String textStartedOver;
    private static String textNotStarted;
    private static String textStartedNoScrape;
    private static String textNotStartedNoScrape;
    private static Image i2p_img;
    private static Image none_img;
    private boolean showIcon;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"swarm"});
    }

    public PeersItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 3, 60, sTableID);
        this.setRefreshInterval(-2);
        this.setMinWidthAuto(true);
        this.showIcon = COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON);
        COConfigurationManager.addParameterListener(CFG_SHOW_ICON, (ParameterListener)this);
        TableContextMenuItem menuShowIcon = this.addContextMenuItem("ConfigView.section.style.showNetworksIcon", 1);
        menuShowIcon.setStyle(2);
        menuShowIcon.addFillListener(new MenuItemFillListener(){

            public void menuWillBeShown(MenuItem menu, Object data) {
                menu.setData(new Boolean(PeersItem.this.showIcon));
            }
        });
        menuShowIcon.addMultiListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                COConfigurationManager.setParameter(PeersItem.CFG_SHOW_ICON, (Boolean)menu.getData());
            }
        });
    }

    public void reset() {
        super.reset();
        COConfigurationManager.removeParameter(CFG_SHOW_ICON);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        COConfigurationManager.removeParameterListener(CFG_SHOW_ICON, this);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    public void parameterChanged(String parameterName) {
        this.setShowIcon(COConfigurationManager.getBooleanParameter(CFG_SHOW_ICON));
    }

    public void setShowIcon(boolean b) {
        this.showIcon = b;
        this.invalidateCells();
    }

    static {
        MessageText.addAndFireListener(new MessageText.MessageTextListener(){

            public void localeChanged(Locale old_locale, Locale new_locale) {
                textStarted = MessageText.getString("Column.seedspeers.started");
                textStartedOver = MessageText.getString("Column.seedspeers.started.over");
                textNotStarted = MessageText.getString("Column.seedspeers.notstarted");
                textStartedNoScrape = MessageText.getString("Column.seedspeers.started.noscrape");
                textNotStartedNoScrape = MessageText.getString("Column.seedspeers.notstarted.noscrape");
            }
        });
        ImageLoader imageLoader = ImageLoader.getInstance();
        i2p_img = imageLoader.getImage("net_I2P_x");
        none_img = imageLoader.getImage("net_None_x");
    }

    private class Cell
    extends AbstractTrackerCell
    implements TableCellMouseListener {
        long lTotalPeers;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = -1L;
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalPeers = response.getPeers();
            }
        }

        public void refresh(TableCell cell) {
            String text;
            long totalPeers;
            super.refresh(cell);
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            long lConnectedPeers = 0L;
            if (dm != null) {
                TRTrackerScraperResponse response;
                lConnectedPeers = dm.getNbPeers();
                if (this.lTotalPeers == -1L && (response = dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalPeers = response.getPeers();
                }
                if (cell instanceof TableCellSWT) {
                    int totalI2PLeechers;
                    int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
                    Image icon = none_img;
                    if (PeersItem.this.showIcon && i2p_info != null && (totalI2PLeechers = i2p_info[1]) > 0) {
                        icon = i2p_img;
                    }
                    ((TableCellSWT)cell).setIcon(icon);
                }
            }
            if ((totalPeers = this.lTotalPeers) <= 0L && dm != null) {
                totalPeers = dm.getActivationCount();
            }
            long value = lConnectedPeers * 10000000L;
            if (totalPeers > 0L) {
                value += totalPeers;
            }
            if (dm != null) {
                boolean hasScrape;
                int state = dm.getState();
                boolean started = state == 60 || state == 50;
                boolean bl = hasScrape = this.lTotalPeers >= 0L;
                if (started) {
                    text = hasScrape ? (lConnectedPeers > this.lTotalPeers ? textStartedOver : textStarted) : textStartedNoScrape;
                } else {
                    String string = text = hasScrape ? textNotStarted : textNotStartedNoScrape;
                }
                if (text.length() == 0 && text.length() == 0) {
                    value = Integer.MIN_VALUE;
                    long cache = dm.getDownloadState().getLongAttribute("scrapecache");
                    if (cache != -1L) {
                        int leechers = (int)(cache & 0xFFFFFFL);
                        value += (long)(leechers + 1);
                    }
                }
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
                text = text.replaceAll("%1", String.valueOf(lConnectedPeers));
                text = text.replaceAll("%2", String.valueOf(totalPeers));
            } else {
                text = "";
                value = Integer.MIN_VALUE;
                if (!cell.setSortValue(value) && cell.isValid()) {
                    return;
                }
            }
            cell.setText(text);
        }

        public void cellHover(TableCell cell) {
            super.cellHover(cell);
            long lConnectedPeers = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                int totalI2PPeers;
                int[] i2p_info;
                int leechers;
                long cache;
                lConnectedPeers = dm.getNbPeers();
                String sToolTip = lConnectedPeers + " " + MessageText.getString("GeneralView.label.connected") + "\n";
                if (this.lTotalPeers != -1L) {
                    sToolTip = sToolTip + this.lTotalPeers + " " + MessageText.getString("GeneralView.label.in_swarm");
                } else {
                    TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                    sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                    if (response != null) {
                        sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                    }
                }
                int activationCount = dm.getActivationCount();
                if (activationCount > 0) {
                    sToolTip = sToolTip + "\n" + MessageText.getString("PeerColumn.activationCount", new String[]{"" + activationCount});
                }
                if ((cache = dm.getDownloadState().getLongAttribute("scrapecache")) != -1L && (long)(leechers = (int)(cache & 0xFFFFFFL)) != this.lTotalPeers) {
                    sToolTip = sToolTip + "\n" + leechers + " " + MessageText.getString("Scrape.status.cached").toLowerCase(Locale.US);
                }
                if ((i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY)) != null && (totalI2PPeers = i2p_info[1]) > 0) {
                    sToolTip = sToolTip + "\n" + MessageText.getString("TableColumn.header.peers.i2p", new String[]{String.valueOf(totalI2PPeers)});
                }
                cell.setToolTip(sToolTip);
            } else {
                cell.setToolTip("");
            }
        }

        public void cellMouseTrigger(TableCellMouseEvent event2) {
            DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
            if (dm == null) {
                return;
            }
            if (event2.eventType != 2) {
                return;
            }
            event2.skipCoreFunctionality = true;
            int[] i2p_info = (int[])dm.getUserData(DHTTrackerPlugin.DOWNLOAD_USER_DATA_I2P_SCRAPE_KEY);
            if (i2p_info != null && i2p_info[1] > 0) {
                Utils.launch(MessageText.getString("privacy.view.wiki.url"));
            }
        }
    }
}

