/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnCreator;
import org.gudy.azureus2.ui.swt.views.tableitems.ColumnDateSizer;

public class ShareRatioProgressItem
extends ColumnDateSizer {
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "sr_prog";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time", "sharing", "swarm"});
        info.setProficiency((byte)1);
    }

    public ShareRatioProgressItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setRefreshInterval(-2);
        this.setMultiline(false);
        TableContextMenuItem menuSetInterval = this.addContextMenuItem("TableColumn.menu.sr_prog.interval", 1);
        menuSetInterval.setStyle(1);
        menuSetInterval.addListener(new MenuItemListener(){

            public void selected(MenuItem menu, Object target) {
                SimpleTextEntryWindow entryWindow = new SimpleTextEntryWindow("sr_prog.window.title", "sr_prog.window.message");
                int existing_sr = COConfigurationManager.getIntParameter("Share Ratio Progress Interval");
                String sr_str = DisplayFormatters.formatDecimal((double)existing_sr / 1000.0, 3);
                entryWindow.setPreenteredText(sr_str, false);
                entryWindow.selectPreenteredText(true);
                entryWindow.setWidthHint(400);
                entryWindow.prompt();
                if (entryWindow.hasSubmittedInput()) {
                    try {
                        String text = entryWindow.getSubmittedInput().trim();
                        if (text.length() > 0) {
                            float f = Float.parseFloat(text);
                            int sr = (int)(f * 1000.0f);
                            COConfigurationManager.setParameter("Share Ratio Progress Interval", sr);
                        }
                    }
                    catch (Throwable e) {
                        // empty catch block
                    }
                }
            }
        });
    }

    public ShareRatioProgressItem(String tableID, boolean v) {
        this(tableID);
        this.setVisible(v);
    }

    public void refresh(TableCell cell, long timestamp) {
        long data;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        long l = data = dm == null ? 0L : dm.getDownloadState().getLongAttribute("sr.prog");
        if (data == 0L) {
            super.refresh(cell, data);
        } else {
            long sr = (int)data;
            String sr_str = DisplayFormatters.formatDecimal((double)sr / 1000.0, 3);
            timestamp = (data >>> 32) * 1000L;
            String prefix = sr_str + ": ";
            super.refresh(cell, timestamp += sr & 0xFFL, prefix);
        }
    }
}

