/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.DownloadTypeIncomplete;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.MyTorrentsView;
import org.gudy.azureus2.ui.swt.views.ViewUtils;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class SmoothedETAItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final Class DATASOURCE_TYPE = DownloadTypeIncomplete.class;
    public static final String COLUMN_ID = "smootheta";
    private ViewUtils.CustomDateFormat cdf;

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)1);
    }

    public SmoothedETAItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 2, 60, sTableID);
        this.setRefreshInterval(-2);
        this.addDataSourceType(DiskManagerFileInfo.class);
        this.cdf = ViewUtils.addCustomDateFormat(this);
    }

    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds instanceof DiskManagerFileInfo) {
            DiskManagerFileInfo file = (DiskManagerFileInfo)cell.getDataSource();
            long value = file.getETA();
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            cell.setText(ViewUtils.formatETA(value, MyTorrentsView.eta_absolute, this.cdf.getDateFormat()));
        } else {
            long value;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            long l = value = dm == null ? 0L : dm.getStats().getSmoothedETA();
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            cell.setText(ViewUtils.formatETA(value, MyTorrentsView.eta_absolute, this.cdf.getDateFormat()));
        }
    }

    public void postConfigLoad() {
        super.postConfigLoad();
        this.cdf.update();
    }
}

