/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import java.util.List;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;
import org.gudy.azureus2.ui.swt.views.utils.TagUIUtils;

public class TagsItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    private static TagManager tag_manager = TagManagerFactory.getTagManager();
    public static final Class DATASOURCE_TYPE = Download.class;
    public static final String COLUMN_ID = "tags";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public TagsItem(String sTableID) {
        super(DATASOURCE_TYPE, COLUMN_ID, 1, 70, sTableID);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        List<Tag> tags;
        String sTags = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (tags = tag_manager.getTagsForTaggable(3, dm)).size() > 0) {
            tags = TagUIUtils.sortTags(tags);
            for (Tag t : tags) {
                String str = t.getTagName(true);
                if (sTags == null) {
                    sTags = str;
                    continue;
                }
                sTags = sTags + ", " + str;
            }
        }
        cell.setText(sTags == null ? "" : sTags);
    }
}

