/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.impl.PEPeerTransport;
import org.gudy.azureus2.core3.util.TimeFormatter;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class LatencyItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "latency";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
    }

    public LatencyItem(String table_id) {
        super(COLUMN_ID, 2, -1, 70, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long value;
        PEPeerTransport peer = (PEPeerTransport)cell.getDataSource();
        long l = value = peer == null ? 0L : peer.getLatency();
        if (!cell.setSortValue(value) && cell.isValid()) {
            return;
        }
        cell.setText(value == 0L ? "" : TimeFormatter.format100ths(value));
    }
}

