/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.peers;

import org.gudy.azureus2.core3.peer.PEPeer;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumnInfo;
import org.gudy.azureus2.ui.swt.views.table.CoreTableColumnSWT;

public class ProtocolItem
extends CoreTableColumnSWT
implements TableCellRefreshListener {
    public static final String COLUMN_ID = "Protocol";

    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"connection"});
    }

    public ProtocolItem(String table_id) {
        super(COLUMN_ID, 3, -1, 50, table_id);
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        String value;
        PEPeer peer = (PEPeer)cell.getDataSource();
        if (peer == null) {
            value = "";
        } else {
            value = peer.getProtocol();
            String qualifier = peer.getProtocolQualifier();
            if (qualifier != null) {
                value = value + " (" + qualifier + ")";
            }
        }
        if (!cell.setSortValue((Comparable)((Object)value)) && cell.isValid()) {
            return;
        }
        cell.setText(value);
    }
}

