/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.utils;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.Tag;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.core.util.AZ3Functions;
import com.aelitis.azureus.core.util.HTTPUtils;
import com.aelitis.azureus.core.util.LaunchManager;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfoSet;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStateFactory;
import org.gudy.azureus2.core3.download.impl.DownloadManagerAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrent.impl.TorrentOpenOptions;
import org.gudy.azureus2.core3.tracker.host.TRHostException;
import org.gudy.azureus2.core3.util.AENetworkClassifier;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.ConcurrentHasher;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.TimerEventPeriodic;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.core3.xml.util.XUXmlWriter;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.disk.DiskManagerChannel;
import org.gudy.azureus2.plugins.disk.DiskManagerEvent;
import org.gudy.azureus2.plugins.disk.DiskManagerListener;
import org.gudy.azureus2.plugins.disk.DiskManagerRequest;
import org.gudy.azureus2.plugins.download.Download;
import org.gudy.azureus2.plugins.download.DownloadStub;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.plugins.sharing.ShareResourceDir;
import org.gudy.azureus2.plugins.sharing.ShareResourceFile;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageRequest;
import org.gudy.azureus2.plugins.tracker.web.TrackerWebPageResponse;
import org.gudy.azureus2.plugins.utils.PooledByteBuffer;
import org.gudy.azureus2.pluginsimpl.local.PluginCoreUtils;
import org.gudy.azureus2.pluginsimpl.local.PluginInitializer;
import org.gudy.azureus2.pluginsimpl.local.utils.FormattersImpl;
import org.gudy.azureus2.ui.swt.TextViewerWindow;
import org.gudy.azureus2.ui.swt.TorrentUtil;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.CoreWaiterSWT;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.webplugin.WebPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagerUtils {
    private static RunDownloadManager run;
    private static Map<DownloadManager, WebPlugin> browse_plugins;
    private static AsyncDispatcher async;

    public static void setRunRunnable(RunDownloadManager run) {
        ManagerUtils.run = run;
    }

    public static void run(final DownloadManager dm) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    AZ3Functions.provider prov = AZ3Functions.getProvider();
                    if (prov != null) {
                        prov.setOpened(dm, true);
                    }
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            if (run != null) {
                                run.run(dm);
                            } else {
                                Utils.launch(dm.getSaveLocation().toString());
                            }
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(DownloadManager dm) {
        ManagerUtils.open(dm, false);
    }

    public static void open(final DownloadManager dm, final boolean open_containing_folder_mode) {
        if (dm != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(dm);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            ManagerUtils.open(dm.getSaveLocation(), open_containing_folder_mode);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(final DiskManagerFileInfo file, final boolean open_containing_folder_mode) {
        if (file != null) {
            LaunchManager launch_manager = LaunchManager.getManager();
            LaunchManager.LaunchTarget target = launch_manager.createTarget(file);
            launch_manager.launchRequest(target, new LaunchManager.LaunchAction(){

                public void actionAllowed() {
                    Utils.execSWTThread(new Runnable(){

                        public void run() {
                            File this_file = file.getFile(true);
                            File parent_file = open_containing_folder_mode ? this_file.getParentFile() : null;
                            ManagerUtils.open(parent_file == null ? this_file : parent_file);
                        }
                    });
                }

                public void actionDenied(Throwable reason) {
                    Debug.out("Launch request denied", reason);
                }
            });
        }
    }

    public static void open(File f, boolean open_containing_folder_mode) {
        if (open_containing_folder_mode) {
            Utils.launch(f.getParent());
        } else {
            ManagerUtils.open(f);
        }
    }

    public static void open(File f) {
        while (f != null && !f.exists()) {
            f = f.getParentFile();
        }
        if (f == null) {
            return;
        }
        PlatformManager mgr = PlatformManagerFactory.getPlatformManager();
        if (mgr.hasCapability(PlatformManagerCapabilities.ShowFileInBrowser)) {
            try {
                PlatformManagerFactory.getPlatformManager().showFile(f.toString());
                return;
            }
            catch (PlatformManagerException e) {
                Debug.printStackTrace(e);
            }
        }
        if (f.isDirectory()) {
            Utils.launch(f.toString());
        } else {
            Utils.launch(f.getParent().toString());
        }
    }

    private static boolean getBrowseAnon(DownloadManager dm) {
        boolean anon = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserAnon");
        if (!anon) {
            String[] nets;
            boolean found_pub = false;
            for (String net : nets = dm.getDownloadState().getNetworks()) {
                if (net != "Public") continue;
                found_pub = true;
                break;
            }
            if (nets.length > 0 && !found_pub) {
                anon = true;
            }
        }
        return anon;
    }

    private static DiskManagerFileInfo getBrowseHomePage(DownloadManager dm) {
        try {
            DiskManagerFileInfo[] files;
            for (DiskManagerFileInfo file : files = dm.getDiskManagerFileInfoSet().getFiles()) {
                String name;
                if (file.getTorrentFile().getPathComponents().length != 1 || !(name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US)).equals("index.html") && !name.equals("index.htm")) continue;
                return file;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return null;
    }

    public static boolean browseWebsite(DiskManagerFileInfo file) {
        try {
            String name = file.getTorrentFile().getRelativePath().toLowerCase(Locale.US);
            if (name.equals("index.html") || name.equals("index.htm")) {
                ManagerUtils.browse(file);
                return true;
            }
        }
        catch (Throwable e) {
            Debug.out(e);
        }
        return false;
    }

    public static boolean browseWebsite(DownloadManager dm) {
        DiskManagerFileInfo file = ManagerUtils.getBrowseHomePage(dm);
        if (file != null) {
            ManagerUtils.browse(file);
            return true;
        }
        return false;
    }

    public static String browse(DiskManagerFileInfo file) {
        boolean anon = ManagerUtils.getBrowseAnon(file.getDownloadManager());
        return ManagerUtils.browse(file, anon, true);
    }

    public static String browse(DiskManagerFileInfo file, boolean anon, boolean launch) {
        return ManagerUtils.browse(file.getDownloadManager(), file, anon, launch);
    }

    public static String browse(DownloadManager dm) {
        boolean anon = ManagerUtils.getBrowseAnon(dm);
        return ManagerUtils.browse(dm, null, anon, true);
    }

    public static String browse(DownloadManager dm, boolean anon, boolean launch) {
        return ManagerUtils.browse(dm, null, anon, launch);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String browse(final DownloadManager dm, DiskManagerFileInfo _file, final boolean anon, final boolean launch) {
        String url_suffix;
        DiskManagerFileInfo file;
        Properties props = new Properties();
        File save_location = dm.getSaveLocation();
        String root_dir = save_location.isFile() ? save_location.getParentFile().getAbsolutePath() : save_location.getAbsolutePath();
        boolean always_browse = COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList");
        if (!always_browse && _file == null) {
            _file = ManagerUtils.getBrowseHomePage(dm);
        }
        if ((file = _file) == null) {
            url_suffix = "";
        } else {
            String relative_path = file.getTorrentFile().getRelativePath();
            String[] bits = relative_path.replace(File.separatorChar, '/').split("/");
            String _url_suffix = "";
            int bits_to_use = always_browse ? bits.length - 1 : bits.length;
            for (int i = 0; i < bits_to_use; ++i) {
                String bit = bits[i];
                if (bit.length() == 0) continue;
                _url_suffix = _url_suffix + (_url_suffix == "" ? "" : "/") + UrlUtils.encode(bit);
            }
            url_suffix = _url_suffix;
        }
        Map<DownloadManager, WebPlugin> map = browse_plugins;
        synchronized (map) {
            WebPlugin plugin = browse_plugins.get(dm);
            if (plugin == null) {
                props.put("Port", (Object)0);
                props.put("Bind IP", "127.0.0.1");
                props.put("Home Page", "");
                props.put("Root Dir", root_dir);
                props.put("Access", "local");
                props.put("DefaultHideResourceConfig", (Object)true);
                props.put("DefaultEnableKeepAlive", (Object)true);
                props.put("EnablePairing", (Object)false);
                props.put("EnableUPNP", (Object)false);
                props.put("EnableI2P", (Object)false);
                props.put("EnableTor", (Object)false);
                String plugin_id = "webserver:" + dm.getInternalName();
                final String plugin_name = "Web Server for " + dm.getDisplayName();
                Properties messages = new Properties();
                messages.put("plugins." + plugin_id, plugin_name);
                PluginInitializer.getDefaultInterface().getUtilities().getLocaleUtilities().integrateLocalisedMessageBundle(messages);
                final AESemaphore waiter = new AESemaphore("waiter");
                final String[] url_holder = new String[]{null};
                plugin = new UnloadableWebPlugin(props){
                    private Map<String, Object> file_map;
                    private String protocol;
                    private String host;
                    private int port;
                    {
                        super(x0);
                        this.file_map = new HashMap<String, Object>();
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public void initialize(PluginInterface plugin_interface) throws PluginException {
                        DiskManagerFileInfoSet file_set = dm.getDiskManagerFileInfoSet();
                        DiskManagerFileInfo[] files = file_set.getFiles();
                        HashSet<Object> root_dir = new HashSet<Object>();
                        this.file_map.put("", root_dir);
                        for (DiskManagerFileInfo dm_file : files) {
                            TOTorrentFile file2 = dm_file.getTorrentFile();
                            String path = file2.getRelativePath();
                            this.file_map.put(path, dm_file);
                            if (path.startsWith(File.separator)) {
                                path = path.substring(1);
                            }
                            Set<Object> dir = root_dir;
                            int pos = 0;
                            while (true) {
                                int next_pos;
                                if ((next_pos = path.indexOf(File.separatorChar, pos)) == -1) break;
                                String bit = path.substring(pos, next_pos);
                                dir.add(bit);
                                String sub_path = path.substring(0, next_pos);
                                dir = (Set)this.file_map.get(sub_path);
                                if (dir == null) {
                                    dir = new HashSet();
                                    this.file_map.put(sub_path, dir);
                                }
                                pos = next_pos + 1;
                            }
                            dir.add(dm_file);
                        }
                        Properties props = plugin_interface.getPluginProperties();
                        props.put("plugin.name", plugin_name);
                        super.initialize(plugin_interface);
                        InetAddress bind_ip = this.getServerBindIP();
                        this.host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
                        this.port = this.getServerPort();
                        this.log("Assigned port: " + this.port);
                        this.protocol = this.getProtocol();
                        String url = this.protocol + "://" + this.host + ":" + this.port + "/" + url_suffix;
                        if (launch) {
                            Utils.launch(url, false, true, anon);
                            return;
                        }
                        String[] stringArray = url_holder;
                        synchronized (url_holder) {
                            url_holder[0] = url;
                            // ** MonitorExit[var8_10] (shouldn't be in output)
                            waiter.release();
                            return;
                        }
                    }

                    @Override
                    public boolean generate(TrackerWebPageRequest request2, TrackerWebPageResponse response) throws IOException {
                        try {
                            boolean res = super.generate(request2, response);
                            if (!res) {
                                response.setReplyStatus(404);
                            }
                        }
                        catch (Throwable e) {
                            response.setReplyStatus(404);
                        }
                        return true;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    @Override
                    protected boolean useFile(TrackerWebPageRequest request2, final TrackerWebPageResponse response, String root, String relative_url) throws IOException {
                        OutputStream os;
                        String file_type;
                        long file_size;
                        DiskManagerFileInfo dm_file;
                        block66: {
                            block67: {
                                int len;
                                URL stream_url2222;
                                String content_type;
                                String path;
                                URL absolute_url = request2.getAbsoluteURL();
                                String query = absolute_url.getQuery();
                                if (query != null) {
                                    String[] args = query.split("&");
                                    String vuze_source = null;
                                    int vuze_file_index = -1;
                                    String vuze_file_name = null;
                                    ArrayList<String> networks = new ArrayList<String>();
                                    for (String arg : args) {
                                        String net;
                                        String[] bits = arg.split("=");
                                        String lhs = bits[0];
                                        String rhs = UrlUtils.decode(bits[1]);
                                        if (lhs.equals("vuze_source")) {
                                            if (!rhs.endsWith(".torrent") && !rhs.startsWith("magnet")) continue;
                                            vuze_source = rhs;
                                            continue;
                                        }
                                        if (lhs.equals("vuze_file_index")) {
                                            vuze_file_index = Integer.parseInt(rhs);
                                            continue;
                                        }
                                        if (lhs.equals("vuze_file_name")) {
                                            vuze_file_name = rhs;
                                            continue;
                                        }
                                        if (!lhs.equals("vuze_network") || (net = AENetworkClassifier.internalise(rhs)) == null) continue;
                                        networks.add(net);
                                    }
                                    if (vuze_source != null) {
                                        String referrer = (String)request2.getHeaders().get("referer");
                                        if (referrer == null || !referrer.contains("://" + this.host + ":" + this.port)) {
                                            response.setReplyStatus(403);
                                            return true;
                                        }
                                        if (vuze_source.endsWith(".torrent")) {
                                            Object file_node = this.file_map.get(vuze_source);
                                            if (file_node instanceof DiskManagerFileInfo) {
                                                boolean done;
                                                DiskManagerFileInfo dm_file2 = (DiskManagerFileInfo)file_node;
                                                long file_size2 = dm_file2.getLength();
                                                File target_file = dm_file2.getFile(true);
                                                boolean bl = done = dm_file2.getDownloaded() == file_size2 && target_file.length() == file_size2;
                                                if (done) {
                                                    return this.handleRedirect(dm, target_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                                }
                                                try {
                                                    File torrent_file = AETemporaryFileHandler.createTempFile();
                                                    final FileOutputStream fos = new FileOutputStream(torrent_file);
                                                    try {
                                                        DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file2).createChannel();
                                                        try {
                                                            DiskManagerRequest req = chan.createRequest();
                                                            req.setOffset(0L);
                                                            req.setLength(file_size2);
                                                            req.addListener(new DiskManagerListener(){

                                                                public void eventOccurred(DiskManagerEvent event2) {
                                                                    int type = event2.getType();
                                                                    if (type == 3) {
                                                                        return;
                                                                    }
                                                                    if (type == 2) {
                                                                        throw new RuntimeException(event2.getFailure());
                                                                    }
                                                                    PooledByteBuffer buffer = event2.getBuffer();
                                                                    if (buffer == null) {
                                                                        throw new RuntimeException("eh?");
                                                                    }
                                                                    try {
                                                                        try {
                                                                            byte[] data = buffer.toByteArray();
                                                                            fos.write(data);
                                                                        }
                                                                        catch (IOException e) {
                                                                            throw new RuntimeException("Failed to write to " + file, e);
                                                                        }
                                                                        Object var6_6 = null;
                                                                        buffer.returnToPool();
                                                                    }
                                                                    catch (Throwable throwable) {
                                                                        Object var6_7 = null;
                                                                        buffer.returnToPool();
                                                                        throw throwable;
                                                                    }
                                                                }
                                                            });
                                                            req.run();
                                                            Object var24_53 = null;
                                                            chan.destroy();
                                                        }
                                                        catch (Throwable throwable) {
                                                            Object var24_54 = null;
                                                            chan.destroy();
                                                            throw throwable;
                                                        }
                                                        Object var26_64 = null;
                                                    }
                                                    catch (Throwable throwable) {
                                                        Object var26_65 = null;
                                                        fos.close();
                                                        throw throwable;
                                                    }
                                                    fos.close();
                                                    return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                    return false;
                                                }
                                            }
                                            return false;
                                        }
                                        URL magnet = new URL(vuze_source);
                                        File torrent_file = AETemporaryFileHandler.createTempFile();
                                        try {
                                            URLConnection connection = magnet.openConnection();
                                            connection.connect();
                                            FileUtil.copyFile(connection.getInputStream(), torrent_file.getAbsoluteFile());
                                            return this.handleRedirect(dm, torrent_file, vuze_file_index, vuze_file_name, networks, request2, response);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                                if ((path = absolute_url.getPath()).equals("/") && COConfigurationManager.getBooleanParameter("Library.LaunchWebsiteInBrowserDirList")) {
                                    relative_url = "/";
                                }
                                String download_name = XUXmlWriter.escapeXML(dm.getDisplayName());
                                String relative_file = relative_url.replace('/', File.separatorChar);
                                String node_key = relative_file.substring(1);
                                Object file_node = this.file_map.get(node_key);
                                boolean file_node_is_parent = false;
                                if (file_node == null) {
                                    int pos = node_key.lastIndexOf(File.separator);
                                    node_key = pos == -1 ? "" : node_key.substring(0, pos);
                                    file_node = this.file_map.get(node_key);
                                    file_node_is_parent = true;
                                }
                                if (file_node == null) {
                                    return false;
                                }
                                if (file_node instanceof Set) {
                                    String file_name;
                                    if (relative_url.equals("/favicon.ico")) {
                                        try {
                                            InputStream stream = this.getClass().getClassLoader().getResourceAsStream("org/gudy/azureus2/ui/icons/favicon.ico");
                                            response.useStream("image/x-icon", stream);
                                            return true;
                                        }
                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                    }
                                    Set kids = (Set)file_node;
                                    String request_url = request2.getURL();
                                    if (file_node_is_parent) {
                                        int pos = request_url.lastIndexOf("/");
                                        request_url = pos == -1 ? "" : request_url.substring(0, pos);
                                    }
                                    response.setContentType("text/html");
                                    OutputStream os2 = response.getOutputStream();
                                    String title = XUXmlWriter.escapeXML(UrlUtils.decode(request_url));
                                    if (title.length() == 0) {
                                        title = "/";
                                    }
                                    os2.write(("<html>\r\n <head>\r\n <meta charset=\"UTF-8\">\r\n  <title>" + download_name + ": Index of " + title + "</title>" + "\r\n" + " </head>" + "\r\n" + " <body>" + "\r\n" + "  <p>" + download_name + "</p>" + "\r\n" + "  <h1>Index of " + title + "</h1>" + "\r\n" + "  <pre><hr>" + "\r\n").getBytes("UTF-8"));
                                    String root_url = request_url;
                                    if (!root_url.endsWith("/")) {
                                        root_url = root_url + "/";
                                    }
                                    if (request_url.length() > 1) {
                                        int pos = request_url.lastIndexOf(47);
                                        if (pos == 0) {
                                            ++pos;
                                        }
                                        String parent = request_url.substring(0, pos);
                                        os2.write(("<a href=\"" + parent + "\">..</a>" + "\r\n").getBytes("UTF-8"));
                                    }
                                    ArrayList<String[]> filenames = new ArrayList<String[]>(kids.size());
                                    int max_filename = 0;
                                    int MAX_LEN = 120;
                                    for (Object entry : kids) {
                                        int len2;
                                        DiskManagerFileInfo file2;
                                        if (entry instanceof String) {
                                            file2 = null;
                                            file_name = (String)entry;
                                        } else {
                                            file2 = (DiskManagerFileInfo)entry;
                                            if (file2.isSkipped()) continue;
                                            file_name = file2.getTorrentFile().getRelativePath();
                                            int pos = file_name.lastIndexOf(File.separatorChar);
                                            if (pos != -1) {
                                                file_name = file_name.substring(pos + 1);
                                            }
                                        }
                                        String url = root_url + UrlUtils.encode(file_name);
                                        if (file2 == null) {
                                            file_name = file_name + "/";
                                        }
                                        if ((len2 = file_name.length()) > MAX_LEN) {
                                            file_name = file_name.substring(0, MAX_LEN - 3) + "...";
                                            len2 = file_name.length();
                                        }
                                        if (len2 > max_filename) {
                                            max_filename = len2;
                                        }
                                        filenames.add(new String[]{url, file_name, file2 == null ? "" : DisplayFormatters.formatByteCountToKiBEtc(file2.getLength())});
                                    }
                                    max_filename = (max_filename + 15) / 8 * 8;
                                    char[] padding = new char[max_filename];
                                    Arrays.fill(padding, ' ');
                                    Collections.sort(filenames, new Comparator<String[]>(){
                                        Comparator comp = new FormattersImpl().getAlphanumericComparator(true);

                                        @Override
                                        public int compare(String[] o1, String[] o2) {
                                            return this.comp.compare(o1[0], o2[0]);
                                        }
                                    });
                                    for (String[] entry : filenames) {
                                        file_name = entry[1];
                                        int len3 = file_name.length();
                                        StringBuffer line = new StringBuffer(max_filename + 64);
                                        line.append("<a href=\"" + entry[0] + "\">" + XUXmlWriter.escapeXML(file_name) + "</a>");
                                        line.append(padding, 0, max_filename - len3);
                                        line.append(entry[2]);
                                        line.append("\r\n");
                                        os2.write(line.toString().getBytes("UTF-8"));
                                    }
                                    os2.write(("  <hr></pre>\r\n  <address>Vuze Web Server at " + this.host + " Port " + this.getServerPort() + "</address>" + "\r\n" + " </body>" + "\r\n" + "</html>").getBytes("UTF-8"));
                                    return true;
                                }
                                dm_file = (DiskManagerFileInfo)file_node;
                                file_size = dm_file.getLength();
                                File target_file = dm_file.getFile(true);
                                boolean done = dm_file.getDownloaded() == file_size && target_file.length() == file_size;
                                String relative_path = dm_file.getTorrentFile().getRelativePath();
                                int pos = relative_path.lastIndexOf(".");
                                file_type = pos == -1 ? "" : relative_path.substring(pos + 1);
                                if (file_size >= 524288L && !(content_type = HTTPUtils.guessContentTypeFromFileType(file_type)).startsWith("text/") && !content_type.startsWith("image/") && (stream_url2222 = ManagerUtils.getMediaServerContentURL(dm_file)) != null) {
                                    OutputStream os3 = response.getRawOutputStream();
                                    os3.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url2222.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                                    return true;
                                }
                                if (!done) break block66;
                                if (file_size < 524288L) {
                                    boolean stream_url2222;
                                    block63: {
                                        FileInputStream fis = null;
                                        try {
                                            fis = new FileInputStream(target_file);
                                            response.useStream(file_type, fis);
                                            stream_url2222 = true;
                                            Object var28_75 = null;
                                            if (fis == null) break block63;
                                        }
                                        catch (Throwable throwable) {
                                            Object var28_76 = null;
                                            if (fis != null) {
                                                fis.close();
                                            }
                                            throw throwable;
                                        }
                                        fis.close();
                                    }
                                    return stream_url2222;
                                }
                                os = null;
                                InputStream is = null;
                                os = response.getRawOutputStream();
                                byte[] buffer = new byte[131072];
                                is = new FileInputStream(target_file);
                                while ((len = is.read(buffer)) > 0) {
                                    os.write(buffer, 0, len);
                                }
                                Object var30_79 = null;
                                try {
                                    os.close();
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                try {
                                    is.close();
                                }
                                catch (Throwable e2) {}
                                break block67;
                                {
                                    catch (Throwable e) {
                                        Object var30_80 = null;
                                        try {
                                            os.close();
                                        }
                                        catch (Throwable e2) {
                                            // empty catch block
                                        }
                                        try {
                                            is.close();
                                        }
                                        catch (Throwable e2) {}
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var30_81 = null;
                                    try {
                                        os.close();
                                    }
                                    catch (Throwable e2) {
                                        // empty catch block
                                    }
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable e2) {
                                        // empty catch block
                                    }
                                    throw throwable;
                                }
                            }
                            return true;
                        }
                        dm_file.setPriority(10);
                        os = response.getRawOutputStream();
                        os.write(("HTTP/1.1 200 OK\r\nContent-Type:" + HTTPUtils.guessContentTypeFromFileType(file_type) + "\r\n" + "Content-Length: " + file_size + "\r\n" + "Connection: close" + "\r\n" + "X-Vuze-Hack: X").getBytes("UTF-8"));
                        DiskManagerChannel chan = PluginCoreUtils.wrap(dm_file).createChannel();
                        try {
                            final DiskManagerRequest req = chan.createRequest();
                            final boolean[] header_complete = new boolean[]{false};
                            final long[] last_write = new long[]{0L};
                            req.setOffset(0L);
                            req.setLength(file_size);
                            req.addListener(new DiskManagerListener(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void eventOccurred(DiskManagerEvent event2) {
                                    int type = event2.getType();
                                    if (type == 3) {
                                        return;
                                    }
                                    if (type == 2) {
                                        throw new RuntimeException(event2.getFailure());
                                    }
                                    PooledByteBuffer buffer = event2.getBuffer();
                                    if (buffer == null) {
                                        throw new RuntimeException("eh?");
                                    }
                                    try {
                                        try {
                                            boolean do_header = false;
                                            boolean[] blArray = header_complete;
                                            synchronized (header_complete) {
                                                if (!header_complete[0]) {
                                                    do_header = true;
                                                    header_complete[0] = true;
                                                }
                                                last_write[0] = SystemTime.getMonotonousTime();
                                                // ** MonitorExit[var5_6] (shouldn't be in output)
                                                if (do_header) {
                                                    os.write("\r\n\r\n".getBytes("UTF-8"));
                                                }
                                                byte[] data = buffer.toByteArray();
                                                os.write(data);
                                            }
                                        }
                                        catch (IOException e) {
                                            throw new RuntimeException("Failed to write to " + file, e);
                                        }
                                        {
                                            Object var8_8 = null;
                                            buffer.returnToPool();
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var8_9 = null;
                                        buffer.returnToPool();
                                        throw throwable;
                                    }
                                    {
                                        return;
                                    }
                                }
                            });
                            TimerEventPeriodic[] timer_event = new TimerEventPeriodic[]{null};
                            timer_event[0] = SimpleTimer.addPeriodicEvent("KeepAlive", 10000L, new TimerEventPerformer(){
                                boolean cancel_outstanding = false;

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public void perform(TimerEvent event2) {
                                    if (this.cancel_outstanding) {
                                        req.cancel();
                                        return;
                                    }
                                    boolean[] blArray = header_complete;
                                    synchronized (header_complete) {
                                        if (header_complete[0]) {
                                            if (SystemTime.getMonotonousTime() - last_write[0] >= 300000L) {
                                                req.cancel();
                                            }
                                        } else {
                                            try {
                                                os.write("X".getBytes("UTF-8"));
                                                os.flush();
                                            }
                                            catch (Throwable e) {
                                                req.cancel();
                                            }
                                        }
                                        // ** MonitorExit[var2_2] (shouldn't be in output)
                                        if (response.isActive()) return;
                                        this.cancel_outstanding = true;
                                        return;
                                    }
                                }
                            });
                            try {
                                req.run();
                                Object var33_86 = null;
                                timer_event[0].cancel();
                            }
                            catch (Throwable throwable) {
                                Object var33_87 = null;
                                timer_event[0].cancel();
                                throw throwable;
                            }
                            boolean bl = true;
                            {
                                Object var35_89 = null;
                                chan.destroy();
                            }
                            return bl;
                        }
                        catch (Throwable throwable) {
                            try {
                                Object var35_90 = null;
                                chan.destroy();
                                throw throwable;
                            }
                            catch (Throwable e) {
                                return false;
                            }
                        }
                    }

                    private boolean handleRedirect(DownloadManager dm2, File torrent_file, int file_index, String file_name, List<String> networks, TrackerWebPageRequest request2, TrackerWebPageResponse response) {
                        try {
                            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedFile(torrent_file);
                            GlobalManager gm = AzureusCoreFactory.getSingleton().getGlobalManager();
                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                            TorrentOpenOptions torrent_options = new TorrentOpenOptions(torrent_file.getAbsolutePath(), torrent, false);
                            torrent_options.setTorrent(torrent);
                            String[] existing_nets = networks.size() == 0 ? dm2.getDownloadState().getNetworks() : networks.toArray(new String[networks.size()]);
                            for (String net : AENetworkClassifier.AT_NETWORKS) {
                                boolean found = false;
                                for (String x : existing_nets) {
                                    if (net != x) continue;
                                    found = true;
                                    break;
                                }
                                torrent_options.setNetworkEnabled(net, found);
                            }
                            HashMap<String, Object> add_options = new HashMap<String, Object>();
                            add_options.put("silent", true);
                            if (uif.addTorrentWithOptions(torrent_options, add_options)) {
                                long start = SystemTime.getMonotonousTime();
                                while (true) {
                                    long now;
                                    DownloadManager o_dm;
                                    if ((o_dm = gm.getDownloadManager(torrent)) != null && !o_dm.getDownloadState().getFlag(512L)) {
                                        String original_path;
                                        DiskManagerFileInfo[] files = o_dm.getDiskManagerFileInfoSet().getFiles();
                                        DiskManagerFileInfo o_dm_file = null;
                                        if (file_name != null) {
                                            for (DiskManagerFileInfo file2 : files) {
                                                String path = file2.getTorrentFile().getRelativePath();
                                                if (!path.equals(file_name)) continue;
                                                o_dm_file = file2;
                                                break;
                                            }
                                            if (o_dm_file == null) {
                                                o_dm_file = files[0];
                                            }
                                        } else if (file_index < 0) {
                                            long largest = -1L;
                                            for (DiskManagerFileInfo file3 : files) {
                                                if (file3.getLength() <= largest) continue;
                                                o_dm_file = file3;
                                                largest = file3.getLength();
                                            }
                                        } else {
                                            o_dm_file = files[file_index];
                                        }
                                        if ((original_path = request2.getAbsoluteURL().getPath()).endsWith(".html")) {
                                            String url = ManagerUtils.browse(o_dm, file_index < 0 ? null : o_dm_file, anon, false);
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + url + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                        URL stream_url = ManagerUtils.getMediaServerContentURL(o_dm_file);
                                        if (stream_url != null) {
                                            OutputStream os = response.getRawOutputStream();
                                            os.write(("HTTP/1.1 302 Found\r\nLocation: " + stream_url.toExternalForm() + "\r\n" + "\r\n").getBytes("UTF-8"));
                                            return true;
                                        }
                                    }
                                    if ((now = SystemTime.getMonotonousTime()) - start > 180000L) {
                                        Debug.out("Timeout waiting for download to be added");
                                        return false;
                                    }
                                    Thread.sleep(1000L);
                                }
                            }
                            Debug.out("Failed to add download for some reason");
                            return false;
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                            return false;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void unload() throws PluginException {
                        Map map = browse_plugins;
                        synchronized (map) {
                            browse_plugins.remove(dm);
                        }
                        super.unload();
                    }
                };
                PluginManager.registerPlugin(plugin, plugin_id, plugin_id);
                browse_plugins.put(dm, plugin);
                if (launch) {
                    return null;
                }
                waiter.reserve(10000L);
                String[] stringArray = url_holder;
                synchronized (url_holder) {
                    // ** MonitorExit[var17_21] (shouldn't be in output)
                    return url_holder[0];
                }
            }
            String protocol = plugin.getProtocol();
            InetAddress bind_ip = plugin.getServerBindIP();
            String host = bind_ip.isAnyLocalAddress() ? "127.0.0.1" : bind_ip.getHostAddress();
            String url = protocol + "://" + host + ":" + plugin.getServerPort() + "/" + url_suffix;
            if (launch) {
                Utils.launch(url, false, true, anon);
                return null;
            }
            return url;
        }
    }

    public static URL getMediaServerContentURL(DiskManagerFileInfo file) {
        PluginManager pm = AzureusCoreFactory.getSingleton().getPluginManager();
        PluginInterface pi = pm.getPluginInterfaceByID("azupnpav", false);
        if (pi == null) {
            return null;
        }
        if (!pi.getPluginState().isOperational()) {
            return null;
        }
        try {
            String s_url;
            Object url = pi.getIPC().invoke("getContentURL", new Object[]{PluginCoreUtils.wrap(file)});
            if (url instanceof String && (s_url = (String)url).length() > 0) {
                return new URL(s_url);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70;
    }

    public static boolean isStopable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65;
    }

    public static boolean isPauseable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state != 70 && state != 65 && state != 100;
    }

    public static boolean isStopped(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 100;
    }

    public static boolean isForceStartable(DownloadManager dm) {
        if (dm == null) {
            return false;
        }
        int state = dm.getState();
        return state == 70 || state == 75 || state == 60 || state == 50;
    }

    public static void host(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().hostTorrent(torrent, true, false);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void publish(AzureusCore azureus_core, DownloadManager dm) {
        if (dm == null) {
            return;
        }
        TOTorrent torrent = dm.getTorrent();
        if (torrent == null) {
            return;
        }
        try {
            azureus_core.getTrackerHost().publishTorrent(torrent);
        }
        catch (TRHostException e) {
            MessageBoxShell mb = new MessageBoxShell(33, MessageText.getString("MyTorrentsView.menu.host.error.title"), MessageText.getString("MyTorrentsView.menu.host.error.message").concat("\n").concat(e.toString()));
            mb.open(null);
        }
    }

    public static void start(DownloadManager dm) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateWaiting();
        }
    }

    public static void queue(DownloadManager dm, Composite panelNotUsed) {
        if (dm != null && dm.getState() == 70) {
            dm.setStateQueued();
        }
    }

    public static void pause(DownloadManager dm, Shell shell) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65) {
            return;
        }
        ManagerUtils.asyncPause(dm);
    }

    public static void stop(DownloadManager dm, Shell shell) {
        ManagerUtils.stop(dm, shell, 70);
    }

    public static void stop(final DownloadManager dm, final Shell shell, final int stateAfterStopped) {
        if (dm == null) {
            return;
        }
        int state = dm.getState();
        if (state == 70 || state == 65 || state == stateAfterStopped) {
            return;
        }
        boolean stopme = true;
        if (state == 60 && dm.getStats().getShareRatio() >= 0 && dm.getStats().getShareRatio() < 1000 && COConfigurationManager.getBooleanParameter("Alert on close", false)) {
            if (!Utils.isThisThreadSWT()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        ManagerUtils.stop(dm, shell, stateAfterStopped);
                    }
                });
                return;
            }
            Shell aShell = shell == null ? Utils.findAnyShell() : shell;
            MessageBox mb = new MessageBox(aShell, 200);
            mb.setText(MessageText.getString("seedmore.title"));
            mb.setMessage(MessageText.getString("seedmore.shareratio") + dm.getStats().getShareRatio() / 10 + "%.\n" + MessageText.getString("seedmore.uploadmore"));
            int action = mb.open();
            boolean bl = stopme = action == 64;
        }
        if (stopme) {
            ManagerUtils.asyncStop(dm, stateAfterStopped);
        }
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData) {
        ManagerUtils.remove(dm, unused_shell, bDeleteTorrent, bDeleteData, null);
    }

    public static void remove(DownloadManager dm, Shell unused_shell, boolean bDeleteTorrent, boolean bDeleteData, AERunnable deleteFailed) {
        TorrentUtil.removeDownloads(new DownloadManager[]{dm}, null);
        Debug.out("ManagerUtils.remove is Deprecated.  Use TorrentUtil.removeDownloads");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void asyncStopDelete(final DownloadManager dm, int stateAfterStopped, final boolean bDeleteTorrent, final boolean bDeleteData, final AERunnable deleteFailed) {
        TorrentUtils.startTorrentDelete();
        final boolean[] endDone = new boolean[]{false};
        try {
            async.dispatch(new AERunnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void runSupport() {
                    block27: {
                        try {
                            try {
                                reallyDeleteData = bDeleteData != false && dm.getDownloadState().getFlag(64L) == false;
                                dm.getGlobalManager().removeDownloadManager(dm, bDeleteTorrent, reallyDeleteData);
                            }
                            catch (GlobalManagerDownloadRemovalVetoException f) {
                                block26: {
                                    block25: {
                                        try {
                                            pi = AzureusCoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface();
                                            sm = pi.getShareManager();
                                            tracker = pi.getTracker();
                                            shares = sm.getShares();
                                            torrent = dm.getTorrent();
                                            target_hash = torrent.getHash();
                                            arr$ = shares;
                                            len$ = arr$.length;
                                            i$ = 0;
lbl17:
                                            // 2 sources

                                            while (i$ < len$) {
                                                share = arr$[i$];
                                                type = share.getType();
                                                hash = type == 2 ? ((ShareResourceDir)share).getItem().getTorrent().getHash() : (type == 1 ? ((ShareResourceFile)share).getItem().getTorrent().getHash() : null);
                                                if (hash != null && Arrays.equals(target_hash, hash)) {
                                                    try {
                                                        dm.stopIt(70, false, false);
                                                    }
                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                    try {
                                                        tracker_torrent = tracker.getTorrent(PluginCoreUtils.wrap(torrent));
                                                        if (tracker_torrent != null) {
                                                            tracker_torrent.stop();
                                                        }
                                                    }
                                                    catch (Throwable e) {
                                                        // empty catch block
                                                    }
                                                    share.delete();
                                                    break block25;
                                                }
                                                ** GOTO lbl-1000
                                            }
                                            break block26;
                                        }
                                        catch (Throwable var2_15) {
                                            // empty catch block
                                            break block26;
                                        }
                                    }
                                    var16_5 = null;
                                    var17_10 = endDone;
                                    synchronized (endDone) {
                                        if (endDone[0] != false) return;
                                        TorrentUtils.endTorrentDelete();
                                        endDone[0] = true;
                                        // ** MonitorExit[var17_10] (shouldn't be in output)
                                        return;
                                    }
lbl-1000:
                                    // 1 sources

                                    {
                                        ++i$;
                                        ** GOTO lbl17
                                    }
                                }
                                if (!f.isSilent()) {
                                    UIFunctionsManager.getUIFunctions().forceNotify(1, MessageText.getString("globalmanager.download.remove.veto"), f.getMessage(), null, null, -1);
                                }
                                if (deleteFailed != null) {
                                    deleteFailed.runSupport();
                                }
                                var16_6 = null;
                                var17_11 = endDone;
                                synchronized (endDone) {
                                    if (endDone[0] != false) return;
                                    TorrentUtils.endTorrentDelete();
                                    endDone[0] = true;
                                    // ** MonitorExit[var17_11] (shouldn't be in output)
                                    return;
                                }
                            }
                            var16_4 = null;
                            var17_9 = endDone;
                            break block27;
                            catch (Exception ex) {
                                Debug.printStackTrace(ex);
                                if (deleteFailed != null) {
                                    deleteFailed.runSupport();
                                }
                                var16_7 = null;
                                var17_12 = endDone;
                                synchronized (endDone) {
                                    if (endDone[0] != false) return;
                                    TorrentUtils.endTorrentDelete();
                                    endDone[0] = true;
                                    // ** MonitorExit[var17_12] (shouldn't be in output)
                                    return;
                                }
                            }
                        }
                        catch (Throwable var15_30) {
                            var16_8 = null;
                            var17_13 = endDone;
                            synchronized (endDone) {
                                if (endDone[0] != false) throw var15_30;
                                TorrentUtils.endTorrentDelete();
                                endDone[0] = true;
                                // ** MonitorExit[var17_13] (shouldn't be in output)
                                throw var15_30;
                            }
                        }
                    }
                    synchronized (endDone) {
                        if (endDone[0] != false) return;
                        TorrentUtils.endTorrentDelete();
                        endDone[0] = true;
                        // ** MonitorExit[var17_9] (shouldn't be in output)
                        return;
                    }
                }
            });
            return;
        }
        catch (Throwable e) {
            boolean[] blArray = endDone;
            // MONITORENTER : endDone
            if (!endDone[0]) {
                TorrentUtils.endTorrentDelete();
                endDone[0] = true;
            }
            // MONITOREXIT : blArray
            Debug.out(e);
        }
    }

    public static void asyncStop(final DownloadManager dm, final int stateAfterStopped) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.stopIt(stateAfterStopped, false, false);
            }
        });
    }

    public static void asyncPause(final DownloadManager dm) {
        async.dispatch(new AERunnable(){

            public void runSupport() {
                dm.pause();
            }
        });
    }

    public static void asyncStartAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().startAllDownloads();
            }
        });
    }

    public static void asyncStopAll() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().stopAllDownloads();
            }
        });
    }

    public static void asyncPause() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().pauseDownloadsForPeriod(seconds);
            }
        });
    }

    public static void asyncResume() {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                core.getGlobalManager().resumeDownloads();
            }
        });
    }

    public static void asyncPauseForPeriod(final List<DownloadManager> dms, final int seconds) {
        CoreWaiterSWT.waitForCore(CoreWaiterSWT.TriggerInThread.NEW_THREAD, new AzureusCoreRunningListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void azureusCoreRunning(AzureusCore core) {
                final ArrayList<DownloadManager> paused = new ArrayList<DownloadManager>();
                final DownloadManagerAdapter listener = new DownloadManagerAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void stateChanged(DownloadManager manager, int state) {
                        List list = paused;
                        synchronized (list) {
                            if (!paused.remove(manager)) {
                                return;
                            }
                        }
                        manager.removeListener(this);
                    }
                };
                for (DownloadManager dm : dms) {
                    if (!ManagerUtils.isPauseable(dm) || !dm.pause()) continue;
                    ArrayList<DownloadManager> arrayList = paused;
                    synchronized (arrayList) {
                        paused.add(dm);
                    }
                    dm.addListener(listener, false);
                }
                if (paused.size() > 0) {
                    SimpleTimer.addEvent("ManagerUtils.resumer", SystemTime.getOffsetTime(seconds * 1000), new TimerEventPerformer(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void perform(TimerEvent event2) {
                            ArrayList to_resume = new ArrayList();
                            List list = paused;
                            synchronized (list) {
                                to_resume.addAll(paused);
                                paused.clear();
                            }
                            for (DownloadManager dm : to_resume) {
                                dm.removeListener(listener);
                                try {
                                    dm.resume();
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public static void moveToArchive(final List<Download> downloads, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    String title = MessageText.getString("archive.info.title");
                    String text = MessageText.getString("archive.info.text");
                    MessageBoxShell prompter = new MessageBoxShell(title, text, new String[]{MessageText.getString("Button.ok")}, 0);
                    String remember_id = "managerutils.archive.info";
                    prompter.setRemember(remember_id, true, MessageText.getString("MessageBoxWindow.nomoreprompting"));
                    prompter.setAutoCloseInMS(0);
                    prompter.open(null);
                    prompter.waitUntilClosed();
                    for (Download dm : downloads) {
                        try {
                            DownloadStub stub = dm.stubbify();
                            run_when_complete.success(dm, stub);
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                    Object var9_9 = null;
                    run_when_complete.completed();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    run_when_complete.completed();
                    throw throwable;
                }
            }
        });
    }

    public static void restoreFromArchive(final List<DownloadStub> downloads, final boolean start, ArchiveCallback _run_when_complete) {
        final ArchiveCallback run_when_complete = _run_when_complete == null ? new ArchiveCallback() : _run_when_complete;
        Utils.getOffOfSWTThread(new AERunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    Tag tag = null;
                    try {
                        TagManager tm = TagManagerFactory.getTagManager();
                        TagType tt = tm.getTagType(3);
                        String tag_name = MessageText.getString("label.restored");
                        tag = tt.getTag(tag_name, true);
                        if (tag == null) {
                            tag = tt.createTag(tag_name, true);
                            tag.setPublic(false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                    for (DownloadStub dm : downloads) {
                        try {
                            Download dl = dm.destubbify();
                            if (dl != null) {
                                run_when_complete.success(dm, dl);
                                if (tag != null) {
                                    tag.addTaggable(PluginCoreUtils.unwrap(dl));
                                }
                                if (!start) continue;
                                ManagerUtils.start(PluginCoreUtils.unwrap(dl));
                                continue;
                            }
                            run_when_complete.failed(dm, new Exception("Unknown error"));
                        }
                        catch (Throwable e) {
                            run_when_complete.failed(dm, e);
                            Debug.out(e);
                        }
                    }
                    Object var6_7 = null;
                    run_when_complete.completed();
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    run_when_complete.completed();
                    throw throwable;
                }
            }
        });
    }

    public static DownloadManager[] cleanUp(DownloadManager[] dms) {
        ArrayList<DownloadManager> result = new ArrayList<DownloadManager>();
        if (dms != null) {
            for (DownloadManager dm : dms) {
                if (dm == null || dm.isDestroyed()) continue;
                result.add(dm);
            }
        }
        return result.toArray(new DownloadManager[result.size()]);
    }

    public static void locateFiles(DownloadManager[] dms, Shell shell) {
        ManagerUtils.locateFiles(dms, null, shell);
    }

    public static void locateFiles(final DownloadManager[] dms, final DiskManagerFileInfo[][] dm_files, Shell shell) {
        DirectoryDialog dd = new DirectoryDialog(shell);
        dd.setFilterPath(TorrentOpener.getFilterPathData());
        dd.setText(MessageText.getString("MyTorrentsView.menu.locatefiles.dialog"));
        String path = dd.open();
        if (path != null) {
            TorrentOpener.setFilterPathData(path);
            final File dir = new File(path);
            final TextViewerWindow viewer = new TextViewerWindow(MessageText.getString("locatefiles.view.title"), null, "", true, true);
            viewer.setEditable(false);
            viewer.setOKEnabled(true);
            new AEThread2("FileLocator"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 * Converted monitor instructions to comments
                 * Lifted jumps to return sites
                 */
                public void run() {
                    block76: {
                        block77: {
                            block78: {
                                MAX_LINKS = DownloadManagerStateFactory.MAX_FILES_FOR_INCOMPLETE_AND_DND_LINKAGE;
                                LINK_LIMIT_MSG = "Link limit of " + MAX_LINKS + " exceeded. See Tools->Options->Files to increase this";
                                try {
                                    file_map = new HashMap<K, V>();
                                    quit = new boolean[]{false};
                                    viewer.addListener(new TextViewerWindow.TextViewerWindowListener(){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        public void closed() {
                                            boolean[] blArray = quit;
                                            synchronized (quit) {
                                                quit[0] = true;
                                                // ** MonitorExit[var1_1] (shouldn't be in output)
                                                return;
                                            }
                                        }
                                    });
                                    ManagerUtils.access$300(viewer, new SimpleDateFormat().format(new Date()) + ": Enumerating files in " + dir);
                                    bfm_start = SystemTime.getMonotonousTime();
                                    last_log = new long[]{bfm_start};
                                    file_count = ManagerUtils.access$400(viewer, dir, file_map, last_log, quit);
                                    ManagerUtils.access$300(viewer, (bfm_start == last_log[0] ? "" : "\r\n") + "Found " + file_count + " files with " + file_map.size() + " distinct sizes");
                                    all_dm_incomplete_files = null;
                                    hasher = ConcurrentHasher.getSingleton();
                                    downloads_modified = 0;
                                    i = 0;
lbl16:
                                    // 2 sources

                                    while (true) {
                                        if (i < dms.length) {
                                            dm = dms[i];
                                            var14_14 = quit;
                                            // MONITORENTER : quit
                                            if (quit[0]) {
                                                // MONITOREXIT : var14_14
                                            } else {
                                                // MONITOREXIT : var14_14
                                                if (!dm.isPersistent() || (torrent = dm.getTorrent()) == null) break block76;
                                                v0 = selected_files = dm_files == null ? null : dm_files[i];
                                                if (selected_files == null) {
                                                    selected_file_indexes = null;
                                                } else {
                                                    selected_file_indexes = new HashSet<Integer>();
                                                    for (DiskManagerFileInfo f : selected_files) {
                                                        selected_file_indexes.add(f.getIndex());
                                                    }
                                                }
                                                to_files = torrent.getFiles();
                                                piece_size = torrent.getPieceLength();
                                                pieces = torrent.getPieces();
                                                ManagerUtils.access$300(viewer, "Processing '" + dm.getDisplayName() + "', piece size=" + DisplayFormatters.formatByteCountToKiBEtc(piece_size));
                                                dm_state = dm.getState();
                                                if (dm_state != 70 && dm_state != 100) {
                                                    ManagerUtils.access$300(viewer, "    Download must be stopped");
                                                    break block76;
                                                }
                                                files = dm.getDiskManagerFileInfoSet().getFiles();
                                                dm_files = null;
                                                links_established = new HashMap<DiskManagerFileInfo, File>();
                                                unmatched_files = new TreeMap<DiskManagerFileInfo, HashSet<E>>(new Comparator<DiskManagerFileInfo>(){

                                                    @Override
                                                    public int compare(DiskManagerFileInfo o1, DiskManagerFileInfo o2) {
                                                        long diff = o2.getLength() - o1.getLength();
                                                        if (diff < 0L) {
                                                            return -1;
                                                        }
                                                        if (diff > 0L) {
                                                            return 1;
                                                        }
                                                        return 0;
                                                    }
                                                });
                                                no_candidates = 0;
                                                already_complete = 0;
                                                link_count = 0;
                                                try {
                                                    block28: for (DiskManagerFileInfo file : files) {
                                                        var33_38 = quit;
                                                        // MONITORENTER : quit
                                                        if (quit[0]) {
                                                            // MONITOREXIT : var33_38
                                                            break block77;
                                                        }
                                                        // MONITOREXIT : var33_38
                                                        if (selected_file_indexes == null || selected_file_indexes.contains(file.getIndex())) {
                                                            file_length = file.getLength();
                                                            if (file.getDownloaded() == file_length) {
                                                                ++already_complete;
                                                            } else {
                                                                candidates = (HashSet<E>)file_map.get(file_length);
                                                                if (candidates != null) {
                                                                    if (candidates.size() > 0) {
                                                                        if (all_dm_incomplete_files == null) {
                                                                            all_dm_incomplete_files = new HashSet<String>();
                                                                            all_dms = AzureusCoreFactory.getSingleton().getGlobalManager().getDownloadManagers();
                                                                            for (DownloadManager x : all_dms) {
                                                                                if (x.isDownloadComplete(false)) continue;
                                                                                for (DiskManagerFileInfo f : fs = x.getDiskManagerFileInfoSet().getFiles()) {
                                                                                    if (!f.isSkipped() && f.getDownloaded() == f.getLength()) continue;
                                                                                    all_dm_incomplete_files.add(f.getFile(true).getAbsolutePath());
                                                                                }
                                                                            }
                                                                        }
                                                                        it = candidates.iterator();
                                                                        while (it.hasNext()) {
                                                                            f = (File)it.next();
                                                                            if (!all_dm_incomplete_files.contains(f.getAbsolutePath())) continue;
                                                                            it.remove();
                                                                        }
                                                                    }
                                                                    if (candidates.size() > 0) {
                                                                        candidates = new HashSet<E>(candidates);
                                                                        if (dm_files == null) {
                                                                            dm_files = new HashSet<String>();
                                                                            for (DiskManagerFileInfo f : files) {
                                                                                dm_files.add(f.getFile(true).getAbsolutePath());
                                                                            }
                                                                        }
                                                                        it = candidates.iterator();
                                                                        while (it.hasNext()) {
                                                                            f = (File)it.next();
                                                                            if (!dm_files.contains(f.getAbsolutePath())) continue;
                                                                            it.remove();
                                                                        }
                                                                    }
                                                                    if (candidates.size() > 0) {
                                                                        matched = false;
                                                                        failed_candidates = new HashSet<String>();
                                                                        to_file = file.getTorrentFile();
                                                                        offset = 0L;
                                                                        arr$ = to_files;
                                                                        len$ = arr$.length;
                                                                        break block78;
                                                                    }
                                                                    ++no_candidates;
                                                                } else {
                                                                    ++no_candidates;
                                                                }
                                                            }
                                                        }
lbl108:
                                                        // 7 sources

                                                    }
                                                    break block77;
                                                }
                                                catch (Throwable var70_83) {
                                                    var71_79 = null;
                                                    if (link_count <= 0) throw var70_83;
                                                    dm.forceRecheck();
                                                    ++downloads_modified;
                                                    throw var70_83;
                                                }
                                            }
                                        }
                                        ManagerUtils.access$300(viewer, new SimpleDateFormat().format(new Date()) + ": Complete, downloads updated=" + downloads_modified);
                                        return;
                                    }
                                }
                                catch (Throwable e) {
                                    ManagerUtils.access$500(viewer, "\r\n" + new SimpleDateFormat().format(new Date()) + ": Failed: " + Debug.getNestedExceptionMessage(e) + "\r\n");
                                }
                                return;
                            }
                            for (i$ = 0; i$ < len$ && (tf = arr$[i$]) != to_file; offset += tf.getLength(), ++i$) {
                            }
                            to_piece_number = to_file.getFirstPieceNumber();
                            to_file_offset = offset % piece_size;
                            if (to_file_offset != 0L) {
                                to_file_offset = piece_size - to_file_offset;
                                ++to_piece_number;
                            }
                            if (to_file_offset < (to_stop_at = file_length - piece_size)) {
                                ManagerUtils.access$300(viewer, "    " + candidates.size() + " candidate(s) for " + to_file.getRelativePath() + " (size=" + DisplayFormatters.formatByteCountToKiBEtc(to_file.getLength()) + ")");
                                buffer = new byte[(int)piece_size];
                                for (File candidate : candidates) {
                                    var49_64 = quit;
                                    // MONITORENTER : quit
                                    if (quit[0]) {
                                        // MONITOREXIT : var49_64
                                        break;
                                    }
                                    // MONITOREXIT : var49_64
                                    ManagerUtils.access$500(viewer, "        Testing " + candidate);
                                    raf = null;
                                    error = false;
                                    hash_failed = false;
                                    last_ok_log = SystemTime.getMonotonousTime();
                                    try {
                                        try {
                                            raf = new RandomAccessFile(candidate, "r");
                                            piece_number = to_piece_number;
                                            for (file_offset = to_file_offset; file_offset < to_stop_at; file_offset += piece_size, ++piece_number) {
                                                var57_71 = quit;
                                                // MONITORENTER : quit
                                                if (quit[0]) {
                                                    // MONITOREXIT : var57_71
                                                    break;
                                                }
                                                // MONITOREXIT : var57_71
                                                raf.seek(file_offset);
                                                raf.read(buffer);
                                                req = hasher.addRequest(ByteBuffer.wrap(buffer));
                                                hash = req.getResult();
                                                match = Arrays.equals(pieces[piece_number], hash);
                                                if (match) {
                                                    now = SystemTime.getMonotonousTime();
                                                    if (now - last_ok_log < 250L) continue;
                                                    last_ok_log = now;
                                                    ManagerUtils.access$500(viewer, ".");
                                                    continue;
                                                }
                                                hash_failed = true;
                                                failed_candidates.add(candidate.getAbsolutePath());
                                                ManagerUtils.access$300(viewer, "X");
                                                break;
                                            }
                                            var63_75 = null;
                                            ** if (raf == null) goto lbl-1000
                                        }
                                        catch (Throwable e) {
                                            ManagerUtils.access$300(viewer, "X");
                                            error = true;
                                            var63_75 = null;
                                            if (raf != null) {
                                                try {}
                                                catch (Throwable e) {}
                                                raf.close();
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            try {
                                                raf.close();
                                            }
                                            catch (Throwable e) {}
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                        }
                                    }
                                    catch (Throwable var62_80) {
                                        var63_75 = null;
                                        if (raf == null) throw var62_80;
                                        ** try [egrp 8[TRYBLOCK] [16 : 1613->1621)] { 
lbl197:
                                        // 1 sources

                                        raf.close();
                                        throw var62_80;
lbl199:
                                        // 1 sources

                                        catch (Throwable e) {
                                            // empty catch block
                                        }
                                        throw var62_80;
                                    }
                                    if (error || hash_failed) continue;
                                    ManagerUtils.access$300(viewer, " Matched");
                                    try {
                                        dm.setUserData("set_link_dont_delete_existing", true);
                                        if (file.setLink(candidate)) {
                                            ManagerUtils.access$300(viewer, "        Link successful");
                                            links_established.put(file, candidate);
                                            matched = true;
                                            if (++link_count > MAX_LINKS) {
                                                ManagerUtils.access$300(viewer, "    " + LINK_LIMIT_MSG);
                                                var66_77 = null;
                                                dm.setUserData("set_link_dont_delete_existing", null);
                                                break block77;
                                            }
                                        } else {
                                            ManagerUtils.access$300(viewer, "        Link failed");
                                        }
                                        var66_77 = null;
                                        dm.setUserData("set_link_dont_delete_existing", null);
                                        break;
                                    }
                                    catch (Throwable var65_81) {
                                        var66_77 = null;
                                        dm.setUserData("set_link_dont_delete_existing", null);
                                        throw var65_81;
                                    }
                                }
                            }
                            if (matched) ** GOTO lbl108
                            unmatched_files.put(file, failed_candidates);
                            ** while (true)
                        }
                        ManagerUtils.access$300(viewer, "    Matched=" + links_established.size() + ", complete=" + already_complete + ", no candidates=" + no_candidates + ", remaining=" + unmatched_files.size() + " (total=" + files.length + ")");
                        if (links_established.size() > 0 && unmatched_files.size() > 0) {
                            ManagerUtils.access$300(viewer, "    Looking for other potential name-based matches");
                            overall_root = null;
                            for (Map.Entry<K, V> entry : links_established.entrySet()) {
                                dm_file = (DiskManagerFileInfo)entry.getKey();
                                rel = dm_file.getTorrentFile().getRelativePath();
                                pos = 0;
                                for (root = (File)entry.getValue(); root != null; root = root.getParentFile(), ++pos) {
                                    if ((pos = rel.indexOf(File.separatorChar, pos)) < 0) break;
                                }
                                if (root == null) {
                                    ManagerUtils.access$300(viewer, "        No usable root folder found");
                                    break;
                                }
                                if (overall_root == null) {
                                    overall_root = root;
                                    continue;
                                }
                                if (overall_root.equals(root)) continue;
                                overall_root = null;
                                ManagerUtils.access$300(viewer, "        Inconsistent root folder found");
                                break;
                            }
                            if (overall_root != null) {
                                ManagerUtils.access$300(viewer, "        Root folder is " + overall_root.getAbsolutePath());
                                links_ok = 0;
                                for (Map.Entry<K, V> entry : unmatched_files.entrySet()) {
                                    root = quit;
                                    // MONITORENTER : quit
                                    if (quit[0]) {
                                        // MONITOREXIT : root
                                        break;
                                    }
                                    // MONITOREXIT : root
                                    file = (DiskManagerFileInfo)entry.getKey();
                                    if (selected_file_indexes != null && !selected_file_indexes.contains(file.getIndex()) || !(expected_file = new File(overall_root, file.getTorrentFile().getRelativePath())).exists() || expected_file.length() != file.getLength() || ((Set)entry.getValue()).contains(expected_file.getAbsolutePath())) continue;
                                    try {
                                        dm.setUserData("set_link_dont_delete_existing", true);
                                        if (file.setLink(expected_file)) {
                                            ++links_ok;
                                            if (++link_count > MAX_LINKS) {
                                                ManagerUtils.access$300(viewer, "        " + LINK_LIMIT_MSG);
                                                var69_78 = null;
                                                dm.setUserData("set_link_dont_delete_existing", null);
                                                break;
                                            }
                                        }
                                        var69_78 = null;
                                        dm.setUserData("set_link_dont_delete_existing", null);
                                    }
                                    catch (Throwable var68_82) {
                                        var69_78 = null;
                                        dm.setUserData("set_link_dont_delete_existing", null);
                                        throw var68_82;
                                    }
                                }
                                ManagerUtils.access$300(viewer, "        Linked " + links_ok + " of " + unmatched_files.size());
                            }
                        }
                        var71_79 = null;
                        if (link_count > 0) {
                            dm.forceRecheck();
                            ++downloads_modified;
                        }
                    }
                    ++i;
                    ** while (true)
                }
            }.start();
            viewer.goModal();
        }
    }

    private static void logLine(TextViewerWindow viewer, String str) {
        ManagerUtils.log(viewer, str + "\r\n");
    }

    private static void log(final TextViewerWindow viewer, final String str) {
        Utils.execSWTThread(new Runnable(){

            public void run() {
                if (!viewer.isDisposed()) {
                    viewer.append(str);
                }
            }
        });
    }

    private static int buildFileMap(TextViewerWindow viewer, File dir, Map<Long, Set<File>> map, long[] last_log, boolean[] quit) {
        File[] files = dir.listFiles();
        int total_files = 0;
        if (files != null) {
            for (File f : files) {
                if (quit[0]) {
                    return total_files;
                }
                long now = SystemTime.getMonotonousTime();
                if (now - last_log[0] > 250L) {
                    ManagerUtils.log(viewer, ".");
                    last_log[0] = now;
                }
                if (f.isDirectory()) {
                    total_files += ManagerUtils.buildFileMap(viewer, f, map, last_log, quit);
                    continue;
                }
                long size = f.length();
                if (size <= 0L) continue;
                ++total_files;
                Set<File> list = map.get(size);
                if (list == null) {
                    list = new HashSet<File>();
                    map.put(size, list);
                }
                list.add(f);
            }
        }
        return total_files;
    }

    static /* synthetic */ void access$300(TextViewerWindow x0, String x1) {
        ManagerUtils.logLine(x0, x1);
    }

    static /* synthetic */ int access$400(TextViewerWindow x0, File x1, Map x2, long[] x3, boolean[] x4) {
        return ManagerUtils.buildFileMap(x0, x1, x2, x3, x4);
    }

    static /* synthetic */ void access$500(TextViewerWindow x0, String x1) {
        ManagerUtils.log(x0, x1);
    }

    static {
        browse_plugins = new IdentityHashMap<DownloadManager, WebPlugin>();
        async = new AsyncDispatcher(2000);
    }

    public static class ArchiveCallback {
        public void success(DownloadStub source, DownloadStub target) {
        }

        public void failed(DownloadStub original, Throwable error) {
        }

        public void completed() {
        }
    }

    public static interface RunDownloadManager {
        public void run(DownloadManager var1);
    }

    private static class UnloadableWebPlugin
    extends WebPlugin
    implements UnloadablePlugin {
        private UnloadableWebPlugin(Properties props) {
            super(props);
        }

        public void unload() throws PluginException {
            super.unloadPlugin();
        }
    }
}

