/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.systray;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.AzureusCoreRunningListener;
import com.aelitis.azureus.core.tag.TagDownload;
import com.aelitis.azureus.core.tag.TagManager;
import com.aelitis.azureus.core.tag.TagManagerFactory;
import com.aelitis.azureus.core.tag.TagType;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.common.updater.UIUpdatableAlways;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import com.aelitis.azureus.ui.swt.imageloader.ImageLoader;
import java.util.Locale;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerStats;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.common.util.MenuItemManager;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.MenuBuildUtils;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.SelectableSpeedMenu;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class SystemTraySWT
implements UIUpdatableAlways,
MessageText.MessageTextListener {
    private static SystemTraySWT singleton;
    protected static AzureusCore core;
    Display display;
    UIFunctionsSWT uiFunctions;
    Tray tray;
    TrayItem trayItem;
    Menu menu;
    Image imgAzureus;
    Image imgAzureusGray;
    Image imgAzureusWhite;
    protected GlobalManager gm = null;
    private String seedingKeyVal;
    private String downloadingKeyVal;
    private String etaKeyVal;
    private String dlAbbrKeyVal;
    private String ulAbbrKeyVal;
    private String alertsKeyVal;
    long interval = 0L;
    protected boolean enableTooltip;
    protected boolean enableTooltipNextETA;

    public static synchronized SystemTraySWT getTray() {
        if (singleton == null) {
            singleton = new SystemTraySWT();
        }
        return singleton;
    }

    private SystemTraySWT() {
        AzureusCoreFactory.addCoreRunningListener(new AzureusCoreRunningListener(){

            public void azureusCoreRunning(AzureusCore core) {
                SystemTraySWT.core = core;
                SystemTraySWT.this.gm = core.getGlobalManager();
            }
        });
        COConfigurationManager.addAndFireParameterListener("ui.systray.tooltip.enable", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                SystemTraySWT.this.enableTooltip = COConfigurationManager.getBooleanParameter(parameterName);
                if (SystemTraySWT.this.enableTooltip) {
                    MessageText.addAndFireListener(SystemTraySWT.this);
                    SystemTraySWT.this.interval = 0L;
                } else {
                    MessageText.removeListener(SystemTraySWT.this);
                    if (SystemTraySWT.this.trayItem != null && !SystemTraySWT.this.trayItem.isDisposed()) {
                        SystemTraySWT.this.trayItem.setToolTipText(null);
                    }
                }
            }
        });
        COConfigurationManager.addAndFireParameterListener("ui.systray.tooltip.next.eta.enable", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                SystemTraySWT.this.enableTooltipNextETA = COConfigurationManager.getBooleanParameter(parameterName);
                SystemTraySWT.this.interval = 0L;
            }
        });
        this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        this.display = SWTThread.getInstance().getDisplay();
        this.tray = this.display.getSystemTray();
        this.trayItem = new TrayItem(this.tray, 0);
        ImageLoader imageLoader = ImageLoader.getInstance();
        if (Constants.isOSX) {
            this.imgAzureusGray = imageLoader.getImage("azureus_grey");
            this.imgAzureusWhite = imageLoader.getImage("azureus_white");
            this.trayItem.setImage(this.imgAzureusGray);
        } else {
            this.imgAzureus = imageLoader.getImage("azureus");
            this.trayItem.setImage(this.imgAzureus);
        }
        this.trayItem.setVisible(true);
        this.menu = new Menu((Decorations)this.uiFunctions.getMainShell(), 8);
        this.menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent _menu) {
            }

            public void menuHidden(MenuEvent _menu) {
                if (Constants.isOSX) {
                    SystemTraySWT.this.trayItem.setImage(SystemTraySWT.this.imgAzureusGray);
                }
            }
        });
        MenuBuildUtils.addMaintenanceListenerForMenu(this.menu, new MenuBuildUtils.MenuBuilder(){

            public void buildMenu(Menu menu, MenuEvent menuEvent) {
                SystemTraySWT.this.fillMenu(menu);
            }
        });
        this.trayItem.addListener(14, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        this.trayItem.addListener(13, new Listener(){
            long lastTime = 0L;

            public void handleEvent(Event arg0) {
                if (Constants.isWindows) {
                    long now = SystemTime.getCurrentTime();
                    if (now - this.lastTime < 200L) {
                        SystemTraySWT.this.showMainWindow();
                    } else {
                        this.lastTime = now;
                    }
                } else if (Constants.isOSX) {
                    SystemTraySWT.this.trayItem.setImage(SystemTraySWT.this.imgAzureusWhite);
                    SystemTraySWT.this.menu.setVisible(true);
                }
            }
        });
        this.trayItem.addListener(35, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.menu.setVisible(true);
            }
        });
        this.uiFunctions.getUIUpdater().addUpdater(this);
    }

    public void fillMenu(Menu menu) {
        MenuItem itemShow = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemShow, "SystemTray.menu.show");
        new MenuItem(menu, 2);
        MenuItem itemAddTorrent = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemAddTorrent, "menu.open.torrent");
        new MenuItem(menu, 2);
        MenuItem itemCloseAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemCloseAll, "SystemTray.menu.closealldownloadbars");
        MenuItem itemShowGlobalTransferBar = new MenuItem(menu, 32);
        Messages.setLanguageText((Widget)itemShowGlobalTransferBar, "SystemTray.menu.open_global_transfer_bar");
        new MenuItem(menu, 2);
        org.gudy.azureus2.plugins.ui.menus.MenuItem[] menu_items = MenuItemManager.getInstance().getAllAsArray("systray");
        if (menu_items.length > 0) {
            MenuBuildUtils.addPluginMenuItems(menu_items, menu, true, true, MenuBuildUtils.BASIC_MENU_ITEM_CONTROLLER);
            new MenuItem(menu, 2);
        }
        this.createUploadLimitMenu(menu);
        this.createDownloadLimitMenu(menu);
        new MenuItem(menu, 2);
        MenuItem itemStartAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStartAll, "SystemTray.menu.startalltransfers");
        MenuItem itemStopAll = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemStopAll, "SystemTray.menu.stopalltransfers");
        MenuItem itemPause = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemPause, "SystemTray.menu.pausetransfers");
        MenuItem itemResume = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemResume, "SystemTray.menu.resumetransfers");
        new MenuItem(menu, 2);
        Menu optionsMenu = new Menu((Decorations)menu.getShell(), 4);
        MenuItem optionsItem = new MenuItem(menu, 64);
        Messages.setLanguageText((Widget)optionsItem, "tray.options");
        optionsItem.setMenu(optionsMenu);
        final MenuItem itemShowToolTip = new MenuItem(optionsMenu, 32);
        Messages.setLanguageText((Widget)itemShowToolTip, "show.tooltip.label");
        MenuItem itemMoreOptions = new MenuItem(optionsMenu, 8);
        Messages.setLanguageText((Widget)itemMoreOptions, "label.more.dot");
        new MenuItem(menu, 2);
        MenuItem itemExit = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)itemExit, "SystemTray.menu.exit");
        itemShow.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.showMainWindow();
            }
        });
        itemAddTorrent.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.openTorrentWindow();
            }
        });
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.gm == null) {
                    return;
                }
                SystemTraySWT.this.gm.startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.gm == null) {
                    return;
                }
                SystemTraySWT.this.gm.resumeDownloads();
            }
        });
        itemPause.setEnabled(this.gm != null && this.gm.canPauseDownloads());
        itemResume.setEnabled(this.gm != null && this.gm.canResumeDownloads());
        itemCloseAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                SystemTraySWT.this.uiFunctions.closeDownloadBars();
            }
        });
        itemShowGlobalTransferBar.setSelection(this.uiFunctions.isGlobalTransferBarShown());
        itemShowGlobalTransferBar.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                if (SystemTraySWT.this.uiFunctions.isGlobalTransferBarShown()) {
                    SystemTraySWT.this.uiFunctions.closeGlobalTransferBar();
                } else {
                    SystemTraySWT.this.uiFunctions.showGlobalTransferBar();
                }
            }
        });
        itemShowToolTip.setSelection(this.enableTooltip);
        itemShowToolTip.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                COConfigurationManager.setParameter("ui.systray.tooltip.enable", itemShowToolTip.getSelection());
            }
        });
        itemMoreOptions.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", "style");
                }
            }
        });
        itemMoreOptions.setEnabled(this.uiFunctions.getVisibilityState() != 1);
        itemExit.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                Utils.execSWTThreadLater(0, new AERunnable(){

                    public void runSupport() {
                        SystemTraySWT.this.uiFunctions.dispose(false, false);
                    }
                });
            }
        });
    }

    private final void createUploadLimitMenu(Menu parent) {
        if (this.gm == null) {
            return;
        }
        MenuItem uploadSpeedItem = new MenuItem(parent, 64);
        uploadSpeedItem.setText(MessageText.getString("GeneralView.label.maxuploadspeed"));
        final Menu uploadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        uploadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                SelectableSpeedMenu.generateMenuItems(uploadSpeedMenu, core, SystemTraySWT.this.gm, true);
            }
        });
        uploadSpeedItem.setMenu(uploadSpeedMenu);
    }

    private final void createDownloadLimitMenu(Menu parent) {
        if (this.gm == null) {
            return;
        }
        MenuItem downloadSpeedItem = new MenuItem(parent, 64);
        downloadSpeedItem.setText(MessageText.getString("GeneralView.label.maxdownloadspeed"));
        final Menu downloadSpeedMenu = new Menu((Decorations)this.uiFunctions.getMainShell(), 4);
        downloadSpeedMenu.addListener(22, new Listener(){

            public void handleEvent(Event event2) {
                SelectableSpeedMenu.generateMenuItems(downloadSpeedMenu, core, SystemTraySWT.this.gm, false);
            }
        });
        downloadSpeedItem.setMenu(downloadSpeedMenu);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.uiFunctions.getUIUpdater().removeUpdater(this);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (SystemTraySWT.this.trayItem != null && !SystemTraySWT.this.trayItem.isDisposed()) {
                    SystemTraySWT.this.trayItem.dispose();
                }
                ImageLoader imageLoader = ImageLoader.getInstance();
                if (Constants.isOSX) {
                    imageLoader.releaseImage("azureus_grey");
                    imageLoader.releaseImage("azureus_white");
                } else {
                    imageLoader.releaseImage("azureus");
                }
            }
        });
        Class<SystemTraySWT> clazz = SystemTraySWT.class;
        synchronized (SystemTraySWT.class) {
            singleton = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void updateUI() {
        this.updateUI(true);
    }

    public void updateUI(boolean is_visible) {
        if (this.interval++ % 10L > 0L) {
            return;
        }
        if (this.trayItem.isDisposed()) {
            this.uiFunctions.getUIUpdater().removeUpdater(this);
            return;
        }
        if (core == null || !core.isStarted()) {
            return;
        }
        if (this.enableTooltip) {
            TagType tt;
            GlobalManagerStats stats2 = this.gm.getStats();
            StringBuffer toolTip = new StringBuffer();
            int seeding = 0;
            int downloading = 0;
            DownloadManager next_download = null;
            long next_download_eta = Long.MAX_VALUE;
            TagManager tm = TagManagerFactory.getTagManager();
            if (tm != null && tm.isEnabled() && (tt = tm.getTagType(2)) != null) {
                TagDownload dl_tag = (TagDownload)tt.getTag(1);
                downloading = dl_tag.getTaggedCount();
                seeding = tt.getTag(2).getTaggedCount();
                if (this.enableTooltipNextETA && downloading > 0) {
                    for (DownloadManager dl : dl_tag.getTaggedDownloads()) {
                        DownloadManagerStats dl_stats = dl.getStats();
                        long eta = dl_stats.getSmoothedETA();
                        if (eta >= next_download_eta) continue;
                        next_download_eta = eta;
                        next_download = dl;
                    }
                }
            }
            String seeding_text = this.seedingKeyVal.replaceAll("%1", "" + seeding);
            String downloading_text = this.downloadingKeyVal.replaceAll("%1", "" + downloading);
            toolTip.append(seeding_text).append(downloading_text).append("\n");
            if (next_download != null) {
                String dl_name = next_download.getDisplayName();
                if (dl_name.length() > 80) {
                    dl_name = dl_name.substring(0, 77) + "...";
                }
                dl_name = dl_name.replaceAll("&", "&&");
                toolTip.append("  ");
                toolTip.append(dl_name);
                toolTip.append(": ");
                toolTip.append(this.etaKeyVal);
                toolTip.append("=");
                toolTip.append(DisplayFormatters.formatETA(next_download_eta));
                toolTip.append("\n");
            }
            toolTip.append(this.dlAbbrKeyVal).append(" ");
            toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataReceiveRate(), stats2.getProtocolReceiveRate()));
            toolTip.append(", ").append(this.ulAbbrKeyVal).append(" ");
            toolTip.append(DisplayFormatters.formatDataProtByteCountToKiBEtcPerSec(stats2.getDataSendRate(), stats2.getProtocolSendRate()));
            int alerts = Alerts.getUnviewedLogAlertCount();
            if (alerts > 0) {
                toolTip.append("\n");
                toolTip.append(this.alertsKeyVal.replaceAll("%1", "" + alerts));
            }
            this.trayItem.setToolTipText(toolTip.toString());
        }
        this.trayItem.setVisible(true);
    }

    private void showMainWindow() {
        this.uiFunctions.bringToFront(false);
    }

    public void updateLanguage() {
        if (this.menu != null) {
            Messages.updateLanguageForControl((Widget)this.menu);
        }
        this.updateUI();
    }

    public String getUpdateUIName() {
        return "SystemTraySWT";
    }

    public void localeChanged(Locale oldLocale, Locale newLocale) {
        this.seedingKeyVal = MessageText.getString("SystemTray.tooltip.seeding");
        this.downloadingKeyVal = MessageText.getString("SystemTray.tooltip.downloading");
        if (!this.downloadingKeyVal.startsWith(" ")) {
            this.downloadingKeyVal = " " + this.downloadingKeyVal;
        }
        this.etaKeyVal = MessageText.getString("TableColumn.header.eta");
        this.dlAbbrKeyVal = MessageText.getString("ConfigView.download.abbreviated");
        this.ulAbbrKeyVal = MessageText.getString("ConfigView.upload.abbreviated");
        this.alertsKeyVal = MessageText.getString("label.alertnum");
    }

    static {
        core = null;
    }
}

