/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import java.util.Enumeration;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERInteger;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERSequence;

public class DHParameter
implements DEREncodable {
    DERInteger p;
    DERInteger g;
    DERInteger l;

    public DHParameter(BigInteger p, BigInteger g, int l) {
        this.p = new DERInteger(p);
        this.g = new DERInteger(g);
        this.l = l != 0 ? new DERInteger(l) : null;
    }

    public DHParameter(ASN1Sequence seq) {
        Enumeration e = seq.getObjects();
        this.p = (DERInteger)e.nextElement();
        this.g = (DERInteger)e.nextElement();
        this.l = e.hasMoreElements() ? (DERInteger)e.nextElement() : null;
    }

    public BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public BigInteger getL() {
        if (this.l == null) {
            return null;
        }
        return this.l.getPositiveValue();
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.p);
        v.add(this.g);
        if (this.getL() != null) {
            v.add(this.l);
        }
        return new DERSequence(v);
    }
}

