/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.pkcs;

import java.util.Enumeration;
import org.gudy.bouncycastle.asn1.ASN1EncodableVector;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERSequence;
import org.gudy.bouncycastle.asn1.pkcs.EncryptionScheme;
import org.gudy.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import org.gudy.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.gudy.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class PBES2Parameters
implements PKCSObjectIdentifiers,
DEREncodable {
    private KeyDerivationFunc func;
    private EncryptionScheme scheme;

    public PBES2Parameters(ASN1Sequence obj) {
        Enumeration e = obj.getObjects();
        ASN1Sequence funcSeq = (ASN1Sequence)e.nextElement();
        this.func = funcSeq.getObjectAt(0).equals(id_PBKDF2) ? new PBKDF2Params(funcSeq) : new KeyDerivationFunc(funcSeq);
        this.scheme = new EncryptionScheme((ASN1Sequence)e.nextElement());
    }

    public KeyDerivationFunc getKeyDerivationFunc() {
        return this.func;
    }

    public EncryptionScheme getEncryptionScheme() {
        return this.scheme;
    }

    public DERObject getDERObject() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.func);
        v.add(this.scheme);
        return new DERSequence(v);
    }
}

