/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.x509;

import org.gudy.bouncycastle.asn1.ASN1Encodable;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DERSequence;
import org.gudy.bouncycastle.asn1.x509.GeneralName;

public class GeneralNames
extends ASN1Encodable {
    ASN1Sequence seq;

    public static GeneralNames getInstance(Object obj) {
        if (obj == null || obj instanceof GeneralNames) {
            return (GeneralNames)obj;
        }
        if (obj instanceof ASN1Sequence) {
            return new GeneralNames((ASN1Sequence)obj);
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public static GeneralNames getInstance(ASN1TaggedObject obj, boolean explicit) {
        return GeneralNames.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public GeneralNames(GeneralName name) {
        this.seq = new DERSequence(name);
    }

    public GeneralNames(ASN1Sequence seq) {
        this.seq = seq;
    }

    public GeneralName[] getNames() {
        GeneralName[] names = new GeneralName[this.seq.size()];
        for (int i = 0; i != this.seq.size(); ++i) {
            names[i] = GeneralName.getInstance(this.seq.getObjectAt(i));
        }
        return names;
    }

    public DERObject toASN1Object() {
        return this.seq;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String sep = System.getProperty("line.separator");
        GeneralName[] names = this.getNames();
        buf.append("GeneralNames:");
        buf.append(sep);
        for (int i = 0; i != names.length; ++i) {
            buf.append("    ");
            buf.append(names[i]);
            buf.append(sep);
        }
        return buf.toString();
    }
}

