/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.x509;

import org.gudy.bouncycastle.asn1.ASN1Encodable;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.ASN1TaggedObject;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROctetString;
import org.gudy.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.gudy.bouncycastle.asn1.x509.X509Extension;
import org.gudy.bouncycastle.crypto.digests.SHA1Digest;

public class SubjectKeyIdentifier
extends ASN1Encodable {
    private byte[] keyidentifier;

    public static SubjectKeyIdentifier getInstance(ASN1TaggedObject obj, boolean explicit) {
        return SubjectKeyIdentifier.getInstance(ASN1OctetString.getInstance(obj, explicit));
    }

    public static SubjectKeyIdentifier getInstance(Object obj) {
        if (obj instanceof SubjectKeyIdentifier) {
            return (SubjectKeyIdentifier)obj;
        }
        if (obj instanceof SubjectPublicKeyInfo) {
            return new SubjectKeyIdentifier((SubjectPublicKeyInfo)obj);
        }
        if (obj instanceof ASN1OctetString) {
            return new SubjectKeyIdentifier((ASN1OctetString)obj);
        }
        if (obj instanceof X509Extension) {
            return SubjectKeyIdentifier.getInstance(X509Extension.convertValueToObject((X509Extension)obj));
        }
        throw new IllegalArgumentException("Invalid SubjectKeyIdentifier: " + obj.getClass().getName());
    }

    public SubjectKeyIdentifier(byte[] keyid) {
        this.keyidentifier = keyid;
    }

    public SubjectKeyIdentifier(ASN1OctetString keyid) {
        this.keyidentifier = keyid.getOctets();
    }

    public SubjectKeyIdentifier(SubjectPublicKeyInfo spki) {
        SHA1Digest digest = new SHA1Digest();
        byte[] resBuf = new byte[digest.getDigestSize()];
        byte[] bytes = spki.getPublicKeyData().getBytes();
        digest.update(bytes, 0, bytes.length);
        digest.doFinal(resBuf, 0);
        this.keyidentifier = resBuf;
    }

    public byte[] getKeyIdentifier() {
        return this.keyidentifier;
    }

    public DERObject toASN1Object() {
        return new DEROctetString(this.keyidentifier);
    }
}

