/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.asn1.x9;

import java.math.BigInteger;
import org.gudy.bouncycastle.asn1.ASN1OctetString;
import org.gudy.bouncycastle.asn1.DEREncodable;
import org.gudy.bouncycastle.asn1.DERObject;
import org.gudy.bouncycastle.asn1.DEROctetString;
import org.gudy.bouncycastle.math.ec.ECFieldElement;

public class X9FieldElement
implements DEREncodable {
    private ECFieldElement f;

    public X9FieldElement(ECFieldElement f) {
        this.f = f;
    }

    public X9FieldElement(boolean fP, BigInteger q, ASN1OctetString s) {
        if (!fP) {
            throw new RuntimeException("not implemented");
        }
        this.f = new ECFieldElement.Fp(q, new BigInteger(1, s.getOctets()));
    }

    public ECFieldElement getValue() {
        return this.f;
    }

    public DERObject getDERObject() {
        return new DEROctetString(this.f.toBigInteger().toByteArray());
    }
}

