/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.engines;

import java.math.BigInteger;
import org.gudy.bouncycastle.crypto.BasicAgreement;
import org.gudy.bouncycastle.crypto.BufferedBlockCipher;
import org.gudy.bouncycastle.crypto.CipherParameters;
import org.gudy.bouncycastle.crypto.DerivationFunction;
import org.gudy.bouncycastle.crypto.InvalidCipherTextException;
import org.gudy.bouncycastle.crypto.Mac;
import org.gudy.bouncycastle.crypto.params.IESParameters;
import org.gudy.bouncycastle.crypto.params.IESWithCipherParameters;
import org.gudy.bouncycastle.crypto.params.KDFParameters;
import org.gudy.bouncycastle.crypto.params.KeyParameter;

public class IESEngine {
    BasicAgreement agree;
    DerivationFunction kdf;
    Mac mac;
    BufferedBlockCipher cipher;
    byte[] macBuf;
    boolean forEncryption;
    CipherParameters privParam;
    CipherParameters pubParam;
    IESParameters param;

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac) {
        this.agree = agree;
        this.kdf = kdf;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = null;
    }

    public IESEngine(BasicAgreement agree, DerivationFunction kdf, Mac mac, BufferedBlockCipher cipher) {
        this.agree = agree;
        this.kdf = kdf;
        this.mac = mac;
        this.macBuf = new byte[mac.getMacSize()];
        this.cipher = cipher;
    }

    public void init(boolean forEncryption, CipherParameters privParam, CipherParameters pubParam, CipherParameters param) {
        this.forEncryption = forEncryption;
        this.privParam = privParam;
        this.pubParam = pubParam;
        this.param = (IESParameters)param;
    }

    private byte[] decryptBlock(byte[] in_enc, int inOff, int inLen, byte[] z) throws InvalidCipherTextException {
        byte[] M = null;
        KeyParameter macKey = null;
        KDFParameters kParam = new KDFParameters(z, this.param.getDerivationV());
        int macKeySize = this.param.getMacKeySize();
        this.kdf.init(kParam);
        inLen -= this.mac.getMacSize();
        if (this.cipher == null) {
            byte[] buf = new byte[inLen + macKeySize / 8];
            M = new byte[inLen];
            this.kdf.generateBytes(buf, 0, buf.length);
            for (int i = 0; i != inLen; ++i) {
                M[i] = (byte)(in_enc[inOff + i] ^ buf[i]);
            }
            macKey = new KeyParameter(buf, inLen, macKeySize / 8);
        } else {
            int cipherKeySize = ((IESWithCipherParameters)this.param).getCipherKeySize();
            byte[] buf = new byte[cipherKeySize / 8 + macKeySize / 8];
            this.cipher.init(false, new KeyParameter(buf, 0, cipherKeySize / 8));
            byte[] tmp = new byte[this.cipher.getOutputSize(inLen)];
            int off = this.cipher.processBytes(in_enc, inOff, inLen, tmp, 0);
            off += this.cipher.doFinal(tmp, off);
            M = new byte[off];
            System.arraycopy(tmp, 0, M, 0, off);
            macKey = new KeyParameter(buf, cipherKeySize / 8, macKeySize / 8);
        }
        byte[] macIV = this.param.getEncodingV();
        this.mac.init(macKey);
        this.mac.update(in_enc, inOff, inLen);
        this.mac.update(macIV, 0, macIV.length);
        this.mac.doFinal(this.macBuf, 0);
        inOff += inLen;
        for (int t = 0; t < this.macBuf.length; ++t) {
            if (this.macBuf[t] == in_enc[inOff + t]) continue;
            throw new InvalidCipherTextException("Mac codes failed to equal.");
        }
        return M;
    }

    private byte[] encryptBlock(byte[] in, int inOff, int inLen, byte[] z) throws InvalidCipherTextException {
        byte[] C2 = null;
        KeyParameter macKey = null;
        KDFParameters kParam = new KDFParameters(z, this.param.getDerivationV());
        int c_text_length = 0;
        int macKeySize = this.param.getMacKeySize();
        this.kdf.init(kParam);
        if (this.cipher == null) {
            byte[] buf = new byte[inLen + macKeySize / 8];
            C2 = new byte[inLen + this.mac.getMacSize()];
            c_text_length = inLen;
            this.kdf.generateBytes(buf, 0, buf.length);
            for (int i = 0; i != inLen; ++i) {
                C2[i] = (byte)(in[inOff + i] ^ buf[i]);
            }
            macKey = new KeyParameter(buf, inLen, macKeySize / 8);
        } else {
            int cipherKeySize = ((IESWithCipherParameters)this.param).getCipherKeySize();
            byte[] buf = new byte[cipherKeySize / 8 + macKeySize / 8];
            this.cipher.init(true, new KeyParameter(buf, 0, cipherKeySize / 8));
            c_text_length = this.cipher.getOutputSize(inLen);
            C2 = new byte[c_text_length + this.mac.getMacSize()];
            int off = this.cipher.processBytes(in, inOff, inLen, C2, 0);
            this.cipher.doFinal(C2, off);
            macKey = new KeyParameter(buf, cipherKeySize / 8, macKeySize / 8);
        }
        byte[] macIV = this.param.getEncodingV();
        this.mac.init(macKey);
        this.mac.update(C2, 0, c_text_length);
        this.mac.update(macIV, 0, macIV.length);
        this.mac.doFinal(C2, c_text_length);
        return C2;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException {
        this.agree.init(this.privParam);
        BigInteger z = this.agree.calculateAgreement(this.pubParam);
        if (this.forEncryption) {
            return this.encryptBlock(in, inOff, inLen, z.toByteArray());
        }
        return this.decryptBlock(in, inOff, inLen, z.toByteArray());
    }
}

