/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.crypto.generators;

import org.gudy.bouncycastle.crypto.DataLengthException;
import org.gudy.bouncycastle.crypto.DerivationFunction;
import org.gudy.bouncycastle.crypto.DerivationParameters;
import org.gudy.bouncycastle.crypto.Digest;
import org.gudy.bouncycastle.crypto.params.MGFParameters;

public class MGF1BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] seed;
    private int hLen;

    public MGF1BytesGenerator(Digest digest) {
        this.digest = digest;
        this.hLen = digest.getDigestSize();
    }

    public void init(DerivationParameters param) {
        if (!(param instanceof MGFParameters)) {
            throw new IllegalArgumentException("MGF parameters required for MGF1Generator");
        }
        MGFParameters p = (MGFParameters)param;
        this.seed = p.getSeed();
    }

    public Digest getDigest() {
        return this.digest;
    }

    private void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    public int generateBytes(byte[] out, int outOff, int len) throws DataLengthException, IllegalArgumentException {
        byte[] hashBuf = new byte[this.hLen];
        byte[] C2 = new byte[4];
        int counter = 0;
        this.digest.reset();
        do {
            this.ItoOSP(counter, C2);
            this.digest.update(this.seed, 0, this.seed.length);
            this.digest.update(C2, 0, C2.length);
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff + counter * this.hLen, this.hLen);
        } while (++counter < len / this.hLen);
        if (counter * this.hLen < len) {
            this.ItoOSP(counter, C2);
            this.digest.update(this.seed, 0, this.seed.length);
            this.digest.update(C2, 0, C2.length);
            this.digest.doFinal(hashBuf, 0);
            System.arraycopy(hashBuf, 0, out, outOff + counter * this.hLen, len - counter * this.hLen);
        }
        return len;
    }
}

