/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.Principal;
import java.util.Hashtable;
import java.util.Vector;
import org.gudy.bouncycastle.asn1.ASN1InputStream;
import org.gudy.bouncycastle.asn1.ASN1Sequence;
import org.gudy.bouncycastle.asn1.DEROutputStream;
import org.gudy.bouncycastle.asn1.x509.X509Name;

public class X509Principal
extends X509Name
implements Principal {
    public X509Principal(byte[] bytes) throws IOException {
        super((ASN1Sequence)new ASN1InputStream(new ByteArrayInputStream(bytes)).readObject());
    }

    public X509Principal(X509Name name) {
        super((ASN1Sequence)name.getDERObject());
    }

    public X509Principal(Hashtable attributes) {
        super(attributes);
    }

    public X509Principal(Vector ordering, Hashtable attributes) {
        super(ordering, attributes);
    }

    public X509Principal(Vector oids, Vector values) {
        super(oids, values);
    }

    public X509Principal(String dirName) {
        super(dirName);
    }

    public X509Principal(boolean reverse, String dirName) {
        super(reverse, dirName);
    }

    public X509Principal(boolean reverse, Hashtable lookUp, String dirName) {
        super(reverse, lookUp, dirName);
    }

    public String getName() {
        return this.toString();
    }

    public byte[] getEncoded() {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        DEROutputStream dOut = new DEROutputStream(bOut);
        try {
            dOut.writeObject(this);
        }
        catch (IOException e) {
            throw new RuntimeException(e.toString());
        }
        return bOut.toByteArray();
    }
}

