/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.bouncycastle.jce.provider;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.gudy.bouncycastle.crypto.BasicAgreement;
import org.gudy.bouncycastle.crypto.CipherParameters;
import org.gudy.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.gudy.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.gudy.bouncycastle.jce.interfaces.ECPrivateKey;
import org.gudy.bouncycastle.jce.interfaces.ECPublicKey;
import org.gudy.bouncycastle.jce.provider.ECUtil;

public class JCEECDHKeyAgreement
extends KeyAgreementSpi {
    private BigInteger result;
    private CipherParameters privKey;
    private BasicAgreement agreement;

    protected JCEECDHKeyAgreement(BasicAgreement agreement) {
        this.agreement = agreement;
    }

    public Key doPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        return this.engineDoPhase(key, lastPhase);
    }

    protected Key engineDoPhase(Key key, boolean lastPhase) throws InvalidKeyException, IllegalStateException {
        if (this.privKey == null) {
            throw new IllegalStateException("EC Diffie-Hellman not initialised.");
        }
        if (!lastPhase) {
            throw new IllegalStateException("EC Diffie-Hellman can only be between two parties.");
        }
        if (!(key instanceof ECPublicKey)) {
            throw new InvalidKeyException("EC Key Agreement doPhase requires ECPublicKey");
        }
        AsymmetricKeyParameter pubKey = ECUtil.generatePublicKeyParameter((PublicKey)key);
        this.result = this.agreement.calculateAgreement(pubKey);
        return null;
    }

    public byte[] generateSecret() throws IllegalStateException {
        return this.engineGenerateSecret();
    }

    protected byte[] engineGenerateSecret() throws IllegalStateException {
        return this.result.toByteArray();
    }

    protected int engineGenerateSecret(byte[] sharedSecret, int offset) throws IllegalStateException, ShortBufferException {
        byte[] secret = this.result.toByteArray();
        if (sharedSecret.length - offset < secret.length) {
            throw new ShortBufferException("ECKeyAgreement - buffer too short");
        }
        System.arraycopy(secret, 0, sharedSecret, offset, secret.length);
        return secret.length;
    }

    protected SecretKey engineGenerateSecret(String algorithm) {
        return new SecretKeySpec(this.result.toByteArray(), algorithm);
    }

    public void init(Key key) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(key, null);
    }

    protected void engineInit(Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey for initialisation");
        }
        this.privKey = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    protected void engineInit(Key key, SecureRandom random) throws InvalidKeyException {
        if (!(key instanceof ECPrivateKey)) {
            throw new InvalidKeyException("ECKeyAgreement requires ECPrivateKey");
        }
        this.privKey = ECUtil.generatePrivateKeyParameter((PrivateKey)key);
        this.agreement.init(this.privKey);
    }

    public static class DH
    extends JCEECDHKeyAgreement {
        public DH() {
            super(new ECDHBasicAgreement());
        }
    }
}

