/*
 * Decompiled with CFR 0.152.
 */
package com.aelitis.azureus.plugins.featman;

import com.aelitis.azureus.core.proxy.AEProxyFactory;
import com.aelitis.azureus.core.security.CryptoHandler;
import com.aelitis.azureus.core.security.CryptoManager;
import com.aelitis.azureus.core.security.CryptoManagerFactory;
import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.AEThread2;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.AsyncDispatcher;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.BEncoder;
import org.gudy.azureus2.core3.util.Base32;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.SHA1Simple;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.PluginListener;
import org.gudy.azureus2.plugins.UnloadablePlugin;
import org.gudy.azureus2.plugins.installer.StandardPlugin;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.ui.UIManager;
import org.gudy.azureus2.plugins.ui.config.ActionParameter;
import org.gudy.azureus2.plugins.ui.config.InfoParameter;
import org.gudy.azureus2.plugins.ui.config.LabelParameter;
import org.gudy.azureus2.plugins.ui.config.Parameter;
import org.gudy.azureus2.plugins.ui.config.ParameterListener;
import org.gudy.azureus2.plugins.ui.config.StringParameter;
import org.gudy.azureus2.plugins.ui.model.BasicPluginConfigModel;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateInstallerListener;
import org.gudy.azureus2.plugins.utils.FeatureManager;
import org.gudy.azureus2.plugins.utils.LocaleUtilities;
import org.gudy.azureus2.plugins.utils.StaticUtilities;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FeatManPlugin
implements UnloadablePlugin,
FeatureManager.FeatureEnabler,
UIExitUtilsSWT.canCloseListener {
    private static final String SERVER_PK = "ATQTJ53JVNJN54XD3BXCLIWBZL227NLPSHQMMWLKRX4PMXFHSNSOMOP7K7S4P6TE7MBHQTP7NOVENTI";
    private static final String SERVICE_URL;
    private PluginInterface plugin_interface;
    private String plugin_version;
    private LoggerChannel logger;
    private boolean logging_forced;
    private BasicPluginConfigModel config_model;
    private Map<String, InfoParameter> config_map = new HashMap<String, InfoParameter>();
    private String last_message;
    private boolean initialised;
    private String az_version;
    private byte[] server_pk;
    private RequestExecutor request_exec;
    private Object install_lock = new Object();
    private Map<String, List<FeatureManager.Licence.LicenceInstallationListener>> install_listeners;
    private Map<String, PluginException> install_errors;
    private Map<String, List<String>> installing_pid_map;
    private Set<String> install_checking;
    private Set<UpdateCheckInstance> install_instances = new HashSet<UpdateCheckInstance>();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher(5000);

    static {
        String url = System.getProperty("az.license.url", "");
        SERVICE_URL = url.length() == 0 ? "http://license.vuze.com/licence" : url;
    }

    public void initialize(PluginInterface _plugin_interface) throws PluginException {
        this.plugin_interface = _plugin_interface;
        this.plugin_version = this.plugin_interface.getPluginVersion();
        LocaleUtilities loc_utils = this.plugin_interface.getUtilities().getLocaleUtilities();
        loc_utils.integrateLocalisedMessageBundle("com.aelitis.azureus.plugins.featman.internat.Messages");
        this.logger = this.plugin_interface.getLogger().getChannel("FeatMan");
        this.logger.setDiagnostic();
        this.server_pk = Base32.decode((String)SERVER_PK);
        this.az_version = this.plugin_interface.getAzureusVersion();
        this.request_exec = new RequestExecutor();
        this.logger.log("Registering feature enabler");
        this.plugin_interface.getUtilities().getFeatureManager().registerFeatureEnabler((FeatureManager.FeatureEnabler)this);
        this.plugin_interface.addListener(new PluginListener(){

            public void initializationComplete() {
                new AEThread2("FeatManPlugin:init"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        FeatureManager.Licence[] licences;
                        FeatManPlugin.this.refreshLicences();
                        FeatureManager.Licence[] licenceArray = licences = FeatManPlugin.this.getLicences();
                        int n = licences.length;
                        int n2 = 0;
                        while (n2 < n) {
                            FeatureManager.Licence licence = licenceArray[n2];
                            FeatManPlugin.this.checkRequiredPlugins((LicenceImpl)licence);
                            ++n2;
                        }
                        FeatManPlugin featManPlugin = FeatManPlugin.this;
                        synchronized (featManPlugin) {
                            FeatManPlugin.this.initialised = true;
                        }
                        FeatManPlugin.this.checkConfigView();
                        FeatManPlugin.this.addListener(new FeatureManager.FeatureManagerListener(){

                            public void licenceAdded(FeatureManager.Licence licence) {
                                FeatManPlugin.this.checkConfigView();
                            }

                            public void licenceChanged(FeatureManager.Licence licence) {
                                FeatManPlugin.this.checkConfigView();
                            }

                            public void licenceRemoved(FeatureManager.Licence licence) {
                                FeatManPlugin.this.checkConfigView();
                            }
                        });
                    }
                }.start();
            }

            public void closedownInitiated() {
            }

            public void closedownComplete() {
            }
        });
    }

    public boolean canClose() {
        return true;
    }

    public FeatureManager.Licence[] getLicences() {
        return (FeatureManager.Licence[])this.runRequest("getLicences", new Object[0]);
    }

    public FeatureManager.Licence[] createLicences(String[] feature_ids) throws PluginException {
        Object result = this.runRequest("createLicences", new Object[]{feature_ids});
        if (result instanceof PluginException) {
            throw (PluginException)result;
        }
        return (FeatureManager.Licence[])result;
    }

    public FeatureManager.Licence addLicence(String licence_key) {
        if (licence_key == null || licence_key.length() == 0) {
            throw new RuntimeException("Invalid licence");
        }
        return (FeatureManager.Licence)this.runRequest("addLicence", new Object[]{this.normaliseKey(licence_key)});
    }

    private FeatureManager.Licence getLicence(String licence_key) {
        return (FeatureManager.Licence)this.runRequest("getLicence", new Object[]{licence_key});
    }

    private void fireChanged(String licence_key) {
        this.runRequest("fireChanged", new Object[]{licence_key});
    }

    private void removeLicence(FeatureManager.Licence licence) {
        this.runRequest("removeLicence", new Object[]{licence.getKey()});
    }

    public void refreshLicences() {
        this.runRequest("refreshLicences", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConfigView() {
        FeatManPlugin featManPlugin = this;
        synchronized (featManPlugin) {
            InfoParameter param;
            String key;
            FeatureManager.Licence l;
            int n;
            int n2;
            FeatureManager.Licence[] licenceArray;
            boolean rebuild;
            if (this.plugin_interface == null || !this.initialised) {
                if (this.config_model != null) {
                    this.config_model.destroy();
                    this.config_model = null;
                }
                return;
            }
            FeatureManager.Licence[] licences = this.getLicences();
            if (licences.length == 0) {
                if (this.config_model != null) {
                    this.config_model.destroy();
                    this.config_map.clear();
                    this.config_model = null;
                }
                return;
            }
            boolean bl = rebuild = this.config_map.size() != licences.length;
            if (!rebuild) {
                licenceArray = licences;
                n2 = licences.length;
                n = 0;
                while (n < n2) {
                    l = licenceArray[n];
                    key = l.getKey();
                    if (!this.config_map.containsKey(key)) {
                        rebuild = true;
                    }
                    ++n;
                }
            }
            if (rebuild) {
                if (this.config_model != null) {
                    this.config_model.destroy();
                    this.config_map.clear();
                    this.config_model = null;
                }
                this.config_model = this.plugin_interface.getUIManager().createBasicPluginConfigModel("featman.name");
                this.config_model.addLabelParameter2("featman.config.info");
                licenceArray = licences;
                n2 = licences.length;
                n = 0;
                while (n < n2) {
                    l = licenceArray[n];
                    key = l.getKey();
                    param = this.config_model.addInfoParameter2("!\t" + key + "!", this.getStatusText(l));
                    this.config_map.put(key, param);
                    ++n;
                }
                if (Constants.isCVSVersion()) {
                    final StringParameter key2 = this.config_model.addStringParameter2("featman.config.key", "featman.config.key", "");
                    key2.setValue("");
                    final LabelParameter[] action_result = new LabelParameter[1];
                    ActionParameter add = this.config_model.addActionParameter2("featman.config.add", "featman.config.add.button");
                    add.addListener(new ParameterListener(){

                        public void parameterChanged(Parameter param) {
                            FeatureManager.Licence l = FeatManPlugin.this.addLicence(key2.getValue());
                            if (l == null) {
                                action_result[0].setLabelText("Action result: License not added");
                            } else {
                                action_result[0].setLabelText("Action result: License added - close this view and reopen it!");
                            }
                        }
                    });
                    ActionParameter remove = this.config_model.addActionParameter2("featman.config.remove", "featman.config.remove.button");
                    remove.addListener(new ParameterListener(){

                        public void parameterChanged(Parameter param) {
                            FeatureManager.Licence l = FeatManPlugin.this.getLicence(key2.getValue());
                            if (l == null) {
                                action_result[0].setLabelText("Action result: License not found");
                            } else {
                                l.remove();
                                action_result[0].setLabelText("Action result: License removed - close this view and reopen it!");
                            }
                        }
                    });
                    action_result[0] = this.config_model.addLabelParameter2("");
                    action_result[0].setLabelText("Action result:");
                }
            }
            licenceArray = licences;
            int n3 = licences.length;
            int n4 = 0;
            while (n4 < n3) {
                l = licenceArray[n4];
                key = l.getKey();
                param = this.config_map.get(key);
                if (param != null) {
                    param.setValue(this.getStatusText(l));
                }
                ++n4;
            }
        }
    }

    private String getStatusText(FeatureManager.Licence l) {
        String state_str;
        int state = l.getState();
        boolean warning_required = false;
        switch (state) {
            case 1: {
                state_str = "pending authentication";
                break;
            }
            case 2: {
                state_str = "authenticated";
                break;
            }
            case 3: {
                state_str = "invalid";
                break;
            }
            case 6: {
                state_str = "activation denied";
                warning_required = true;
                break;
            }
            case 4: {
                state_str = "cancelled";
                warning_required = true;
                break;
            }
            case 5: {
                state_str = "revoked";
                warning_required = true;
                break;
            }
            default: {
                state_str = "unknown";
            }
        }
        FeatureManager.FeatureDetails[] features = l.getFeatures();
        String f_str = "";
        FeatureManager.FeatureDetails[] featureDetailsArray = features;
        int n = features.length;
        int n2 = 0;
        while (n2 < n) {
            FeatureManager.FeatureDetails fd = featureDetailsArray[n2];
            try {
                f_str = String.valueOf(f_str) + (f_str.length() == 0 ? "" : ", ") + fd.getID();
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
            }
            ++n2;
        }
        return "state=" + state_str + ", ready=" + l.isFullyInstalled() + ", features=" + f_str;
    }

    private void setFeatureProperty(FeatureManager.FeatureDetails feature, String name, Object value) {
        this.runRequest("setFeatureProperty", new Object[]{feature.getLicence().getKey(), feature.getID(), name, value});
    }

    public void addListener(FeatureManager.FeatureManagerListener listener) {
        this.runRequest("addListener", new Object[]{listener});
    }

    public void removeListener(FeatureManager.FeatureManagerListener listener) {
        this.runRequest("removeListener", new Object[]{listener});
    }

    private boolean isPluginInstalled(String pid) {
        PluginInterface pi = this.plugin_interface.getPluginManager().getPluginInterfaceByID(pid);
        if (pi == null) {
            return false;
        }
        return pi.getPluginState().isOperational();
    }

    /*
     * Exception decompiling
     */
    private void checkRequiredPlugins(LicenceImpl licence) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [20[MONITOR]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installStarts(List<StandardPlugin> plugins) {
        ArrayList<Object[]> to_inform = new ArrayList<Object[]>();
        Object object = this.install_lock;
        synchronized (object) {
            HashSet<String> affected_licence_keys = new HashSet<String>();
            for (StandardPlugin sp : plugins) {
                List<String> keys;
                String pid = sp.getId();
                List<String> list = keys = this.installing_pid_map == null ? null : this.installing_pid_map.get(pid);
                if (keys == null) continue;
                affected_licence_keys.addAll(keys);
            }
            if (this.install_listeners != null) {
                for (String key : affected_licence_keys) {
                    List<FeatureManager.Licence.LicenceInstallationListener> listeners = this.install_listeners.get(key);
                    if (listeners == null) continue;
                    for (FeatureManager.Licence.LicenceInstallationListener l : listeners) {
                        to_inform.add(new Object[]{l, key});
                    }
                }
            }
        }
        for (Object[] entry : to_inform) {
            FeatureManager.Licence.LicenceInstallationListener listener = (FeatureManager.Licence.LicenceInstallationListener)entry[0];
            String licence_key = (String)entry[1];
            try {
                listener.start(licence_key);
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installProgress(List<StandardPlugin> plugins, String update, String activity, int percent) {
        ArrayList<Object[]> to_inform = new ArrayList<Object[]>();
        Object object = this.install_lock;
        synchronized (object) {
            HashSet<String> affected_licence_keys = new HashSet<String>();
            for (StandardPlugin sp : plugins) {
                List<String> keys;
                String pid = sp.getId();
                List<String> list = keys = this.installing_pid_map == null ? null : this.installing_pid_map.get(pid);
                if (keys == null) continue;
                affected_licence_keys.addAll(keys);
            }
            if (this.install_listeners != null) {
                for (String key : affected_licence_keys) {
                    List<FeatureManager.Licence.LicenceInstallationListener> listeners = this.install_listeners.get(key);
                    if (listeners == null) continue;
                    for (FeatureManager.Licence.LicenceInstallationListener l : listeners) {
                        to_inform.add(new Object[]{l, key});
                    }
                }
            }
        }
        for (Object[] entry : to_inform) {
            FeatureManager.Licence.LicenceInstallationListener listener = (FeatureManager.Licence.LicenceInstallationListener)entry[0];
            String licence_key = (String)entry[1];
            try {
                if (activity != null) {
                    listener.reportActivity(licence_key, update, activity);
                    continue;
                }
                listener.reportProgress(licence_key, update, percent);
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void installCompleted(List<StandardPlugin> plugins, boolean cancelled, Throwable _error) {
        PluginException plugin_exception = null;
        if (_error != null) {
            plugin_exception = _error instanceof PluginException ? (PluginException)_error : new PluginException("Installation failed", _error);
        }
        ArrayList<Object[]> to_inform = new ArrayList<Object[]>();
        Object object = this.install_lock;
        synchronized (object) {
            HashSet<String> affected_licence_keys = new HashSet<String>();
            for (StandardPlugin sp : plugins) {
                List<String> keys;
                String pid = sp.getId();
                List<String> list = keys = this.installing_pid_map == null ? null : this.installing_pid_map.remove(pid);
                if (keys == null) continue;
                if (plugin_exception != null) {
                    if (this.install_errors == null) {
                        this.install_errors = new HashMap<String, PluginException>();
                    }
                    for (String k : keys) {
                        this.install_errors.put(k, plugin_exception);
                    }
                }
                affected_licence_keys.addAll(keys);
            }
            if (this.installing_pid_map != null && this.installing_pid_map.size() == 0) {
                this.installing_pid_map = null;
            }
            if (this.install_listeners != null) {
                for (String key : affected_licence_keys) {
                    List<FeatureManager.Licence.LicenceInstallationListener> listeners = this.install_listeners.get(key);
                    if (listeners == null) continue;
                    for (FeatureManager.Licence.LicenceInstallationListener l : listeners) {
                        to_inform.add(new Object[]{l, key});
                    }
                }
            }
        }
        for (Object[] entry : to_inform) {
            FeatureManager.Licence.LicenceInstallationListener listener = (FeatureManager.Licence.LicenceInstallationListener)entry[0];
            String licence_key = (String)entry[1];
            try {
                if (plugin_exception != null) {
                    listener.failed(licence_key, plugin_exception);
                } else if (cancelled) {
                    listener.failed(licence_key, new PluginException("Installation cancelled"));
                } else {
                    listener.complete(licence_key);
                }
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
            }
            FeatureManager.Licence licence = this.getLicence(licence_key);
            if (!licence.isFullyInstalled()) continue;
            this.fireChanged(licence_key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInstallListener(LicenceImpl licence, FeatureManager.Licence.LicenceInstallationListener listener) {
        boolean done;
        String key = licence.getKey();
        PluginException error = null;
        Object object = this.install_lock;
        synchronized (object) {
            if (listener != null) {
                List<FeatureManager.Licence.LicenceInstallationListener> listeners;
                if (this.install_listeners == null) {
                    this.install_listeners = new HashMap<String, List<FeatureManager.Licence.LicenceInstallationListener>>();
                }
                if ((listeners = this.install_listeners.get(key)) == null) {
                    listeners = new ArrayList<FeatureManager.Licence.LicenceInstallationListener>();
                    this.install_listeners.put(key, listeners);
                }
                listeners.add(listener);
            }
            if (!(done = licence.isFullyInstalled()) && this.install_errors != null) {
                error = this.install_errors.get(key);
            }
        }
        if (done) {
            if (listener != null) {
                listener.complete(key);
            }
        } else if (error != null) {
            if (listener != null) {
                listener.failed(key, error);
            }
        } else {
            this.checkRequiredPlugins(licence);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeInstallListener(LicenceImpl licence, FeatureManager.Licence.LicenceInstallationListener listener) {
        if (listener != null) {
            String key = licence.getKey();
            Object object = this.install_lock;
            synchronized (object) {
                if (this.install_listeners == null) {
                    return;
                }
                List<FeatureManager.Licence.LicenceInstallationListener> listeners = this.install_listeners.get(key);
                if (listeners != null) {
                    listeners.remove(listener);
                    if (listeners.size() == 0) {
                        this.install_listeners.remove(key);
                        if (this.install_listeners.size() == 0) {
                            this.install_listeners = null;
                        }
                    }
                }
            }
        }
    }

    public void unload() throws PluginException {
        if (this.plugin_interface != null) {
            this.runRequest("unload", new Object[0]);
            this.plugin_interface.getUtilities().getFeatureManager().unregisterFeatureEnabler((FeatureManager.FeatureEnabler)this);
            this.plugin_interface = null;
            UIExitUtilsSWT.removeListener((UIExitUtilsSWT.canCloseListener)this);
            this.checkConfigView();
        }
    }

    private void setForceLogging() {
        if (this.logging_forced) {
            return;
        }
        this.logging_forced = true;
        try {
            Field f1 = this.logger.getClass().getDeclaredField("diagnostic_logger");
            f1.setAccessible(true);
            Object obj = f1.get(this.logger);
            Field f2 = obj.getClass().getDeclaredField("force");
            f2.setAccessible(true);
            f2.set(obj, true);
        }
        catch (Throwable e) {
            Debug.out((Throwable)e);
        }
    }

    public Object runRequest(String command, Object[] args) {
        RequestExecutor exec = this.request_exec;
        if (exec.getClass() != RequestExecutor.class) {
            Debug.out((String)"class mismatch");
            throw new RuntimeException("class mismatch");
        }
        return exec.runRequest(command, args);
    }

    private String normaliseKey(String key) {
        char[] chars;
        if (key == null) {
            return null;
        }
        key = key.toUpperCase(Locale.US).trim();
        String res = "";
        char[] cArray = chars = key.toCharArray();
        int n = chars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isLetterOrDigit(c)) {
                res = String.valueOf(res) + c;
            }
            ++n2;
        }
        res = res.length() == 20 ? String.valueOf(res.substring(0, 5)) + "-" + res.substring(5, 10) + "-" + res.substring(10, 15) + "-" + res.substring(15, 20) : key;
        return res;
    }

    protected String getString(Map<String, Object> map, String name) throws IOException {
        Object obj = map.get(name);
        if (obj instanceof String) {
            return (String)obj;
        }
        byte[] bytes = (byte[])obj;
        if (bytes == null) {
            return null;
        }
        return new String(bytes, "UTF-8");
    }

    static /* synthetic */ void access$8(FeatManPlugin featManPlugin) {
        featManPlugin.setForceLogging();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class FeatureDetailsImpl
    implements FeatureManager.FeatureDetails {
        private FeatureManager.Licence licence;
        private String id;
        private byte[] encoded_properties;
        private byte[] signature;
        private Map<String, Object> pending_properties = new HashMap<String, Object>();

        protected FeatureDetailsImpl(FeatureManager.Licence _licence, Map map) {
            this.licence = _licence;
            this.id = (String)map.get("id");
            this.encoded_properties = Base32.decode((String)((String)map.get("properties")));
            String sig_str = (String)map.get("sig");
            if (sig_str != null) {
                this.signature = Base32.decode((String)sig_str);
            }
            this.pending_properties = BDecoder.decodeStrings((Map)((Map)map.get("pending")));
            if (this.pending_properties == null) {
                this.pending_properties = new HashMap<String, Object>();
            }
        }

        private Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("id", this.id);
            map.put("properties", Base32.encode((byte[])this.encoded_properties));
            if (this.signature != null) {
                map.put("sig", Base32.encode((byte[])this.signature));
            }
            if (this.pending_properties.size() > 0) {
                map.put("pending", this.pending_properties);
            }
            return map;
        }

        private Map<String, Object> getPendingProperties() {
            return this.pending_properties;
        }

        private Map<String, Object> getOfficialProperties() {
            try {
                return BDecoder.decode((byte[])this.encoded_properties);
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
                return new HashMap<String, Object>();
            }
        }

        public String getID() {
            return this.id;
        }

        public FeatureManager.Licence getLicence() {
            return this.licence;
        }

        public boolean hasExpired() {
            Long offline_expiry;
            long now;
            block4: {
                now = SystemTime.getCurrentTime();
                Map properties = BDecoder.decode((byte[])this.encoded_properties);
                Long expiry = (Long)properties.get("ValidUntil");
                offline_expiry = (Long)properties.get("OfflineValidUntil");
                if (expiry == null || expiry <= 0L || expiry > now) break block4;
                return true;
            }
            try {
                if (offline_expiry != null && offline_expiry > 0L && offline_expiry <= now) {
                    return true;
                }
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
            }
            return false;
        }

        public byte[] getEncodedProperties() {
            return this.encoded_properties;
        }

        public byte[] getSignature() {
            return this.signature;
        }

        private long getLongProperty(String name, long def) {
            Object o = this.getProperty(name);
            if (o instanceof Long) {
                return (Long)o;
            }
            if (o != null) {
                Debug.out((String)("property value " + o + " not a Long"));
            }
            return def;
        }

        public Object getProperty(String property_name) {
            try {
                Object pending_res;
                Object official_res = BDecoder.decode((byte[])this.encoded_properties).get(property_name);
                if (official_res instanceof byte[]) {
                    try {
                        official_res = new String((byte[])official_res, "UTF-8");
                    }
                    catch (Throwable e) {
                        Debug.out((Throwable)e);
                    }
                }
                if (property_name.equals("TrialUsesRemaining") && official_res != null) {
                    Object pending_res2 = this.pending_properties.get(property_name);
                    if (pending_res2 != null && (Long)pending_res2 < (Long)official_res) {
                        official_res = pending_res2;
                    }
                } else if (property_name.equals("TrialUsesFailCount") && official_res != null && (pending_res = this.pending_properties.get(property_name)) != null && (Long)pending_res > (Long)official_res) {
                    official_res = pending_res;
                }
                return official_res;
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
                return null;
            }
        }

        public void setProperty(String property_name, Object property_value) {
            this.setPropertyInternal(property_name, property_value, false);
        }

        private boolean setPropertyInternal(String property_name, Object property_value, boolean changing_internally) {
            if (property_name.equals("TrialUsesRemaining")) {
                long l_existing;
                long l_value = (Long)property_value;
                if (l_value < (l_existing = this.getLongProperty(property_name, 0L))) {
                    this.pending_properties.put(property_name, property_value);
                    if (!changing_internally) {
                        FeatManPlugin.this.setFeatureProperty(this, property_name, property_value);
                    }
                    return true;
                }
            } else if (property_name.equals("TrialUsesFailCount")) {
                long l_existing;
                long l_value = (Long)property_value;
                if (l_value > (l_existing = this.getLongProperty(property_name, 0L))) {
                    this.pending_properties.put(property_name, property_value);
                    if (!changing_internally) {
                        FeatManPlugin.this.setFeatureProperty(this, property_name, property_value);
                    }
                    return true;
                }
            } else {
                Debug.out((String)"Not supported");
            }
            return false;
        }

        static /* synthetic */ boolean access$3(FeatureDetailsImpl featureDetailsImpl, String string, Object object, boolean bl) {
            return featureDetailsImpl.setPropertyInternal(string, object, bl);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class LicenceImpl
    implements FeatureManager.Licence {
        private String key;
        private String short_id;
        private int state;
        private FeatureDetailsImpl[] details;

        protected LicenceImpl(String _key) {
            this.key = _key;
            this.short_id = this.calcSID();
            this.state = 1;
            this.details = new FeatureDetailsImpl[0];
        }

        protected LicenceImpl(Map<String, Object> map) {
            this.init(map);
        }

        protected void init(Map<String, Object> map) {
            this.key = FeatManPlugin.this.normaliseKey((String)map.get("key"));
            this.short_id = (String)map.get("sid");
            if (this.short_id == null) {
                this.short_id = this.calcSID();
            }
            this.state = ((Long)map.get("state")).intValue();
            List features = (List)map.get("features");
            if (features == null) {
                this.details = new FeatureDetailsImpl[0];
            } else {
                this.details = new FeatureDetailsImpl[features.size()];
                int pos = 0;
                for (Map m : features) {
                    this.details[pos++] = new FeatureDetailsImpl(this, m);
                }
            }
        }

        private Map<String, Object> toMap() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key);
            map.put("sid", this.short_id);
            map.put("state", new Long(this.state));
            ArrayList<Map> features = new ArrayList<Map>();
            map.put("features", features);
            FeatureDetailsImpl[] featureDetailsImplArray = this.details;
            int n = this.details.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureDetailsImpl d = featureDetailsImplArray[n2];
                features.add(d.toMap());
                ++n2;
            }
            return map;
        }

        private String calcSID() {
            try {
                return Base32.encode((byte[])new SHA1Simple().calculateHash(this.key.getBytes("UTF-8"))).substring(0, 20);
            }
            catch (Throwable e) {
                Debug.out((Throwable)e);
                return "<unknown>";
            }
        }

        public String getKey() {
            return this.key;
        }

        public String getShortID() {
            return this.short_id;
        }

        public FeatureDetailsImpl[] getFeatures() {
            return this.details;
        }

        public int getState() {
            return this.state;
        }

        public boolean isFullyInstalled() {
            if (this.state == 1) {
                return false;
            }
            List<String> pids = this.getRequiredPIDs();
            for (String pid : pids) {
                if (FeatManPlugin.this.isPluginInstalled(pid)) continue;
                return false;
            }
            return true;
        }

        public void retryInstallation() {
            FeatManPlugin.this.addInstallListener(this, null);
        }

        private List<String> getRequiredPIDs() {
            ArrayList<String> result = new ArrayList<String>();
            FeatureDetailsImpl[] featureDetailsImplArray = this.details;
            int n = this.details.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureDetailsImpl detail = featureDetailsImplArray[n2];
                String pids = (String)detail.getProperty("Plugins");
                if (pids != null) {
                    String[] p;
                    String[] stringArray = p = pids.split(",");
                    int n3 = p.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String s = stringArray[n4];
                        if ((s = s.trim()).length() > 0 && !result.contains(s)) {
                            result.add(s);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return result;
        }

        public void addInstallationListener(FeatureManager.Licence.LicenceInstallationListener listener) {
            FeatManPlugin.this.addInstallListener(this, listener);
        }

        public void removeInstallationListener(FeatureManager.Licence.LicenceInstallationListener listener) {
            FeatManPlugin.this.removeInstallListener(this, listener);
        }

        public boolean usedByInstaller() {
            FeatureDetailsImpl[] featureDetailsImplArray = this.details;
            int n = this.details.length;
            int n2 = 0;
            while (n2 < n) {
                FeatureDetailsImpl detail = featureDetailsImplArray[n2];
                Long trial = (Long)detail.getProperty("IsTrial");
                Long install_time = (Long)detail.getProperty("IsInstallTime");
                if ((trial == null || trial == 0L) && install_time != null && install_time == 1L) {
                    return true;
                }
                ++n2;
            }
            return false;
        }

        public void remove() {
            FeatManPlugin.this.removeLicence(this);
        }

        private LicenceImpl getCopy() {
            return new LicenceImpl(this.toMap());
        }

        private boolean updateFrom(LicenceImpl other) {
            Map<String, Object> other_map = other.toMap();
            if (!BEncoder.mapsAreIdentical(this.toMap(), other_map)) {
                this.init(other_map);
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RequestExecutor {
        private volatile boolean initialised;
        private AESemaphore request_sem = new AESemaphore("RequestExecutor");
        private List<Object[]> request_queue = new ArrayList<Object[]>();

        private RequestExecutor() {
            Class[] context = SESecurityManager.getClassContext();
            if (context[2] != FeatManPlugin.class) {
                Debug.out((String)"Illegal operation");
                return;
            }
            AEThread2 t = new AEThread2("RequestExecutor"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public void run() {
                    state_file = FeatManPlugin.access$4(RequestExecutor.access$9(RequestExecutor.this)).getPluginconfig().getPluginUserFile("licences.dat");
                    listeners = new ArrayList<Map>();
                    listener_dispatcher = new AsyncDispatcher();
                    update_dispatcher = new AsyncDispatcher();
                    all_licences = RequestExecutor.access$0(RequestExecutor.this, state_file);
                    update_now = new boolean[1];
                    unloaded = new boolean[1];
                    lock = new Object();
                    update = new AERunnable(){
                        private static final int MIN_UPDATE_PERIOD_DEFAULT = 10000;
                        private static final int MAX_UPDATE_PERIOD_DEFAULT = 3600000;
                        private int min_update_period = 10000;
                        private int max_update_period = 3600000;
                        private boolean update_in_progress;
                        private TimerEvent deferred_update_event;
                        private long last_update_time = -1L;
                        private int consec_update_fails;
                        private AERunnable me = this;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void runSupport() {
                            block70: {
                                Object object;
                                if (unloaded[0]) {
                                    return;
                                }
                                long now = SystemTime.getMonotonousTime();
                                Object object2 = lock;
                                synchronized (object2) {
                                    if (update_now[0]) {
                                        update_now[0] = false;
                                        if (this.deferred_update_event != null) {
                                            this.deferred_update_event.cancel();
                                            this.deferred_update_event = null;
                                        }
                                    } else {
                                        if (this.deferred_update_event != null) {
                                            return;
                                        }
                                        long time_since_last_update = now - this.last_update_time;
                                        if (this.last_update_time > 0L && time_since_last_update < (long)this.min_update_period) {
                                            this.deferUpdate((long)this.min_update_period - time_since_last_update);
                                            return;
                                        }
                                    }
                                    this.update_in_progress = true;
                                }
                                try {
                                    try {
                                        Object response;
                                        HashMap<String, Object> payload = new HashMap<String, Object>();
                                        ArrayList keys = new ArrayList();
                                        HashSet<String> feature_types = new HashSet<String>();
                                        HashSet pids = new HashSet();
                                        Map map = all_licences;
                                        synchronized (map) {
                                            keys.addAll(all_licences.keySet());
                                            HashMap licence_updates = new HashMap();
                                            for (LicenceImpl licence : all_licences.values()) {
                                                pids.addAll(licence.getRequiredPIDs());
                                                FeatureDetailsImpl[] fds = licence.getFeatures();
                                                HashMap feature_updates = new HashMap();
                                                FeatureDetailsImpl[] featureDetailsImplArray = fds;
                                                int n = fds.length;
                                                int n2 = 0;
                                                while (n2 < n) {
                                                    FeatureDetailsImpl fd = featureDetailsImplArray[n2];
                                                    feature_types.add(fd.getID());
                                                    Map pending_props = fd.getPendingProperties();
                                                    if (pending_props.size() > 0) {
                                                        Map official_props = fd.getOfficialProperties();
                                                        HashMap update = new HashMap();
                                                        for (Map.Entry entry : pending_props.entrySet()) {
                                                            String pn = (String)entry.getKey();
                                                            Object pv = entry.getValue();
                                                            Object ov = official_props.get(pn);
                                                            if (ov == null) continue;
                                                            ArrayList l = new ArrayList();
                                                            update.put(pn, l);
                                                            l.add(ov);
                                                            l.add(pv);
                                                        }
                                                        if (update.size() > 0) {
                                                            String id = fd.getID();
                                                            feature_updates.put(id, update);
                                                        }
                                                    }
                                                    ++n2;
                                                }
                                                if (feature_updates.size() <= 0) continue;
                                                String key = licence.getKey();
                                                licence_updates.put(key, feature_updates);
                                            }
                                            if (licence_updates.size() > 0) {
                                                payload.put("updates", licence_updates);
                                            }
                                        }
                                        if (keys.size() > 0) {
                                            String error;
                                            Object plugin;
                                            Object pm;
                                            if (pids.size() > 0) {
                                                try {
                                                    HashMap info_map = new HashMap();
                                                    pm = FeatManPlugin.this.plugin_interface.getPluginManager();
                                                    for (String pid : pids) {
                                                        HashMap<String, String> info = new HashMap<String, String>();
                                                        info_map.put(pid, info);
                                                        plugin = pm.getPluginInterfaceByID(pid);
                                                        if (plugin == null) {
                                                            info.put("ver", "-1");
                                                            continue;
                                                        }
                                                        info.put("ver", plugin.getPluginVersion());
                                                        String plugin_info = plugin.getPluginconfig().getPluginStringParameter("plugin.info");
                                                        if (plugin_info == null || plugin_info.length() <= 0) continue;
                                                        info.put("info", plugin_info);
                                                    }
                                                    payload.put("info", info_map);
                                                }
                                                catch (Throwable e) {
                                                    Debug.out((Throwable)e);
                                                }
                                            }
                                            FeatManPlugin.this.logger.log("Updating licences");
                                            payload.put("cmd", "update");
                                            payload.put("keys", keys);
                                            payload.put("feature_types", new ArrayList(feature_types));
                                            response = RequestExecutor.this.execute(payload, this.consec_update_fails);
                                            pm = this;
                                            synchronized (pm) {
                                                Long max_retry;
                                                Long min_retry = (Long)response.get("min_secs");
                                                if (min_retry != null) {
                                                    this.min_update_period = min_retry.intValue() * 1000;
                                                }
                                                if ((max_retry = (Long)response.get("max_secs")) != null) {
                                                    this.max_update_period = max_retry.intValue() * 1000;
                                                }
                                            }
                                            final String message = FeatManPlugin.this.getString((Map<String, Object>)response, "message");
                                            if (!(message == null || FeatManPlugin.this.last_message != null && FeatManPlugin.this.last_message.equals(message))) {
                                                FeatManPlugin.this.last_message = message;
                                                try {
                                                    byte[] message_sig = (byte[])response.get("message_sig");
                                                    AEVerifier.verifyData((String)message, (byte[])message_sig);
                                                    new AEThread2("FeatManMsg", true){

                                                        public void run() {
                                                            UIManager ui_manager = StaticUtilities.getUIManager((long)120000L);
                                                            if (ui_manager != null) {
                                                                ui_manager.showMessageBox("featman.warning.title", "!" + message + "!", 1L);
                                                            }
                                                        }
                                                    }.start();
                                                }
                                                catch (Throwable message_sig) {
                                                    // empty catch block
                                                }
                                            }
                                            if ((error = FeatManPlugin.this.getString((Map<String, Object>)response, "error")) != null) {
                                                throw new Exception(error);
                                            }
                                            Map reply = (Map)response.get("rep");
                                            ArrayList<LicenceImpl> changed = new ArrayList<LicenceImpl>();
                                            plugin = all_licences;
                                            synchronized (plugin) {
                                                for (Map.Entry entry : ((Map)reply.get("licences")).entrySet()) {
                                                    String key = (String)entry.getKey();
                                                    LicenceImpl licence = new LicenceImpl((Map)entry.getValue());
                                                    LicenceImpl existing = (LicenceImpl)all_licences.get(key);
                                                    if (existing == null) {
                                                        Debug.out((String)("Licence " + key + " unknown"));
                                                        continue;
                                                    }
                                                    if (!existing.updateFrom(licence)) continue;
                                                    changed.add(existing.getCopy());
                                                }
                                                if (changed.size() > 0) {
                                                    Map map2 = all_licences;
                                                    synchronized (map2) {
                                                        RequestExecutor.this.saveConfig(state_file, all_licences);
                                                    }
                                                }
                                            }
                                            for (LicenceImpl licence : changed) {
                                                RequestExecutor.this.fireChanged(listener_dispatcher, listeners, licence);
                                            }
                                            FeatManPlugin.this.logger.log("Licence update successful");
                                        }
                                        response = this;
                                        synchronized (response) {
                                            this.consec_update_fails = 0;
                                            this.update_in_progress = false;
                                            break block70;
                                        }
                                    }
                                    catch (Throwable e) {
                                        FeatManPlugin.this.logger.log("Licence update failed", e);
                                        Object object3 = lock;
                                        synchronized (object3) {
                                            try {
                                                ++this.consec_update_fails;
                                                long back_off = this.min_update_period;
                                                int i = 0;
                                                while (i < this.consec_update_fails) {
                                                    if ((back_off *= 2L) > (long)this.max_update_period) {
                                                        back_off = this.max_update_period;
                                                        break;
                                                    }
                                                    ++i;
                                                }
                                                this.deferUpdate(back_off);
                                            }
                                            finally {
                                                this.update_in_progress = false;
                                            }
                                        }
                                    }
                                    object = lock;
                                }
                                catch (Throwable throwable) {
                                    Object object4 = lock;
                                    synchronized (object4) {
                                        if (this.update_in_progress) {
                                            Debug.out((String)"Something didn't clear update_in_progress!!!!");
                                            this.update_in_progress = false;
                                        }
                                    }
                                    throw throwable;
                                }
                                synchronized (object) {
                                    if (this.update_in_progress) {
                                        Debug.out((String)"Something didn't clear update_in_progress!!!!");
                                        this.update_in_progress = false;
                                    }
                                }
                            }
                            Object object = lock;
                            synchronized (object) {
                                if (this.update_in_progress) {
                                    Debug.out((String)"Something didn't clear update_in_progress!!!!");
                                    this.update_in_progress = false;
                                }
                            }
                        }

                        protected void deferUpdate(long millis) {
                            long target = SystemTime.getOffsetTime((long)(millis += 5000L));
                            FeatManPlugin.this.logger.log("Deferring licence update by " + millis / 1000L + " secs");
                            this.deferred_update_event = SimpleTimer.addEvent((String)"PM:defer", (long)target, (TimerEventPerformer)new TimerEventPerformer(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void perform(TimerEvent event) {
                                    Object object = lock;
                                    synchronized (object) {
                                        deferred_update_event = null;
                                    }
                                    update_dispatcher.dispatch(me);
                                }
                            });
                        }
                    };
                    timer = SimpleTimer.addPeriodicEvent((String)"feat", (long)86400000L, (TimerEventPerformer)new TimerEventPerformer(){

                        public void perform(TimerEvent event) {
                            update_dispatcher.dispatch(update);
                        }
                    });
                    if (all_licences.size() > 0) {
                        FeatManPlugin.access$8(RequestExecutor.access$9(RequestExecutor.this));
                    }
                    while (true) lbl-1000:
                    // 5 sources

                    {
                        block66: {
                            block64: {
                                block65: {
                                    RequestExecutor.access$4(RequestExecutor.this).reserve();
                                    var12_12 = RequestExecutor.access$5(RequestExecutor.this);
                                    synchronized (var12_12) {
                                        req = (Object[])RequestExecutor.access$5(RequestExecutor.this).remove(0);
                                    }
                                    cmd = (String)req[0];
                                    args = (Object[])req[1];
                                    req[1] = null;
                                    o_result /* !! */  = null;
                                    changed = false;
                                    went_async = false;
                                    if (!cmd.equals("unload")) break block64;
                                    unloaded[0] = true;
                                    timer.cancel();
                                    if (went_async) break block65;
                                    ((AESemaphore)req[2]).release();
                                }
                                return;
                            }
                            try {
                                try {
                                    if (cmd.equals("createLicences")) {
                                        FeatManPlugin.access$8(RequestExecutor.access$9(RequestExecutor.this));
                                        update_dispatcher.dispatch(new AERunnable(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public void runSupport() {
                                                block25: {
                                                    try {
                                                        try {
                                                            HashSet<String> feature_ids = new HashSet<String>(Arrays.asList((String[])args[0]));
                                                            HashSet<LicenceImpl> licences = new HashSet<LicenceImpl>();
                                                            boolean changed = false;
                                                            Map map = all_licences;
                                                            synchronized (map) {
                                                                for (LicenceImpl l : all_licences.values()) {
                                                                    FeatureDetailsImpl[] fds = l.getFeatures();
                                                                    FeatureDetailsImpl[] featureDetailsImplArray = fds;
                                                                    int n = fds.length;
                                                                    int n2 = 0;
                                                                    while (n2 < n) {
                                                                        FeatureDetailsImpl fd = featureDetailsImplArray[n2];
                                                                        if (feature_ids.remove(fd.getID())) {
                                                                            licences.add(l);
                                                                        }
                                                                        ++n2;
                                                                    }
                                                                }
                                                            }
                                                            if (feature_ids.size() > 0) {
                                                                HashMap<String, Object> payload = new HashMap<String, Object>();
                                                                payload.put("cmd", "create");
                                                                payload.put("feature_ids", new ArrayList<String>(feature_ids));
                                                                Map response = RequestExecutor.this.execute(payload, 0);
                                                                String error = FeatManPlugin.this.getString(response, "error");
                                                                if (error != null) {
                                                                    throw new Exception(error);
                                                                }
                                                                Map reply = (Map)response.get("rep");
                                                                List keys = (List)reply.get("keys");
                                                                Map map2 = all_licences;
                                                                synchronized (map2) {
                                                                    for (String key : keys) {
                                                                        if (all_licences.containsKey(key)) {
                                                                            licences.add((LicenceImpl)all_licences.get(key));
                                                                            continue;
                                                                        }
                                                                        changed = true;
                                                                        LicenceImpl licence = new LicenceImpl(key);
                                                                        all_licences.put(key, licence);
                                                                        licences.add(licence);
                                                                        RequestExecutor.this.fireAdded(listener_dispatcher, listeners, licence.getCopy());
                                                                    }
                                                                }
                                                            }
                                                            FeatureManager.Licence[] result = new FeatureManager.Licence[licences.size()];
                                                            int pos = 0;
                                                            for (LicenceImpl l : licences) {
                                                                result[pos++] = l.getCopy();
                                                            }
                                                            req[1] = result;
                                                            if (!changed) break block25;
                                                            Object object = lock;
                                                            synchronized (object) {
                                                                update_now[0] = true;
                                                            }
                                                            update_dispatcher.dispatch(update);
                                                            object = all_licences;
                                                            synchronized (object) {
                                                                RequestExecutor.this.saveConfig(state_file, all_licences);
                                                            }
                                                        }
                                                        catch (Throwable e) {
                                                            req[1] = new PluginException("Failed to create licence", e);
                                                            ((AESemaphore)req[2]).release();
                                                        }
                                                    }
                                                    finally {
                                                        ((AESemaphore)req[2]).release();
                                                    }
                                                }
                                            }
                                        });
                                        went_async = true;
                                    } else if (cmd.equals("addLicence")) {
                                        FeatManPlugin.access$8(RequestExecutor.access$9(RequestExecutor.this));
                                        licence_key = (String)args[0];
                                        var18_19 = all_licences;
                                        synchronized (var18_19) {
                                            existing = (LicenceImpl)all_licences.get(licence_key);
                                            if (existing == null) {
                                                licence = RequestExecutor.access$9(RequestExecutor.this).new LicenceImpl((String)licence_key);
                                                all_licences.put(licence_key, licence);
                                                o_result /* !! */  = LicenceImpl.access$3(licence);
                                                changed = true;
                                            } else {
                                                o_result /* !! */  = LicenceImpl.access$3(existing);
                                            }
                                        }
                                        if (changed) {
                                            RequestExecutor.access$6(RequestExecutor.this, listener_dispatcher, listeners, (LicenceImpl)o_result /* !! */ );
                                            update_dispatcher.dispatch(update);
                                        }
                                    } else {
                                        if (cmd.equals("getLicences")) {
                                            licence_key = all_licences;
                                            synchronized (licence_key) {
                                                licences /* !! */  = new FeatureManager.Licence[all_licences.size()];
                                                pos = 0;
                                                for (LicenceImpl l : all_licences.values()) {
                                                    licences /* !! */ [pos++] = LicenceImpl.access$3(l);
                                                }
                                                o_result /* !! */  = licences /* !! */ ;
                                            }
                                        }
                                        if (cmd.equals("getLicence")) {
                                            licence_key = (String)args[0];
                                            licences /* !! */  = all_licences;
                                            synchronized (licences /* !! */ ) {
                                                l = (LicenceImpl)all_licences.get(licence_key);
                                                o_result /* !! */  = l == null ? null : LicenceImpl.access$3((LicenceImpl)l);
                                            }
                                        }
                                        if (cmd.equals("removeLicence")) {
                                            licence_key = (String)args[0];
                                            l = all_licences;
                                            synchronized (l) {
                                                existing = (LicenceImpl)all_licences.remove(licence_key);
                                            }
                                            if (existing != null) {
                                                changed = true;
                                                RequestExecutor.access$7(RequestExecutor.this, listener_dispatcher, listeners, LicenceImpl.access$3(existing));
                                            }
                                        } else if (cmd.equals("setFeatureProperty")) {
                                            licence_key = (String)args[0];
                                            l = all_licences;
                                            synchronized (l) {
                                                licence = (LicenceImpl)all_licences.get(licence_key);
                                            }
                                            if (licence != null) {
                                                feature_id = (String)args[1];
                                                var24_26 = fds = licence.getFeatures();
                                                var23_25 = fds.length;
                                                var22_24 = 0;
                                                while (var22_24 < var23_25) {
                                                    fd = var24_26[var22_24];
                                                    if (fd.getID().equals(feature_id)) {
                                                        property_name = (String)args[2];
                                                        property_value = args[3];
                                                        changed = FeatureDetailsImpl.access$3(fd, property_name, property_value, true);
                                                    }
                                                    ++var22_24;
                                                }
                                            }
                                            if (changed) {
                                                update_dispatcher.dispatch(update);
                                            }
                                        } else if (cmd.equals("refreshLicences")) {
                                            licence_key = lock;
                                            synchronized (licence_key) {
                                                update_now[0] = true;
                                            }
                                            update_dispatcher.dispatch(update);
                                        } else if (cmd.equals("fireChanged")) {
                                            licence_key = (String)args[0];
                                            var19_20 = all_licences;
                                            synchronized (var19_20) {
                                                existing = (LicenceImpl)all_licences.get(licence_key);
                                            }
                                            if (existing != null) {
                                                RequestExecutor.access$3(RequestExecutor.this, listener_dispatcher, listeners, LicenceImpl.access$3(existing));
                                            }
                                        } else if (cmd.equals("addListener")) {
                                            listener = (FeatureManager.FeatureManagerListener)args[0];
                                            listeners.add(listener);
                                            for (LicenceImpl licence : all_licences.values()) {
                                                listener_dispatcher.dispatch(new AERunnable((FeatureManager.FeatureManagerListener)listener, licence){
                                                    private final /* synthetic */ FeatureManager.FeatureManagerListener val$listener;
                                                    private final /* synthetic */ LicenceImpl val$licence;
                                                    {
                                                        this.val$listener = featureManagerListener;
                                                        this.val$licence = licenceImpl;
                                                    }

                                                    public void runSupport() {
                                                        try {
                                                            this.val$listener.licenceAdded((FeatureManager.Licence)this.val$licence.getCopy());
                                                        }
                                                        catch (Throwable e) {
                                                            Debug.out((Throwable)e);
                                                        }
                                                    }
                                                });
                                            }
                                        } else if (cmd.equals("removeListener")) {
                                            listener = (FeatureManager.FeatureManagerListener)args[0];
                                            listeners.remove(listener);
                                        } else {
                                            Debug.out((String)("Unknown command " + cmd));
                                        }
                                    }
                                    if (went_async) break block66;
                                    req[1] = o_result /* !! */ ;
                                    if (!changed) break block66;
                                    listener = all_licences;
                                    synchronized (listener) {
                                        RequestExecutor.access$2(RequestExecutor.this, state_file, all_licences);
                                    }
                                }
                                catch (Throwable e) {
                                    Debug.out((Throwable)e);
                                    if (went_async) ** GOTO lbl-1000
                                    ((AESemaphore)req[2]).release();
                                }
                            }
                            catch (Throwable var27_29) {
                                if (!went_async) {
                                    ((AESemaphore)req[2]).release();
                                }
                                throw var27_29;
                            }
                        }
                        if (went_async) continue;
                        ((AESemaphore)req[2]).release();
                    }
                }
            };
            t.start();
            this.initialised = true;
        }

        private Map<String, Object> execute(Map<String, Object> payload, int retry_count) throws Exception {
            CryptoManager cman = CryptoManagerFactory.getSingleton();
            String azid = Base32.encode((byte[])cman.getSecureID());
            HashMap<String, Map<String, Object>> request = new HashMap<String, Map<String, Object>>();
            request.put("req", payload);
            payload.put("_azid", azid);
            payload.put("_time", new Long(SystemTime.getCurrentTime()));
            payload.put("_cc", VersionCheckClient.getSingleton().getCountryInfo().get("cc"));
            payload.put("_ver", FeatManPlugin.this.az_version);
            payload.put("_os", Constants.OSName);
            payload.put("_os_ver", System.getProperty("os.version"));
            if (retry_count > 0) {
                payload.put("_retry", new Long(retry_count));
            }
            if (FeatManPlugin.this.plugin_version != null) {
                payload.put("_pv", FeatManPlugin.this.plugin_version);
            }
            CryptoHandler crypto_handler = cman.getECCHandler();
            String pk = Base32.encode((byte[])crypto_handler.getPublicKey("featman"));
            byte[] request_bytes = BEncoder.encode(request);
            request_bytes = crypto_handler.encrypt(FeatManPlugin.this.server_pk, request_bytes, "featman");
            String request_str = Base32.encode((byte[])request_bytes);
            String other_params = "&pk=" + pk + "&ver=" + UrlUtils.encode((String)"5.4.0.1_CVS") + "&app=" + UrlUtils.encode((String)SystemProperties.getApplicationName()) + "&locale=" + UrlUtils.encode((String)MessageText.getCurrentLocale().toString());
            URL target = new URL(String.valueOf(SERVICE_URL) + "/client/cmd?request=" + request_str + other_params);
            AEProxyFactory.PluginProxy plugin_proxy = null;
            URL current_url = target;
            boolean ok = false;
            while (true) {
                try {
                    HttpURLConnection connection;
                    if (plugin_proxy == null) {
                        connection = (HttpURLConnection)current_url.openConnection();
                    } else {
                        connection = (HttpURLConnection)current_url.openConnection(plugin_proxy.getProxy());
                        connection.setRequestProperty("HOST", String.valueOf(plugin_proxy.getURLHostRewrite()) + (target.getPort() == -1 ? "" : ":" + target.getPort()));
                    }
                    connection.setConnectTimeout(30000);
                    InputStream is = connection.getInputStream();
                    byte[] reply_bytes = crypto_handler.decrypt(FeatManPlugin.this.server_pk, FileUtil.readInputStreamAsByteArray((InputStream)is), "featman");
                    Map response = BDecoder.decodeStrings((Map)BDecoder.decode((byte[])reply_bytes));
                    ok = true;
                    Map map = response;
                    return map;
                }
                catch (Exception e) {
                    if (plugin_proxy == null && (plugin_proxy = AEProxyFactory.getPluginProxy((String)"License server check", (URL)target)) != null) {
                        current_url = plugin_proxy.getURL();
                        continue;
                    }
                    throw e;
                }
                break;
            }
            finally {
                if (plugin_proxy != null) {
                    plugin_proxy.setOK(ok);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object runRequest(String command, Object[] args) {
            if (!this.initialised) {
                throw new RuntimeException("Not initialised");
            }
            AESemaphore sem = new AESemaphore("RequestExecutor");
            Object[] request = new Object[]{command, args, sem};
            List<Object[]> list = this.request_queue;
            synchronized (list) {
                this.request_queue.add(request);
            }
            this.request_sem.release();
            sem.reserve();
            return request[1];
        }

        private void fireAdded(AsyncDispatcher dispatcher, final List<FeatureManager.FeatureManagerListener> listeners, final LicenceImpl licence) {
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    for (FeatureManager.FeatureManagerListener listener : listeners) {
                        try {
                            listener.licenceAdded((FeatureManager.Licence)licence);
                        }
                        catch (Throwable e) {
                            Debug.out((Throwable)e);
                        }
                    }
                    FeatManPlugin.this.checkRequiredPlugins(licence);
                }
            });
        }

        private void fireChanged(AsyncDispatcher dispatcher, final List<FeatureManager.FeatureManagerListener> listeners, final LicenceImpl licence) {
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    for (FeatureManager.FeatureManagerListener listener : listeners) {
                        try {
                            listener.licenceChanged((FeatureManager.Licence)licence);
                        }
                        catch (Throwable e) {
                            Debug.out((Throwable)e);
                        }
                    }
                    FeatManPlugin.this.checkRequiredPlugins(licence);
                }
            });
        }

        private void fireRemoved(AsyncDispatcher dispatcher, final List<FeatureManager.FeatureManagerListener> listeners, final LicenceImpl licence) {
            dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    for (FeatureManager.FeatureManagerListener listener : listeners) {
                        try {
                            listener.licenceRemoved((FeatureManager.Licence)licence);
                        }
                        catch (Throwable e) {
                            Debug.out((Throwable)e);
                        }
                    }
                }
            });
        }

        private Map<String, LicenceImpl> loadConfig(File config_file) {
            HashMap<String, LicenceImpl> result = new HashMap<String, LicenceImpl>();
            try {
                Map map = FileUtil.readResilientFile((File)config_file);
                if (map != null && map.size() > 0) {
                    FeatManPlugin.this.logger.log("Loading configuration");
                    map = BDecoder.decodeStrings((Map)map);
                    List licences = (List)map.get("licences");
                    for (Map l : licences) {
                        String key = FeatManPlugin.this.normaliseKey((String)l.get("key"));
                        Map def = (Map)l.get("value");
                        result.put(key, new LicenceImpl(def));
                    }
                    FeatManPlugin.this.logger.log("Loaded " + result.size() + " licences");
                }
            }
            catch (Throwable e) {
                FeatManPlugin.this.logger.log("Load of configuration failed", e);
            }
            Set<String> shared_licences = this.readSharedLicenceKeys();
            for (String key : shared_licences) {
                if (result.containsKey(key)) continue;
                result.put(key, new LicenceImpl(key));
            }
            return result;
        }

        private void saveConfig(File config_file, Map<String, LicenceImpl> licences) {
            HashSet<String> required_shared = new HashSet<String>();
            try {
                HashMap map = new HashMap();
                ArrayList l = new ArrayList();
                map.put("licences", l);
                for (LicenceImpl licence : licences.values()) {
                    if (licence.getState() == 3) continue;
                    if (licence.usedByInstaller()) {
                        required_shared.add(licence.getKey());
                    }
                    HashMap<String, Object> m = new HashMap<String, Object>();
                    l.add(m);
                    m.put("key", licence.getKey());
                    m.put("value", licence.toMap());
                }
                FileUtil.writeResilientFile((File)config_file, map);
                FeatManPlugin.this.logger.log("Saved " + licences.size() + " licences");
            }
            catch (Throwable e) {
                FeatManPlugin.this.logger.log("Save of configuration failed", e);
            }
            try {
                Set<String> existing_shared = this.readSharedLicenceKeys();
                if (!existing_shared.equals(required_shared)) {
                    this.writeSharedLicenceKeys(required_shared);
                }
            }
            catch (Throwable e) {
                FeatManPlugin.this.logger.log("Save of shared licence list failed", e);
            }
        }

        private Set<String> readSharedLicenceKeys() {
            HashSet<String> existing_shared = new HashSet<String>();
            File shared_list = FileUtil.getApplicationFile((String)"licences.dat");
            if (shared_list.exists()) {
                try {
                    LineNumberReader lnr = new LineNumberReader(new FileReader(shared_list));
                    try {
                        String line;
                        while ((line = lnr.readLine()) != null) {
                            if ((line = line.trim()).length() <= 0) continue;
                            existing_shared.add(FeatManPlugin.this.normaliseKey(line));
                        }
                    }
                    finally {
                        lnr.close();
                    }
                }
                catch (Throwable e) {
                    FeatManPlugin.this.logger.log("Failed to read shared licence list from " + shared_list, e);
                }
            }
            return existing_shared;
        }

        private void writeSharedLicenceKeys(final Set<String> keys) {
            FeatManPlugin.this.async_dispatcher.dispatch(new AERunnable(){

                public void runSupport() {
                    File shared_list = FileUtil.getApplicationFile((String)"licences.dat");
                    String keys_for_file = "";
                    for (String key : keys) {
                        keys_for_file = String.valueOf(keys_for_file) + key + "\r\n";
                    }
                    if (FileUtil.canReallyWriteToAppDirectory()) {
                        if (!FileUtil.writeStringAsFile((File)shared_list, (String)keys_for_file)) {
                            FeatManPlugin.this.logger.log("Failed to write to " + shared_list);
                        }
                    } else {
                        int fails = FeatManPlugin.this.plugin_interface.getPluginconfig().getPluginIntParameter("share.write.error.count", 0);
                        if (fails >= 3) {
                            FeatManPlugin.this.logger.log("Not attempting to write shared licence info due to previous failures");
                            return;
                        }
                        try {
                            UpdateInstaller installer = FeatManPlugin.this.plugin_interface.getUpdateManager().createInstaller();
                            UIManager ui_manager = StaticUtilities.getUIManager((long)120000L);
                            long res = ui_manager.showMessageBox("featman.sharewrite.title", "featman.sharewrite.desc", 1L);
                            if (res != 1L) {
                                installer.destroy();
                                return;
                            }
                            installer.addResource("licences", (InputStream)new ByteArrayInputStream(keys_for_file.getBytes("UTF-8")));
                            installer.addMoveAction("licences", shared_list.getAbsolutePath());
                            final AESemaphore sem = new AESemaphore("licence-write");
                            final UpdateException[] error = new UpdateException[1];
                            installer.installNow(new UpdateInstallerListener(){

                                public void reportProgress(String str) {
                                }

                                public void complete() {
                                    sem.release();
                                }

                                public void failed(UpdateException e) {
                                    error[0] = e;
                                    sem.release();
                                }
                            });
                            sem.reserve();
                            if (error[0] != null) {
                                throw error[0];
                            }
                            FeatManPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("share.write.error.count", 0);
                        }
                        catch (Throwable e) {
                            FeatManPlugin.this.logger.log("Failed to write to " + shared_list + " via update");
                            FeatManPlugin.this.plugin_interface.getPluginconfig().setPluginParameter("share.write.error.count", fails + 1);
                        }
                    }
                }
            });
        }

        static /* synthetic */ Map access$0(RequestExecutor requestExecutor, File file) {
            return requestExecutor.loadConfig(file);
        }

        static /* synthetic */ AESemaphore access$4(RequestExecutor requestExecutor) {
            return requestExecutor.request_sem;
        }

        static /* synthetic */ List access$5(RequestExecutor requestExecutor) {
            return requestExecutor.request_queue;
        }

        static /* synthetic */ void access$7(RequestExecutor requestExecutor, AsyncDispatcher asyncDispatcher, List list, LicenceImpl licenceImpl) {
            requestExecutor.fireRemoved(asyncDispatcher, list, licenceImpl);
        }
    }
}

