/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.mozilla;

import java.util.HashMap;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.nsID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IIDStore {
    static HashMap<Class<?>, nsID[]> IIDs = new HashMap();

    public static nsID GetIID(Class<?> clazz) {
        return IIDStore.GetIID(clazz, MozillaVersion.GetCurrentVersion());
    }

    public static nsID GetIID(Class<?> clazz, int version) {
        return IIDStore.GetIID(clazz, version, false);
    }

    public static nsID GetIID(Class<?> clazz, int version, boolean exact) {
        if (version <= MozillaVersion.GetLatestVersion()) {
            nsID[] table = IIDs.get(clazz);
            if (table == null) {
                try {
                    Class<Number> argType = C.PTR_SIZEOF == 4 ? Integer.TYPE : Long.TYPE;
                    clazz.getConstructor(argType).newInstance(0);
                    table = IIDs.get(clazz);
                }
                catch (Exception argType) {
                    // empty catch block
                }
            }
            if (table != null) {
                if (exact) {
                    return table[version];
                }
                int defaultIIDIndex = MozillaVersion.GetLatestVersion() + 1;
                if (version == MozillaVersion.GetCurrentVersion() && table[defaultIIDIndex] != null) {
                    return table[defaultIIDIndex];
                }
                for (int i = version; 0 <= i; --i) {
                    if (table[i] == null) continue;
                    if (version == MozillaVersion.GetCurrentVersion()) {
                        table[defaultIIDIndex] = table[i];
                    }
                    return table[i];
                }
            }
        }
        return null;
    }

    protected static void RegisterIID(Class<?> clazz, int version, nsID iid) {
        if (version <= MozillaVersion.GetLatestVersion()) {
            nsID[] table = IIDs.get(clazz);
            if (table == null) {
                table = new nsID[MozillaVersion.GetLatestVersion() + 2];
                IIDs.put(clazz, table);
            }
            table[version] = iid;
        }
    }
}

