/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GdkEventExpose;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkGCValues;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkFixed;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Scrollable;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Composite
extends Scrollable {
    public long embeddedHandle;
    long imHandle;
    long socketHandle;
    Layout layout;
    Control[] tabList;
    int layoutCount;
    int backgroundMode;
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";

    Composite() {
    }

    public Composite(Composite parent, int style) {
        super(parent, Composite.checkStyle(style));
    }

    static int checkStyle(int style) {
        if (OS.INIT_CAIRO) {
            style &= 0xFFFBFFFF;
        }
        return style &= 0xBFFFFFFF;
    }

    Control[] _getChildren() {
        long parentHandle = this.parentingHandle();
        long list = OS.gtk_container_get_children(parentHandle);
        if (list == 0L) {
            return new Control[0];
        }
        int count = OS.g_list_length(list);
        Control[] children = new Control[count];
        int i = 0;
        long temp = list;
        while (temp != 0L) {
            Widget widget;
            long handle = OS.g_list_data(temp);
            if (handle != 0L && (widget = this.display.getWidget(handle)) != null && widget != this && widget instanceof Control) {
                children[i++] = (Control)widget;
            }
            temp = OS.g_list_next(temp);
        }
        OS.g_list_free(list);
        if (i == count) {
            return children;
        }
        Control[] newChildren = new Control[i];
        System.arraycopy(children, 0, newChildren, 0, i);
        return newChildren;
    }

    Control[] _getTabList() {
        if (this.tabList == null) {
            return this.tabList;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            ++count;
        }
        if (count == this.tabList.length) {
            return this.tabList;
        }
        Control[] newList = new Control[count];
        int index = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i].isDisposed()) continue;
            newList[index++] = this.tabList[i];
        }
        this.tabList = newList;
        return this.tabList;
    }

    public void changed(Control[] changed) {
        int i;
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        for (i = 0; i < changed.length; ++i) {
            Control control = changed[i];
            if (control == null) {
                this.error(5);
            }
            if (control.isDisposed()) {
                this.error(5);
            }
            boolean ancestor = false;
            Composite composite = control.parent;
            while (composite != null) {
                boolean bl = ancestor = composite == this;
                if (ancestor) break;
                composite = composite.parent;
            }
            if (ancestor) continue;
            this.error(32);
        }
        for (i = 0; i < changed.length; ++i) {
            Control child = changed[i];
            Composite composite = child.parent;
            while (child != this) {
                if (composite.layout == null || !composite.layout.flushCache(child)) {
                    composite.state |= 0x40000;
                }
                child = composite;
                composite = child.parent;
            }
        }
    }

    void checkBuffered() {
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            return;
        }
        super.checkBuffered();
    }

    protected void checkSubclass() {
    }

    long childStyle() {
        if (this.scrolledHandle != 0L) {
            return 0L;
        }
        return super.childStyle();
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point size;
        this.checkWidget();
        this.display.runSkin();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        if (this.layout != null) {
            if (wHint == -1 || hHint == -1) {
                size = this.layout.computeSize(this, wHint, hHint, changed |= (this.state & 0x40000) != 0);
                this.state &= 0xFFFBFFFF;
            } else {
                size = new Point(wHint, hHint);
            }
        } else {
            size = this.minimumSize(wHint, hHint, changed);
            if (size.x == 0) {
                size.x = 64;
            }
            if (size.y == 0) {
                size.y = 64;
            }
        }
        if (wHint != -1) {
            size.x = wHint;
        }
        if (hHint != -1) {
            size.y = hHint;
        }
        Rectangle trim = this.computeTrim(0, 0, size.x, size.y);
        return new Point(trim.width, trim.height);
    }

    Widget[] computeTabList() {
        Widget[] result = super.computeTabList();
        if (result.length == 0) {
            return result;
        }
        Control[] list = this.tabList != null ? this._getTabList() : this._getChildren();
        for (int i = 0; i < list.length; ++i) {
            Control child = list[i];
            Widget[] childList = child.computeTabList();
            if (childList.length == 0) continue;
            Widget[] newResult = new Widget[result.length + childList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(childList, 0, newResult, result.length, childList.length);
            result = newResult;
        }
        return result;
    }

    void createHandle(int index) {
        boolean scrolled;
        this.state |= 0x200000A;
        boolean bl = scrolled = (this.style & 0x300) != 0;
        if (!scrolled) {
            this.state |= 0x10000;
        }
        this.createHandle(index, true, scrolled || (this.style & 0x800) != 0);
    }

    int applyThemeBackground() {
        return this.backgroundAlpha == 0 || (this.style & 0x300) == 0 ? 1 : 0;
    }

    void createHandle(int index, boolean fixed, boolean scrolled) {
        if (scrolled) {
            long hadj;
            long vadj;
            if (fixed) {
                this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
                if (this.fixedHandle == 0L) {
                    this.error(2);
                }
                OS.gtk_widget_set_has_window(this.fixedHandle, true);
            }
            if ((vadj = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            if ((hadj = OS.gtk_adjustment_new(0.0, 0.0, 100.0, 1.0, 10.0, 10.0)) == 0L) {
                this.error(2);
            }
            this.scrolledHandle = OS.gtk_scrolled_window_new(hadj, vadj);
            if (this.scrolledHandle == 0L) {
                this.error(2);
            }
        }
        this.handle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_widget_set_has_window(this.handle, true);
        OS.gtk_widget_set_can_focus(this.handle, true);
        if ((this.style & 0x1000000) == 0 && (this.state & 2) != 0 && this.display.getData(NO_INPUT_METHOD) == null) {
            this.imHandle = OS.gtk_im_multicontext_new();
            if (this.imHandle == 0L) {
                this.error(2);
            }
        }
        if (scrolled) {
            if (fixed) {
                OS.gtk_container_add(this.fixedHandle, this.scrolledHandle);
            }
            boolean warnings = this.display.getWarnings();
            this.display.setWarnings(false);
            OS.gtk_container_add(this.scrolledHandle, this.handle);
            this.display.setWarnings(warnings);
            int hsp = (this.style & 0x100) != 0 ? 0 : 2;
            int vsp = (this.style & 0x200) != 0 ? 0 : 2;
            OS.gtk_scrolled_window_set_policy(this.scrolledHandle, hsp, vsp);
            if (this.hasBorder()) {
                OS.gtk_scrolled_window_set_shadow_type(this.scrolledHandle, 3);
            }
        }
        if ((this.style & 0x1000000) != 0) {
            this.socketHandle = OS.gtk_socket_new();
            if (this.socketHandle == 0L) {
                this.error(2);
            }
            OS.gtk_container_add(this.handle, this.socketHandle);
        }
        if ((this.style & 0x100000) != 0 && (this.style & 0x4000000) == 0) {
            OS.gtk_widget_set_redraw_on_allocate(this.handle, false);
        }
        if ((this.style & 0x20000000) == 0 && (this.style & 0x40000) != 0) {
            OS.gtk_widget_set_double_buffered(this.handle, false);
        }
    }

    void deregister() {
        super.deregister();
        if (this.socketHandle != 0L) {
            this.display.removeWidget(this.socketHandle);
        }
    }

    public void drawBackground(GC gc, int x, int y, int width, int height, int offsetX, int offsetY) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            GCData data = gc.getGCData();
            long cairo = data.cairo;
            if (cairo != 0L) {
                Cairo.cairo_save(cairo);
                if (control.backgroundImage != null) {
                    Point pt = this.display.map(this, control, 0, 0);
                    Cairo.cairo_translate(cairo, -pt.x - offsetX, -pt.y - offsetY);
                    x += pt.x + offsetX;
                    y += pt.y + offsetY;
                    long surface = control.backgroundImage.surface;
                    if (surface == 0L) {
                        long drawable = control.backgroundImage.pixmap;
                        int[] w = new int[1];
                        int[] h = new int[1];
                        this.gdk_pixmap_get_size(drawable, w, h);
                        if (OS.isX11()) {
                            long xDisplay = OS.gdk_x11_display_get_xdisplay(OS.gdk_display_get_default());
                            long xVisual = OS.gdk_x11_visual_get_xvisual(OS.gdk_visual_get_system());
                            long xDrawable = OS.GDK_PIXMAP_XID(drawable);
                            surface = Cairo.cairo_xlib_surface_create(xDisplay, xDrawable, xVisual, w[0], h[0]);
                        } else {
                            surface = Cairo.cairo_image_surface_create(0, w[0], h[0]);
                        }
                        if (surface == 0L) {
                            this.error(2);
                        }
                    } else {
                        Cairo.cairo_surface_reference(surface);
                    }
                    long pattern = Cairo.cairo_pattern_create_for_surface(surface);
                    if (pattern == 0L) {
                        this.error(2);
                    }
                    Cairo.cairo_pattern_set_extend(pattern, 1);
                    if ((data.style & 0x8000000) != 0) {
                        double[] matrix = new double[]{-1.0, 0.0, 0.0, 1.0, 0.0, 0.0};
                        Cairo.cairo_pattern_set_matrix(pattern, matrix);
                    }
                    Cairo.cairo_set_source(cairo, pattern);
                    Cairo.cairo_surface_destroy(surface);
                    Cairo.cairo_pattern_destroy(pattern);
                } else {
                    GdkColor color = control.getBackgroundColor();
                    Cairo.cairo_set_source_rgba(cairo, (float)(color.red & 0xFFFF) / 65535.0f, (float)(color.green & 0xFFFF) / 65535.0f, (float)(color.blue & 0xFFFF) / 65535.0f, (float)data.alpha / 255.0f);
                }
                Cairo.cairo_rectangle(cairo, x, y, width, height);
                Cairo.cairo_fill(cairo);
                Cairo.cairo_restore(cairo);
            } else {
                long gdkGC = gc.handle;
                GdkGCValues values = new GdkGCValues();
                OS.gdk_gc_get_values(gdkGC, values);
                if (control.backgroundImage != null) {
                    Point pt = this.display.map(this, control, 0, 0);
                    OS.gdk_gc_set_fill(gdkGC, 1);
                    OS.gdk_gc_set_ts_origin(gdkGC, -pt.x - offsetX, -pt.y - offsetY);
                    OS.gdk_gc_set_tile(gdkGC, control.backgroundImage.pixmap);
                    OS.gdk_draw_rectangle(data.drawable, gdkGC, 1, x, y, width, height);
                    OS.gdk_gc_set_fill(gdkGC, values.fill);
                    OS.gdk_gc_set_ts_origin(gdkGC, values.ts_x_origin, values.ts_y_origin);
                } else {
                    GdkColor color = control.getBackgroundColor();
                    OS.gdk_gc_set_foreground(gdkGC, color);
                    OS.gdk_draw_rectangle(data.drawable, gdkGC, 1, x, y, width, height);
                    color.pixel = values.foreground_pixel;
                    OS.gdk_gc_set_foreground(gdkGC, color);
                }
            }
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    void enableWidget(boolean enabled) {
        if ((this.state & 2) != 0) {
            return;
        }
        super.enableWidget(enabled);
    }

    Composite findDeferredControl() {
        return this.layoutCount > 0 ? this : this.parent.findDeferredControl();
    }

    Menu[] findMenus(Control control) {
        if (control == this) {
            return new Menu[0];
        }
        Menu[] result = super.findMenus(control);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            Menu[] menuList = child.findMenus(control);
            if (menuList.length == 0) continue;
            Menu[] newResult = new Menu[result.length + menuList.length];
            System.arraycopy(result, 0, newResult, 0, result.length);
            System.arraycopy(menuList, 0, newResult, result.length, menuList.length);
            result = newResult;
        }
        return result;
    }

    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        }
    }

    void fixModal(long group, long modalGroup) {
        Control[] controls = this._getChildren();
        for (int i = 0; i < controls.length; ++i) {
            controls[i].fixModal(group, modalGroup);
        }
    }

    void fixStyle() {
        super.fixStyle();
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].fixStyle();
        }
    }

    void fixTabList(Control control) {
        if (this.tabList == null) {
            return;
        }
        int count = 0;
        for (int i = 0; i < this.tabList.length; ++i) {
            if (this.tabList[i] != control) continue;
            ++count;
        }
        if (count == 0) {
            return;
        }
        Control[] newList = null;
        int length = this.tabList.length - count;
        if (length != 0) {
            newList = new Control[length];
            int index = 0;
            for (int i = 0; i < this.tabList.length; ++i) {
                if (this.tabList[i] == control) continue;
                newList[index++] = this.tabList[i];
            }
        }
        this.tabList = newList;
    }

    void fixZOrder() {
        if ((this.state & 2) != 0) {
            return;
        }
        long parentHandle = this.parentingHandle();
        long parentWindow = this.gtk_widget_get_window(parentHandle);
        if (parentWindow == 0L) {
            return;
        }
        long[] userData = new long[1];
        long windowList = OS.gdk_window_get_children(parentWindow);
        if (windowList != 0L) {
            long windows = windowList;
            while (windows != 0L) {
                long window = OS.g_list_data(windows);
                if (window != this.redrawWindow) {
                    OS.gdk_window_get_user_data(window, userData);
                    if (userData[0] == 0L || OS.G_OBJECT_TYPE(userData[0]) != this.display.gtk_fixed_get_type()) {
                        OS.gdk_window_lower(window);
                    }
                }
                windows = OS.g_list_next(windows);
            }
            OS.g_list_free(windowList);
        }
    }

    long focusHandle() {
        if (this.socketHandle != 0L) {
            return this.socketHandle;
        }
        return super.focusHandle();
    }

    boolean forceFocus(long focusHandle) {
        if (this.socketHandle != 0L) {
            OS.gtk_widget_set_can_focus(focusHandle, true);
        }
        boolean result = super.forceFocus(focusHandle);
        if (this.socketHandle != 0L) {
            OS.gtk_widget_set_can_focus(focusHandle, false);
        }
        return result;
    }

    public int getBackgroundMode() {
        this.checkWidget();
        return this.backgroundMode;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return this._getChildren();
    }

    int getChildrenCount() {
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int count = OS.g_list_length(list);
        OS.g_list_free(list);
        return count;
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if ((this.state & 2) != 0) {
            if ((this.state & 0x200) != 0 && (this.state & 0x400) != 0) {
                return new Rectangle(0, 0, 0, 0);
            }
            this.forceResize();
            long clientHandle = this.clientHandle();
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(clientHandle, allocation);
            int width = (this.state & 0x200) != 0 ? 0 : allocation.width;
            int height = (this.state & 0x400) != 0 ? 0 : allocation.height;
            return new Rectangle(0, 0, width, height);
        }
        return super.getClientArea();
    }

    public Layout getLayout() {
        this.checkWidget();
        return this.layout;
    }

    public boolean getLayoutDeferred() {
        this.checkWidget();
        return this.layoutCount > 0;
    }

    public Control[] getTabList() {
        this.checkWidget();
        Control[] tabList = this._getTabList();
        if (tabList == null) {
            int count = 0;
            Control[] list = this._getChildren();
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                ++count;
            }
            tabList = new Control[count];
            int index = 0;
            for (int i = 0; i < list.length; ++i) {
                if (!list[i].isTabGroup()) continue;
                tabList[index++] = list[i];
            }
        }
        return tabList;
    }

    long gtk_button_press_event(long widget, long event) {
        long result = super.gtk_button_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 2) != 0 && (this.style & 0x80000) == 0 && this.hooksKeys()) {
            GdkEventButton gdkEvent = new GdkEventButton();
            OS.memmove(gdkEvent, event, (long)GdkEventButton.sizeof);
            if (gdkEvent.button == 1 && this.getChildrenCount() == 0) {
                this.setFocus();
            }
        }
        return result;
    }

    long gtk_expose_event(long widget, long eventPtr) {
        if ((this.state & 0x40) != 0) {
            return 0L;
        }
        if ((this.state & 2) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if ((this.style & 0x200000) == 0) {
            return super.gtk_expose_event(widget, eventPtr);
        }
        if (!this.hooksPaint()) {
            return 0L;
        }
        GdkEventExpose gdkEvent = new GdkEventExpose();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventExpose.sizeof);
        long[] rectangles = new long[1];
        int[] n_rectangles = new int[1];
        OS.gdk_region_get_rectangles(gdkEvent.region, rectangles, n_rectangles);
        GdkRectangle rect = new GdkRectangle();
        for (int i = 0; i < n_rectangles[0]; ++i) {
            Event event = new Event();
            OS.memmove(rect, rectangles[0] + (long)(i * GdkRectangle.sizeof), (long)GdkRectangle.sizeof);
            event.x = rect.x;
            event.y = rect.y;
            event.width = rect.width;
            event.height = rect.height;
            if ((this.style & 0x8000000) != 0) {
                event.x = this.getClientWidth() - event.width - event.x;
            }
            long damageRgn = OS.gdk_region_new();
            OS.gdk_region_union_with_rect(damageRgn, rect);
            GCData data = new GCData();
            data.damageRgn = damageRgn;
            GC gc = event.gc = GC.gtk_new(this, data);
            this.sendEvent(9, event);
            gc.dispose();
            OS.gdk_region_destroy(damageRgn);
            event.gc = null;
        }
        OS.g_free(rectangles[0]);
        return 0L;
    }

    long gtk_key_press_event(long widget, long event) {
        long result = super.gtk_key_press_event(widget, event);
        if (result != 0L) {
            return result;
        }
        if ((this.state & 2) != 0 && this.socketHandle == 0L) {
            GdkEventKey keyEvent = new GdkEventKey();
            OS.memmove(keyEvent, event, (long)GdkEventKey.sizeof);
            int key = keyEvent.keyval;
            switch (key) {
                case 65293: 
                case 65421: {
                    return 1L;
                }
            }
        }
        return result;
    }

    long gtk_focus(long widget, long directionType) {
        if (widget == this.socketHandle) {
            return 0L;
        }
        return super.gtk_focus(widget, directionType);
    }

    long gtk_focus_in_event(long widget, long event) {
        long result = super.gtk_focus_in_event(widget, event);
        return (this.state & 2) != 0 ? 1L : result;
    }

    long gtk_focus_out_event(long widget, long event) {
        long result = super.gtk_focus_out_event(widget, event);
        return (this.state & 2) != 0 ? 1L : result;
    }

    long gtk_map(long widget) {
        this.fixZOrder();
        return 0L;
    }

    long gtk_realize(long widget) {
        long window;
        long result = super.gtk_realize(widget);
        if ((this.style & 0x40000) != 0 && (window = this.gtk_widget_get_window(this.paintHandle())) != 0L) {
            if (OS.GTK3) {
                OS.gdk_window_set_background_pattern(window, 0L);
            } else {
                OS.gdk_window_set_back_pixmap(window, 0L, false);
            }
        }
        if (this.socketHandle != 0L) {
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
        return result;
    }

    long gtk_scroll_child(long widget, long scrollType, long horizontal) {
        OS.g_signal_stop_emission_by_name(widget, OS.scroll_child);
        return 1L;
    }

    long gtk_style_set(long widget, long previousStyle) {
        long window;
        long result = super.gtk_style_set(widget, previousStyle);
        if ((this.style & 0x40000) != 0 && (window = this.gtk_widget_get_window(this.paintHandle())) != 0L) {
            OS.gdk_window_set_back_pixmap(window, 0L, false);
        }
        return result;
    }

    boolean hasBorder() {
        return (this.style & 0x800) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        if ((this.state & 2) != 0) {
            OS.gtk_widget_add_events(this.handle, 8);
            if (this.scrolledHandle != 0L) {
                OS.g_signal_connect_closure(this.scrolledHandle, OS.scroll_child, this.display.getClosure(42), false);
            }
        }
    }

    boolean hooksKeys() {
        return this.hooks(1) || this.hooks(2);
    }

    long imHandle() {
        return this.imHandle;
    }

    public boolean isLayoutDeferred() {
        this.checkWidget();
        return this.findDeferredControl() != null;
    }

    boolean isTabGroup() {
        if ((this.state & 2) != 0) {
            return true;
        }
        return super.isTabGroup();
    }

    public void layout() {
        this.checkWidget();
        this.layout(true);
    }

    public void layout(boolean changed) {
        this.checkWidget();
        if (this.layout == null) {
            return;
        }
        this.layout(changed, false);
    }

    public void layout(boolean changed, boolean all) {
        this.checkWidget();
        if (this.layout == null && !all) {
            return;
        }
        this.markLayout(changed, all);
        this.updateLayout(all);
    }

    public void layout(Control[] changed) {
        this.checkWidget();
        if (changed == null) {
            this.error(5);
        }
        this.layout(changed, 0);
    }

    public void layout(Control[] changed, int flags) {
        this.checkWidget();
        if (changed != null) {
            int i;
            for (int i2 = 0; i2 < changed.length; ++i2) {
                Control control = changed[i2];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                boolean ancestor = false;
                Composite composite = control.parent;
                while (composite != null) {
                    boolean bl = ancestor = composite == this;
                    if (ancestor) break;
                    composite = composite.parent;
                }
                if (ancestor) continue;
                this.error(32);
            }
            int updateCount = 0;
            Composite[] update = new Composite[16];
            for (i = 0; i < changed.length; ++i) {
                Control child = changed[i];
                Composite composite = child.parent;
                while (child != this) {
                    if (composite.layout != null) {
                        composite.state |= 0x20000;
                        if (!composite.layout.flushCache(child)) {
                            composite.state |= 0x40000;
                        }
                    }
                    if (updateCount == update.length) {
                        Composite[] newUpdate = new Composite[update.length + 16];
                        System.arraycopy(update, 0, newUpdate, 0, update.length);
                        update = newUpdate;
                    }
                    int n = updateCount++;
                    Composite composite2 = composite;
                    update[n] = composite2;
                    child = composite2;
                    composite = child.parent;
                }
            }
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            for (i = updateCount - 1; i >= 0; --i) {
                update[i].updateLayout(false);
            }
        } else {
            if (this.layout == null && (flags & 1) == 0) {
                return;
            }
            this.markLayout((flags & 2) != 0, (flags & 1) != 0);
            if ((flags & 4) != 0) {
                this.setLayoutDeferred(true);
                this.display.addLayoutDeferred(this);
            }
            this.updateLayout((flags & 1) != 0);
        }
    }

    void markLayout(boolean changed, boolean all) {
        if (this.layout != null) {
            this.state |= 0x20000;
            if (changed) {
                this.state |= 0x40000;
            }
        }
        if (all) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].markLayout(changed, all);
            }
        }
    }

    void moveAbove(long child, long sibling) {
        if (child == sibling) {
            return;
        }
        long parentHandle = this.parentingHandle();
        if (OS.GTK3) {
            OS.swt_fixed_restack(parentHandle, child, sibling, true);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        long children = fixed.children;
        if (children == 0L) {
            return;
        }
        long[] data = new long[1];
        long[] widget = new long[1];
        long childData = 0L;
        long childLink = 0L;
        long siblingLink = 0L;
        long temp = children;
        while (temp != 0L) {
            OS.memmove(data, temp, (long)OS.PTR_SIZEOF);
            OS.memmove(widget, data[0], (long)OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0L && (sibling == 0L || siblingLink != 0L)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0L || OS.g_list_previous(siblingLink) == 0L) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_prepend(children, childData);
        } else {
            temp = OS.g_list_previous(siblingLink);
            OS.g_list_set_previous(childLink, temp);
            OS.g_list_set_next(temp, childLink);
            OS.g_list_set_next(childLink, siblingLink);
            OS.g_list_set_previous(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    void moveBelow(long child, long sibling) {
        if (child == sibling) {
            return;
        }
        long parentHandle = this.parentingHandle();
        if (sibling == 0L && parentHandle == this.fixedHandle) {
            this.moveAbove(child, this.scrolledHandle != 0L ? this.scrolledHandle : this.handle);
            return;
        }
        if (OS.GTK3) {
            OS.swt_fixed_restack(parentHandle, child, sibling, false);
            return;
        }
        GtkFixed fixed = new GtkFixed();
        OS.memmove(fixed, parentHandle);
        long children = fixed.children;
        if (children == 0L) {
            return;
        }
        long[] data = new long[1];
        long[] widget = new long[1];
        long childData = 0L;
        long childLink = 0L;
        long siblingLink = 0L;
        long temp = children;
        while (temp != 0L) {
            OS.memmove(data, temp, (long)OS.PTR_SIZEOF);
            OS.memmove(widget, data[0], (long)OS.PTR_SIZEOF);
            if (child == widget[0]) {
                childLink = temp;
                childData = data[0];
            } else if (sibling == widget[0]) {
                siblingLink = temp;
            }
            if (childData != 0L && (sibling == 0L || siblingLink != 0L)) break;
            temp = OS.g_list_next(temp);
        }
        children = OS.g_list_remove_link(children, childLink);
        if (siblingLink == 0L || OS.g_list_next(siblingLink) == 0L) {
            OS.g_list_free_1(childLink);
            children = OS.g_list_append(children, childData);
        } else {
            temp = OS.g_list_next(siblingLink);
            OS.g_list_set_next(childLink, temp);
            OS.g_list_set_previous(temp, childLink);
            OS.g_list_set_previous(childLink, siblingLink);
            OS.g_list_set_next(siblingLink, childLink);
        }
        fixed.children = children;
        OS.memmove(parentHandle, fixed);
    }

    void moveChildren(int oldWidth) {
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            int controlWidth;
            Control child = children[i];
            long topHandle = child.topHandle();
            GtkAllocation allocation = new GtkAllocation();
            OS.gtk_widget_get_allocation(topHandle, allocation);
            int x = allocation.x;
            int y = allocation.y;
            int n = controlWidth = (child.state & 0x200) != 0 ? 0 : allocation.width;
            if (oldWidth > 0) {
                x = oldWidth - controlWidth - x;
            }
            int clientWidth = this.getClientWidth();
            x = clientWidth - controlWidth - x;
            if (child.enableWindow != 0L) {
                OS.gdk_window_move(child.enableWindow, x, y);
            }
            child.moveHandle(x, y);
            GtkRequisition requisition = new GtkRequisition();
            this.gtk_widget_size_request(topHandle, requisition);
            allocation.x = x;
            allocation.y = y;
            OS.gtk_widget_size_allocate(topHandle, allocation);
            Control control = child.findBackgroundControl();
            if (control == null || control.backgroundImage == null || !child.isVisible()) continue;
            child.redrawWidget(0, 0, 0, 0, true, true, true);
        }
    }

    Point minimumSize(int wHint, int hHint, boolean changed) {
        Control[] children = this._getChildren();
        Rectangle clientArea = this.getClientArea();
        int width = 0;
        int height = 0;
        for (int i = 0; i < children.length; ++i) {
            Rectangle rect = children[i].getBounds();
            width = Math.max(width, rect.x - clientArea.x + rect.width);
            height = Math.max(height, rect.y - clientArea.y + rect.height);
        }
        return new Point(width, height);
    }

    long parentingHandle() {
        if ((this.state & 2) != 0) {
            return this.handle;
        }
        return this.fixedHandle != 0L ? this.fixedHandle : this.handle;
    }

    void printWidget(GC gc, long drawable, int depth, int x, int y) {
        Region oldClip = new Region(gc.getDevice());
        Region newClip = new Region(gc.getDevice());
        gc.getClipping(oldClip);
        Rectangle rect = this.getBounds();
        newClip.add(oldClip);
        newClip.intersect(x, y, rect.width, rect.height);
        gc.setClipping(newClip);
        super.printWidget(gc, drawable, depth, x, y);
        Rectangle clientRect = this.getClientArea();
        Point pt = this.display.map(this, this.parent, clientRect.x, clientRect.y);
        clientRect.x = x + pt.x - rect.x;
        clientRect.y = y + pt.y - rect.y;
        newClip.intersect(clientRect);
        gc.setClipping(newClip);
        Control[] children = this._getChildren();
        for (int i = children.length - 1; i >= 0; --i) {
            Control child = children[i];
            if (!child.getVisible()) continue;
            Point location = child.getLocation();
            child.printWidget(gc, drawable, depth, x + location.x, y + location.y);
        }
        gc.setClipping(oldClip);
        oldClip.dispose();
        newClip.dispose();
    }

    void redrawChildren() {
        super.redrawChildren();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if ((child.state & 0x8000) == 0) continue;
            child.redrawWidget(0, 0, 0, 0, true, false, true);
            child.redrawChildren();
        }
    }

    void register() {
        super.register();
        if (this.socketHandle != 0L) {
            this.display.addWidget(this.socketHandle, this);
        }
    }

    void releaseChildren(boolean destroy) {
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child == null || child.isDisposed()) continue;
            child.release(false);
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.embeddedHandle = 0L;
        this.socketHandle = 0L;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imHandle != 0L) {
            OS.g_object_unref(this.imHandle);
        }
        this.imHandle = 0L;
        this.layout = null;
        this.tabList = null;
    }

    void removeControl(Control control) {
        this.fixTabList(control);
    }

    void reskinChildren(int flags) {
        super.reskinChildren(flags);
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child == null) continue;
            child.reskin(flags);
        }
    }

    void resizeHandle(int width, int height) {
        super.resizeHandle(width, height);
        if (this.socketHandle != 0L) {
            if (OS.GTK3) {
                OS.swt_fixed_resize(this.handle, this.socketHandle, width, height);
            } else {
                OS.gtk_widget_set_size_request(this.socketHandle, width, height);
            }
        }
    }

    public void setBackgroundMode(int mode) {
        this.checkWidget();
        this.backgroundMode = mode;
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].updateBackgroundMode();
        }
    }

    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0 && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return result;
    }

    public boolean setFocus() {
        this.checkWidget();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (!child.getVisible() || !child.setFocus()) continue;
            return true;
        }
        return super.setFocus();
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
        this.layout = layout;
    }

    public void setLayoutDeferred(boolean defer) {
        this.checkWidget();
        if (!defer) {
            if (--this.layoutCount == 0 && ((this.state & 0x80000) != 0 || (this.state & 0x20000) != 0)) {
                this.updateLayout(true);
            }
        } else {
            ++this.layoutCount;
        }
    }

    void setOrientation(boolean create) {
        super.setOrientation(create);
        if (!create) {
            int flags = 0x6000000;
            int orientation = this.style & flags;
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].setOrientation(orientation);
            }
            if ((this.style & 0x4000000) != 0 != ((this.style & 0x8000000) != 0)) {
                this.moveChildren(-1);
            }
        }
    }

    boolean setScrollBarVisible(ScrollBar bar, boolean visible) {
        boolean changed = super.setScrollBarVisible(bar, visible);
        if (changed && this.layout != null) {
            this.markLayout(false, false);
            this.updateLayout(false);
        }
        return changed;
    }

    boolean setTabGroupFocus(boolean next) {
        boolean takeFocus;
        if (this.isTabItem()) {
            return this.setTabItemFocus(next);
        }
        boolean bl = takeFocus = (this.style & 0x80000) == 0;
        if ((this.state & 2) != 0) {
            takeFocus = this.hooksKeys();
        }
        if (this.socketHandle != 0L) {
            takeFocus = true;
        }
        if (takeFocus && this.setTabItemFocus(next)) {
            return true;
        }
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (!child.isTabItem() || !child.setTabItemFocus(next)) continue;
            return true;
        }
        return false;
    }

    boolean setTabItemFocus(boolean next) {
        if (!super.setTabItemFocus(next)) {
            return false;
        }
        if (this.socketHandle != 0L) {
            int direction = next ? 0 : 1;
            OS.GTK_WIDGET_UNSET_FLAGS(this.socketHandle, 4096);
            OS.gtk_widget_child_focus(this.socketHandle, direction);
            OS.GTK_WIDGET_SET_FLAGS(this.socketHandle, 4096);
        }
        return true;
    }

    public void setTabList(Control[] tabList) {
        this.checkWidget();
        if (tabList != null) {
            for (int i = 0; i < tabList.length; ++i) {
                Control control = tabList[i];
                if (control == null) {
                    this.error(5);
                }
                if (control.isDisposed()) {
                    this.error(5);
                }
                if (control.parent == this) continue;
                this.error(32);
            }
            Control[] newList = new Control[tabList.length];
            System.arraycopy(tabList, 0, newList, 0, tabList.length);
            tabList = newList;
        }
        this.tabList = tabList;
    }

    void showWidget() {
        super.showWidget();
        if (this.socketHandle != 0L) {
            OS.gtk_widget_show(this.socketHandle);
            this.embeddedHandle = OS.gtk_socket_get_id(this.socketHandle);
        }
        if (this.scrolledHandle == 0L) {
            this.fixStyle(this.handle);
        }
    }

    boolean checkSubwindow() {
        return (this.state & 0x2000000) != 0;
    }

    boolean translateMnemonic(Event event, Control control) {
        if (super.translateMnemonic(event, control)) {
            return true;
        }
        if (control != null) {
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                Control child = children[i];
                if (!child.translateMnemonic(event, control)) continue;
                return true;
            }
        }
        return false;
    }

    int traversalCode(int key, GdkEventKey event) {
        if ((this.state & 2) != 0) {
            if ((this.style & 0x80000) != 0) {
                return 0;
            }
            if (this.hooksKeys()) {
                return 0;
            }
        }
        return super.traversalCode(key, event);
    }

    boolean translateTraversal(GdkEventKey keyEvent) {
        if (this.socketHandle != 0L) {
            return false;
        }
        return super.translateTraversal(keyEvent);
    }

    void updateBackgroundMode() {
        super.updateBackgroundMode();
        Control[] children = this._getChildren();
        for (int i = 0; i < children.length; ++i) {
            children[i].updateBackgroundMode();
        }
    }

    void updateLayout(boolean all) {
        Composite parent = this.findDeferredControl();
        if (parent != null) {
            parent.state |= 0x80000;
            return;
        }
        if ((this.state & 0x20000) != 0) {
            boolean changed = (this.state & 0x40000) != 0;
            this.state &= 0xFFF9FFFF;
            this.display.runSkin();
            this.layout.layout(this, changed);
        }
        if (all) {
            this.state &= 0xFFF7FFFF;
            Control[] children = this._getChildren();
            for (int i = 0; i < children.length; ++i) {
                children[i].updateLayout(all);
            }
        }
    }
}

